/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.config.ConfigCategory;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.Logger;

public class ConfigFile {
    private static final Logger LOG = ResynthMod.getNewLogger();
    private final Map<Class<?>, ? super ConfigCategory> loadedCategories = new HashMap();
    private final CommentedFileConfig config;

    ConfigFile(String file) {
        LOG.info("Loading config file: " + file);
        this.config = (CommentedFileConfig)CommentedFileConfig.builder((String)Objects.requireNonNull(file)).autosave().build();
        try {
            this.config.load();
            LOG.info("File loaded without errors.");
        }
        catch (Exception e) {
            LOG.fatal("Config load failure", (Throwable)e);
            throw e;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LOG.info("Saving config file: " + file + "...");
            this.config.save();
            this.config.close();
            LOG.info("Config file saved!");
        }));
    }

    public <T extends ConfigCategory> T getCategory(Class<T> catClass) {
        ConfigCategory category;
        if (this.loadedCategories.containsKey(catClass)) {
            return (T)this.loadedCategories.get(catClass);
        }
        try {
            category = (ConfigCategory)catClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.error("Failed to instantiate config category class", (Throwable)e);
            throw new IllegalArgumentException("Category class not instantiatable");
        }
        category.initValues(this.config);
        this.loadedCategories.put(catClass, category);
        return (T)category;
    }

    public <T extends ConfigCategory> T loadCategory(T category) {
        Objects.requireNonNull(category).initValues(this.config);
        return category;
    }
}

