/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.config.categories;

import com.ki11erwolf.resynth.config.BooleanConfigValue;
import com.ki11erwolf.resynth.config.ConfigCategory;
import com.ki11erwolf.resynth.config.DoubleConfigValue;
import com.ki11erwolf.resynth.config.IntegerConfigValue;
import com.ki11erwolf.resynth.plant.set.BiochemicalSetProperties;
import com.ki11erwolf.resynth.plant.set.IBiochemicalSetProperties;

public class BiochemicalPlantSetConfig
extends ConfigCategory
implements IBiochemicalSetProperties {
    private static final String PREFIX = "plant-set-";
    private final DoubleConfigValue chanceToGrow;
    private final BooleanConfigValue canUseBonemeal;
    private final IntegerConfigValue numberOfProduceDrops;
    private final DoubleConfigValue seedSpawnChanceFromMob;
    private final DoubleConfigValue seedSpawnChanceFromBulb;

    public BiochemicalPlantSetConfig(String plantSetName, BiochemicalSetProperties defaultProperties) {
        super(PREFIX + plantSetName);
        this.chanceToGrow = new DoubleConfigValue("chance-to-grow", "The chance (percentage) this plant type will grow on a random tick.\nIncrease this number to increase the growth rate of the plant,\ndecrease it to decrease the growth rate of the plant.", defaultProperties.chanceToGrow(), 0.0, 100.0, this);
        this.canUseBonemeal = new BooleanConfigValue("enable-bonemeal", "Set this to true to allow using bonemeal on this specific plant type.", defaultProperties.canBonemeal(), this);
        this.numberOfProduceDrops = new IntegerConfigValue("number-of-produce-drops", "The number of produce item drops this plant type will drop when harvested/fully grownand broken.", defaultProperties.numberOfProduceDrops(), 1, 64, this);
        this.seedSpawnChanceFromMob = new DoubleConfigValue("seed-spawn-chance-from-mob", "The chance (percentage) that this plant types seed will spawn\nwhen the mob that normally drops the final resource is killed.\nSet this to 0 to prevent the seeds from spawning when the mob is killed.", defaultProperties.seedSpawnChanceFromMob(), 0.0, 100.0, this);
        this.seedSpawnChanceFromBulb = new DoubleConfigValue("seed-spawn-chance-from-bulb", "The chance (percentage) that this plant types seed will spawn\nwhen the plants produce (bulb) is smashed.\nSet this to 0 to prevent the seeds from spawning when the bulb is smashed.", defaultProperties.seedSpawnChanceFromBulb(), 0.0, 100.0, this);
    }

    @Override
    public int numberOfProduceDrops() {
        return this.numberOfProduceDrops.getValue();
    }

    @Override
    public float seedSpawnChanceFromMob() {
        return (float)this.seedSpawnChanceFromMob.getValue();
    }

    @Override
    public float seedSpawnChanceFromBulb() {
        return (float)this.seedSpawnChanceFromBulb.getValue();
    }

    @Override
    public boolean canBonemeal() {
        return this.canUseBonemeal.getValue();
    }

    @Override
    public float chanceToGrow() {
        return (float)this.chanceToGrow.getValue();
    }
}

