/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.config.categories;

import com.ki11erwolf.resynth.config.BooleanConfigValue;
import com.ki11erwolf.resynth.config.ConfigCategory;
import com.ki11erwolf.resynth.config.DoubleConfigValue;
import com.ki11erwolf.resynth.config.IntegerConfigValue;
import com.ki11erwolf.resynth.plant.set.CrystallineSetProperties;
import com.ki11erwolf.resynth.plant.set.ICrystallineSetProperties;

public class CrystallinePlantSetConfig
extends ConfigCategory
implements ICrystallineSetProperties {
    private static final String PREFIX = "plant-set-";
    private final BooleanConfigValue canUseBonemeal;
    private final DoubleConfigValue chanceToGrow;
    private final IntegerConfigValue numberOfProduceDrops;
    private final DoubleConfigValue seedSpawnChanceFromOre;
    private final DoubleConfigValue seedSpawnChanceFromShard;

    public CrystallinePlantSetConfig(String plantSetName, CrystallineSetProperties defaultProperties) {
        super(PREFIX + plantSetName);
        this.canUseBonemeal = new BooleanConfigValue("enable-bonemeal", "Set this to true to allow using bonemeal on this specific plant type.", defaultProperties.canBonemeal(), this);
        this.chanceToGrow = new DoubleConfigValue("chance-to-grow", "The chance (percentage) this plant type will grow on a random tick.\nIncrease this number to increase the growth rate of the plant,\ndecrease it to decrease the growth rate of the plant.", defaultProperties.chanceToGrow(), 0.0, 100.0, this);
        this.numberOfProduceDrops = new IntegerConfigValue("number-of-produce-drops", "The number of produce item drops this plant type will drop when fully grown\nand broken.", defaultProperties.numberOfProduceDrops(), 1, 64, this);
        this.seedSpawnChanceFromOre = new DoubleConfigValue("seed-spawn-chance-from-ore", "The chance (percentage) that this plant types seed will spawn\nwhen mining the growable resources ore block. Set this to 0 to\nprevent the seeds from spawning when mining the ore blocks.", defaultProperties.seedSpawnChanceFromOre(), 0.0, 100.0, this);
        this.seedSpawnChanceFromShard = new DoubleConfigValue("seed-spawn-chance-from-shard", "The chance (percentage) that this plant types seed will spawn\nwhen the plants produce (shard) is left in water to despawn.\nSet this to 0 to prevent seed spawning from shards.", defaultProperties.seedSpawnChanceFromShard(), 0.0, 100.0, this);
    }

    @Override
    public boolean canBonemeal() {
        return this.canUseBonemeal.getValue();
    }

    @Override
    public float chanceToGrow() {
        return (float)this.chanceToGrow.getValue();
    }

    @Override
    public int numberOfProduceDrops() {
        return this.numberOfProduceDrops.getValue();
    }

    @Override
    public float seedSpawnChanceFromOre() {
        return (float)this.seedSpawnChanceFromOre.getValue();
    }

    @Override
    public float seedSpawnChanceFromShard() {
        return (float)this.seedSpawnChanceFromShard.getValue();
    }
}

