/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.item;

import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.block.ResynthBlocks;
import com.ki11erwolf.resynth.config.ResynthConfig;
import com.ki11erwolf.resynth.config.categories.MineralHoeConfig;
import com.ki11erwolf.resynth.item.ResynthItem;
import com.ki11erwolf.resynth.item.ResynthItems;
import com.ki11erwolf.resynth.util.BlockInfoProvider;
import com.ki11erwolf.resynth.util.CommonTooltips;
import com.ki11erwolf.resynth.util.EffectsUtil;
import com.ki11erwolf.resynth.util.ExpandingTooltip;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.Logger;

class ItemMineralHoe
extends ResynthItem<ItemMineralHoe> {
    private static final MineralHoeConfig CONFIG = ResynthConfig.GENERAL_CONFIG.getCategory(MineralHoeConfig.class);
    private static final Logger LOG = ResynthMod.getNewLogger();
    private static final String NBT_TAG_CHARGES = "charges";

    ItemMineralHoe(String name) {
        super(new Item.Properties().func_200917_a(1), name);
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ItemMineralHoe.ensureChargesNBT(stack);
        if (stack.func_77978_p() == null) {
            super.func_77624_a(stack, worldIn, tooltip, flagIn);
            return;
        }
        new ExpandingTooltip().setConditionToControlDown().setExpandedTooltip(CommonTooltips.NEW_LINE).setCollapsedTooltip(null).write(tooltip);
        tooltip.add(ItemMineralHoe.getFormattedTooltip("mineral_hoe_charges", TextFormatting.GOLD, ItemMineralHoe.getCharges(stack) > 0 ? TextFormatting.AQUA : TextFormatting.RED, ItemMineralHoe.getCharges(stack)));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    private static void ensureChargesNBT(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            LOG.info("Setting NBT tag on a Mineral Hoe item stack...");
            nbt = new CompoundNBT();
            nbt.func_74768_a(NBT_TAG_CHARGES, Math.min(CONFIG.getInitialCharges(), 2));
            stack.func_77982_d(nbt);
        }
    }

    private static int getCharges(ItemStack stack) {
        ItemMineralHoe.ensureChargesNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        return tag == null ? -1 : tag.func_74762_e(NBT_TAG_CHARGES);
    }

    private static boolean setCharges(ItemStack stack, int charges) {
        ItemMineralHoe.ensureChargesNBT(stack);
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return false;
        }
        tag.func_74768_a(NBT_TAG_CHARGES, charges);
        stack.func_77982_d(tag);
        return true;
    }

    private static boolean incrementCharges(ItemStack stack) {
        int charges = ItemMineralHoe.getCharges(stack);
        if (charges >= CONFIG.getMaxCharges()) {
            return false;
        }
        return ItemMineralHoe.setCharges(stack, charges + 1);
    }

    private static boolean decrementCharges(ItemStack stack) {
        int charges = ItemMineralHoe.getCharges(stack);
        if (charges <= 0) {
            return false;
        }
        return ItemMineralHoe.setCharges(stack, charges - 1);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        boolean success = context.func_195999_j() == null ? false : (context.func_195999_j().func_213453_ef() ? this.onBlockShiftClick(context.func_195991_k(), context.func_195995_a(), context.func_195991_k().func_180495_p(context.func_195995_a()), context.func_195996_i(), context.func_195999_j(), context.func_196000_l()) : this.onBlockClick(context.func_195991_k(), context.func_195995_a(), context.func_195991_k().func_180495_p(context.func_195995_a()), context.func_195996_i(), context.func_195999_j(), context.func_196000_l()));
        return success ? ActionResultType.SUCCESS : ActionResultType.FAIL;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        boolean success = player.func_213453_ef() ? this.onItemShiftClick(world, player, stack) : this.onItemClick(world, player, stack);
        return success ? ActionResult.func_226248_a_((Object)stack) : ActionResult.func_226251_d_((Object)stack);
    }

    private boolean onBlockClick(World world, BlockPos pos, BlockState block, ItemStack item, PlayerEntity player, Direction face) {
        boolean tilled = this.tryTillBlock(world, pos, block, item, player, face);
        if (!tilled) {
            return this.tryGetInfo(world, pos, block, player);
        }
        return true;
    }

    private boolean onBlockShiftClick(World world, BlockPos pos, BlockState block, ItemStack item, PlayerEntity player, Direction face) {
        if (this.tryGrowPlant(player, world, block, pos)) {
            return true;
        }
        return this.tryCharge(world, player, item);
    }

    private boolean onItemClick(World world, PlayerEntity player, ItemStack item) {
        return this.tryCharge(world, player, item);
    }

    private boolean onItemShiftClick(World world, PlayerEntity player, ItemStack item) {
        boolean charged = this.tryCharge(world, player, item);
        if (!charged) {
            this.displayCharges(world, player, item);
        }
        return charged;
    }

    private boolean tryCharge(World world, PlayerEntity player, ItemStack item) {
        int charges = ItemMineralHoe.getCharges(item);
        if (charges >= CONFIG.getMaxCharges()) {
            return false;
        }
        if ((player.func_184812_l_() || this.tryTakeCrystal(player)) && ItemMineralHoe.incrementCharges(item)) {
            if (CONFIG.playChargeSound()) {
                EffectsUtil.playNormalSound(world, player, player.func_180425_c(), SoundEvents.field_193808_ex, SoundCategory.BLOCKS);
            }
            this.displayCharges(world, player, item);
            return true;
        }
        return false;
    }

    private boolean tryTakeCrystal(PlayerEntity player) {
        for (ItemStack itemStack : player.field_71069_bz.func_75138_a()) {
            if (itemStack.func_77973_b() != ResynthItems.ITEM_MINERAL_CRYSTAL) continue;
            itemStack.func_190918_g(1);
            return true;
        }
        return false;
    }

    private void displayCharges(World world, PlayerEntity player, ItemStack item) {
        if (!world.field_72995_K) {
            return;
        }
        player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GOLD + ItemMineralHoe.getFormattedTooltip("mineral_hoe_charges", TextFormatting.GRAY, new Object[0]).func_150254_d() + TextFormatting.GREEN + ItemMineralHoe.getCharges(item)));
    }

    private boolean tryTillBlock(World world, BlockPos pos, BlockState state, ItemStack item, PlayerEntity player, Direction face) {
        if (state.func_177230_c() != Blocks.field_150346_d && state.func_177230_c() != Blocks.field_196658_i) {
            return false;
        }
        if (face == Direction.DOWN || !world.func_175623_d(pos.func_177984_a())) {
            return false;
        }
        if (!player.func_184812_l_() && ItemMineralHoe.getCharges(item) <= 0) {
            if (CONFIG.playFailSound()) {
                EffectsUtil.playNormalSound(world, player, pos, SoundEvents.field_187685_dH, SoundCategory.BLOCKS);
            }
            return false;
        }
        boolean replaced = this.tillBlock(world, pos, player);
        if (replaced && !player.func_184812_l_()) {
            ItemMineralHoe.decrementCharges(item);
        }
        return replaced;
    }

    private boolean tillBlock(World world, BlockPos pos, PlayerEntity player) {
        boolean replaced = world.func_175656_a(pos, ResynthBlocks.BLOCK_MINERAL_SOIL.func_176223_P());
        if (replaced) {
            if (CONFIG.showParticles()) {
                EffectsUtil.displayStandardEffects(world, pos.func_177984_a(), 5, (IParticleData)ParticleTypes.field_197631_x);
            }
            EffectsUtil.playNormalSound(world, player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS);
        }
        return replaced;
    }

    private boolean tryGetInfo(World world, BlockPos pos, BlockState block, PlayerEntity player) {
        if (!(block.func_177230_c() instanceof BlockInfoProvider)) {
            return false;
        }
        if (world.field_72995_K) {
            return false;
        }
        BlockInfoProvider infoProvider = (BlockInfoProvider)block.func_177230_c();
        player.func_145747_a((ITextComponent)new StringTextComponent(this.getInfoFromProvider(infoProvider, world, pos, block)));
        return true;
    }

    private String getInfoFromProvider(BlockInfoProvider provider, World world, BlockPos pos, BlockState block) {
        ArrayList<String> informationList = new ArrayList<String>();
        provider.appendBlockInformation(informationList, world, pos, block);
        StringBuilder informationText = new StringBuilder();
        for (String informationLine : informationList) {
            informationText.append(informationLine).append("\n");
        }
        return informationText.toString();
    }

    private boolean tryGrowPlant(PlayerEntity player, World world, BlockState block, BlockPos pos) {
        if (!player.func_184812_l_()) {
            return false;
        }
        if (block.func_177230_c() instanceof IGrowable) {
            if (!world.field_72995_K) {
                ((IGrowable)block.func_177230_c()).func_225535_a_((ServerWorld)world, field_77697_d, pos, world.func_180495_p(pos));
            }
            return true;
        }
        return false;
    }
}

