/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.block;

import com.ki11erwolf.resynth.plant.block.BlockPlant;
import com.ki11erwolf.resynth.plant.set.ICrystallineSetProperties;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.IntegerProperty;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.World;

public abstract class BlockCrystallinePlant
extends BlockPlant<BlockCrystallinePlant> {
    public BlockCrystallinePlant(String plantTypeName, String plantName, ICrystallineSetProperties properties) {
        super(plantTypeName, plantName, properties);
    }

    @Override
    IntegerProperty getGrowthProperty() {
        return IntegerProperty.func_177719_a((String)"growth_stage", (int)0, (int)7);
    }

    @Override
    VoxelShape[] getShapeByAge() {
        return new VoxelShape[]{Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0), Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)3.5, (double)11.0), Block.func_208617_a((double)4.5, (double)0.0, (double)4.5, (double)11.5, (double)5.0, (double)11.5), Block.func_208617_a((double)2.5, (double)0.0, (double)2.5, (double)13.5, (double)7.5, (double)13.5), Block.func_208617_a((double)2.5, (double)0.0, (double)2.5, (double)13.5, (double)7.5, (double)13.5), Block.func_208617_a((double)0.5, (double)0.5, (double)0.5, (double)15.5, (double)11.0, (double)15.5), Block.func_208617_a((double)0.5, (double)0.0, (double)0.5, (double)15.5, (double)14.0, (double)15.5), Block.func_208617_a((double)0.5, (double)0.0, (double)0.5, (double)15.5, (double)15.0, (double)15.5)};
    }

    @Override
    public int getMaxGrowthStage() {
        return 7;
    }

    @Override
    boolean dropsProduceWhenGrown() {
        return true;
    }

    @Override
    protected int postHarvestGrowthStageReset() {
        return 0;
    }

    @Override
    protected int postHarvestNumberOfProduceDrops() {
        return ((ICrystallineSetProperties)this.properties).numberOfProduceDrops();
    }

    @Override
    protected SoundEvent postHarvestSoundEvent() {
        return SoundEvents.field_219626_bz;
    }

    @Override
    void growPlant(World world, BlockState state, BlockPos pos, int increase) {
        int growth = increase + this.getGrowthStage(state);
        if (growth > this.getMaxGrowthStage()) {
            growth = this.getMaxGrowthStage();
        }
        if (this.tryAutoFarmDump(growth, world, pos)) {
            this.setGrowthStage(world, pos, 0);
        } else {
            this.setGrowthStage(world, pos, growth);
        }
    }
}

