/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.item;

import com.ki11erwolf.resynth.ResynthTabs;
import com.ki11erwolf.resynth.item.ResynthItem;
import com.ki11erwolf.resynth.plant.set.IBiochemicalSetProperties;
import com.ki11erwolf.resynth.util.EffectsUtil;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ItemBulb
extends ResynthItem<ItemBulb> {
    private static final String PREFIX = "bulb";
    private final IBiochemicalSetProperties setProperties;

    public ItemBulb(String setTypeName, String setName, IBiochemicalSetProperties properties) {
        super(setTypeName + "_" + PREFIX + "_" + setName, ResynthTabs.TAB_RESYNTH_PRODUCE);
        this.setProperties = properties;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entityLiving) {
        if (world.field_72995_K) {
            ItemBulb.playSmashSound(world, entityLiving);
        }
        if (!(entityLiving instanceof ServerPlayerEntity)) {
            return stack;
        }
        if (!((PlayerEntity)entityLiving).func_184812_l_()) {
            stack.func_190918_g(1);
        }
        ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)((PlayerEntity)entityLiving), (ItemStack)stack, (Hand)Hand.MAIN_HAND);
        return stack;
    }

    private static void playSmashSound(World world, LivingEntity player) {
        if (player instanceof PlayerEntity) {
            EffectsUtil.playNormalSoundWithPitchInRage(world, (PlayerEntity)player, SoundEvents.field_187561_bM, SoundCategory.PLAYERS, 0.8f, 0.4f);
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 10;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ItemBulb.addPlantItemTooltips(tooltip, this.setProperties, PREFIX);
    }
}

