/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.item;

import com.ki11erwolf.resynth.ResynthTabs;
import com.ki11erwolf.resynth.item.ResynthItem;
import com.ki11erwolf.resynth.plant.set.PlantSetProperties;
import com.ki11erwolf.resynth.util.EffectsUtil;
import com.ki11erwolf.resynth.util.Tooltip;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class ItemSeeds
extends ResynthItem<ItemSeeds>
implements IPlantable {
    private static final String PREFIX = "seeds";
    private final BlockState plant;
    private final String setTypeName;
    private final PlantSetProperties setProperties;
    private boolean isFailure = false;

    public ItemSeeds(String setType, String setName, Block plant, PlantSetProperties setProperties) {
        super(setType + "_" + PREFIX + "_" + setName, ResynthTabs.TAB_RESYNTH_SEEDS);
        this.setTypeName = setType;
        this.setProperties = setProperties;
        this.plant = plant.func_176223_P();
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (this.isFailure) {
            return ActionResultType.FAIL;
        }
        World world = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a().func_177984_a();
        if (context.func_196000_l() == Direction.UP && world.func_175623_d(blockpos) && this.plant.func_196955_c((IWorldReader)world, blockpos)) {
            world.func_180501_a(blockpos, this.plant, 11);
            ItemStack itemstack = context.func_195996_i();
            PlayerEntity playerEntity = context.func_195999_j();
            if (playerEntity instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)playerEntity, blockpos, itemstack);
            }
            itemstack.func_190918_g(1);
            EffectsUtil.playNormalSound(world.func_201672_e(), playerEntity, blockpos, SoundEvents.field_219626_bz, SoundCategory.BLOCKS);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.isFailure) {
            Tooltip.addBlankLine(tooltip).add(ItemSeeds.getFormattedTooltip("seeds.failure", TextFormatting.RED, new Object[0]));
        }
        ItemSeeds.addPlantItemTooltips(tooltip, this.setProperties, String.format("%s_%s", this.setTypeName, PREFIX));
    }

    public BlockState getPlant(IBlockReader world, BlockPos pos) {
        return this.plant;
    }

    public void flagAsFailure() {
        this.isFailure = true;
    }
}

