/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.util;

import com.ki11erwolf.resynth.util.Tooltip;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public enum CommonTooltips implements Tooltip
{
    SHIFT_FOR_STATS("shift_for_stats", TextFormatting.GOLD),
    CTRL_FOR_DESCRIPTION("ctrl_for_description", TextFormatting.GREEN),
    ALT_FOR_ADDITIONAL_INFO("alt_for_info", TextFormatting.DARK_PURPLE),
    UNSPECIFIED("unspecified", TextFormatting.RED, TextFormatting.RED),
    NEW_LINE(null, null, null){

        @Override
        public void write(List<ITextComponent> tooltip) {
            tooltip.add(Tooltip.toTextComponent(""));
        }
    }
    ,
    NULL(null, null, null){

        @Override
        public void write(List<ITextComponent> tooltip) {
        }
    };

    private static final String KEY_PREFIX = "tooltip.resynth.common.";
    private final String tooltipKey;
    private final TextFormatting baseColor;
    private final TextFormatting highlightColor;

    private CommonTooltips(String tooltipKey, TextFormatting baseColor) {
        this(tooltipKey, TextFormatting.GRAY, baseColor);
    }

    private CommonTooltips(String tooltipKey, TextFormatting baseColor, TextFormatting highlightColor) {
        this.tooltipKey = tooltipKey;
        this.baseColor = baseColor;
        this.highlightColor = highlightColor;
    }

    @Override
    public void write(List<ITextComponent> tooltip) {
        tooltip.add(Tooltip.toTextComponent(this.baseColor + Tooltip.localize(KEY_PREFIX + this.tooltipKey, this.highlightColor, this.baseColor)));
    }
}

