/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.util;

import com.ki11erwolf.resynth.block.BlockEnhancer;
import com.ki11erwolf.resynth.block.BlockMineralSoil;
import com.ki11erwolf.resynth.block.tileEntity.TileEntityMineralSoil;
import com.ki11erwolf.resynth.plant.block.BlockBiochemicalPlant;
import com.ki11erwolf.resynth.plant.block.BlockCrystallinePlant;
import com.ki11erwolf.resynth.plant.block.BlockMetallicPlant;
import com.ki11erwolf.resynth.plant.block.BlockPlant;
import com.ki11erwolf.resynth.util.BlockInfoProvider;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public interface PlantPatchInfoProvider
extends BlockInfoProvider {
    @Override
    default public void appendBlockInformation(List<String> information, World world, BlockPos pos, BlockState block) {
        PPIPHelper.appendBlockInformation(information, world, pos, block);
    }

    public static final class PPIPHelper {
        private PPIPHelper() {
        }

        private static void appendBlockInformation(List<String> information, World world, BlockPos pos, BlockState block) {
            BlockPos plantPos;
            BlockPos soilPos;
            if (block.func_177230_c() instanceof BlockMineralSoil) {
                soilPos = pos;
                plantPos = pos.func_177984_a();
            } else if (block.func_177230_c() instanceof BlockPlant) {
                plantPos = pos;
                soilPos = pos.func_177977_b();
            } else {
                information.add("Error!");
                return;
            }
            PPIPHelper.appendMineralSoilInformation(information, world, soilPos);
            PPIPHelper.appendPlantInformation(information, world, plantPos);
        }

        private static void appendMineralSoilInformation(List<String> information, World world, BlockPos pos) {
            String enhancerIncrease;
            information.add(TextFormatting.GRAY + "---------- Mineral Soil Info -----------");
            TileEntityMineralSoil entity = PPIPHelper.getTileEntity(world, pos);
            information.add(TextFormatting.GREEN + "Mineral Content: " + TextFormatting.GOLD + entity.getMineralPercentage() + "%");
            BlockState enhancer = world.func_180495_p(pos.func_177977_b());
            float combined = entity.getMineralPercentage();
            boolean hasEnhancer = false;
            if (enhancer.func_177230_c() instanceof BlockEnhancer) {
                hasEnhancer = true;
                if (entity.getMineralPercentage() < 50.0f) {
                    enhancerIncrease = TextFormatting.RED + "Not Enabled  (Need 50% concentration)!";
                    combined += 0.0f;
                } else {
                    BlockEnhancer enhancerBlock = (BlockEnhancer)enhancer.func_177230_c();
                    enhancerIncrease = enhancerBlock.getIncrease() + "%";
                    combined += enhancerBlock.getIncrease();
                }
            } else {
                enhancerIncrease = "No Enhancer!";
            }
            if (hasEnhancer) {
                information.add(TextFormatting.LIGHT_PURPLE + "Enhancer Increase: " + TextFormatting.GOLD + enhancerIncrease);
                if (combined != entity.getMineralPercentage()) {
                    information.add(TextFormatting.AQUA + "Combined Mineral Content: " + TextFormatting.GOLD + combined + "%");
                }
            }
        }

        private static void appendPlantInformation(List<String> information, World world, BlockPos pos) {
            BlockState plantBlockState = world.func_180495_p(pos);
            Block plantBlock = plantBlockState.func_177230_c();
            information.add(TextFormatting.GRAY + "------------- Plant Info -------------");
            if (!(plantBlock instanceof BlockPlant)) {
                information.add(TextFormatting.RED + "No Plant!");
                information.add(TextFormatting.GRAY + "------------------------------------");
                return;
            }
            BlockPlant blockPlant = (BlockPlant)plantBlock;
            information.add(TextFormatting.YELLOW + "Specific Plant: " + TextFormatting.GOLD + blockPlant.getRegistryName());
            String plantType = blockPlant instanceof BlockBiochemicalPlant ? "Biochemical" : (blockPlant instanceof BlockMetallicPlant ? "Metallic" : (blockPlant instanceof BlockCrystallinePlant ? "Crystalline" : "Error!"));
            information.add(TextFormatting.DARK_AQUA + "Plant Type: " + TextFormatting.GOLD + plantType);
            information.add(TextFormatting.DARK_PURPLE + "Growth Stage: " + TextFormatting.GOLD + (blockPlant.getGrowthStage(plantBlockState) + 1) + TextFormatting.DARK_PURPLE + " of " + TextFormatting.GOLD + (blockPlant.getMaxGrowthStage() + 1));
            information.add(TextFormatting.BLUE + "Growth Chance: " + TextFormatting.GOLD + ((BlockPlant)plantBlock).getProperties().chanceToGrow() + "%");
            float plantGrowthChance = ((BlockPlant)plantBlock).getProperties().chanceToGrow() / 100.0f;
            TileEntityMineralSoil entity = PPIPHelper.getTileEntity(world, pos.func_177977_b());
            float mineralSoilConcentration = entity.getMineralPercentage();
            BlockState enhancer = world.func_180495_p(pos.func_177977_b().func_177977_b());
            float enhancerIncrease = 0.0f;
            if (enhancer.func_177230_c() instanceof BlockEnhancer) {
                enhancerIncrease = ((BlockEnhancer)enhancer.func_177230_c()).getIncrease();
            }
            float combinedChance = (enhancerIncrease + mineralSoilConcentration) / 100.0f;
            float finalChance = combinedChance * plantGrowthChance * 100.0f;
            double roundedFinalChance = (double)Math.round(finalChance * 100.0f) / 100.0;
            information.add(TextFormatting.DARK_GREEN + "Final Growth Chance: " + TextFormatting.GOLD + roundedFinalChance + "%");
            information.add(TextFormatting.GRAY + "------------------------------------");
        }

        private static TileEntityMineralSoil getTileEntity(World world, BlockPos pos) {
            return (TileEntityMineralSoil)world.func_175625_s(pos);
        }
    }
}

