/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.ITooltipRenderer;
import mcp.mobius.waila.api.impl.WailaRegistrar;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.StringTextComponent;

public class RenderableTextComponent
extends StringTextComponent {
    public RenderableTextComponent(ResourceLocation id, CompoundNBT data) {
        super(RenderableTextComponent.getRenderString(id, data));
    }

    public RenderableTextComponent(RenderableTextComponent ... components) {
        super(RenderableTextComponent.getRenderString(components));
    }

    public List<RenderContainer> getRenderers() {
        ArrayList renderers = Lists.newArrayList();
        CompoundNBT data = this.getData();
        if (data.func_74764_b("renders")) {
            ListNBT list = data.func_150295_c("renders", 8);
            list.forEach(t -> {
                StringNBT stringTag = (StringNBT)t;
                try {
                    CompoundNBT tag = JsonToNBT.func_180713_a((String)stringTag.func_150285_a_());
                    ResourceLocation id = new ResourceLocation(tag.func_74779_i("id"));
                    CompoundNBT dataTag = tag.func_74775_l("data");
                    renderers.add(new RenderContainer(id, dataTag));
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            });
        } else {
            ResourceLocation id = new ResourceLocation(data.func_74779_i("id"));
            CompoundNBT dataTag = data.func_74775_l("data");
            renderers.add(new RenderContainer(id, dataTag));
        }
        return renderers;
    }

    private CompoundNBT getData() {
        try {
            return JsonToNBT.func_180713_a((String)this.func_150254_d());
        }
        catch (CommandSyntaxException e) {
            return new CompoundNBT();
        }
    }

    private static String getRenderString(ResourceLocation id, CompoundNBT data) {
        CompoundNBT renderData = new CompoundNBT();
        renderData.func_74778_a("id", id.toString());
        renderData.func_218657_a("data", (INBT)data);
        return renderData.toString();
    }

    private static String getRenderString(RenderableTextComponent ... components) {
        CompoundNBT container = new CompoundNBT();
        ListNBT renderData = new ListNBT();
        for (RenderableTextComponent component : components) {
            renderData.add((Object)StringNBT.func_229705_a_((String)component.func_150254_d()));
        }
        container.func_218657_a("renders", (INBT)renderData);
        return container.toString();
    }

    public static class RenderContainer {
        private final ResourceLocation id;
        private final CompoundNBT data;
        private final ITooltipRenderer renderer;

        public RenderContainer(ResourceLocation id, CompoundNBT data) {
            this.id = id;
            this.data = data;
            this.renderer = WailaRegistrar.INSTANCE.getTooltipRenderer(id);
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public CompoundNBT getData() {
            return this.data;
        }

        public ITooltipRenderer getRenderer() {
            return this.renderer;
        }
    }
}

