/*
 * Decompiled with CFR 0.152.
 */
package com.ghen.rocksrevolution;

import com.ghen.rocksrevolution.client.ClientHandler;
import com.ghen.rocksrevolution.init.ModBlocks;
import com.ghen.rocksrevolution.init.ModEntityTypes;
import com.ghen.rocksrevolution.init.ModItems;
import com.ghen.rocksrevolution.world.ModEntitySpawns;
import java.util.stream.Collectors;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="rocksrevolution")
public class RocksRevolution {
    public static final String MOD_ID = "rocksrevolution";
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ItemGroup TAB = new ItemGroup("rocksrevolutionTab"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ModItems.ROCKY_AMALGAMATE.get());
        }
    };

    public RocksRevolution() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onCommonSetup);
        ModBlocks.Init();
        ModItems.Init();
        ModEntityTypes.Init();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        ModEntityTypes.registerEntityTypeAttributes();
        ModEntitySpawns.entitySpawnPlacementRegistry();
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        ClientHandler.setup();
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"examplemod", (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }
}

