/*
 * Decompiled with CFR 0.152.
 */
package eu.lunekiska.scythd.compat.tooldefs;

import com.google.common.collect.ImmutableMultimap;
import eu.lunekiska.scythd.utils.ScythdReapBlocks;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.client.render.item.ISTERProvider;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.gear.ItemAtomicDisassembler;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.item.interfaces.IRadialModeItem;
import mekanism.common.network.PacketLightningRender;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class AtomicDisassemblerTool
extends ItemAtomicDisassembler
implements IItemHUDProvider,
IModeItem,
IRadialModeItem<ItemAtomicDisassembler.DisassemblerMode> {
    protected int harvestRadius;
    protected boolean circleHarvest;

    public AtomicDisassemblerTool(Item.Properties properties, int harvestRadius, boolean circleHarvest) {
        super(properties.func_208103_a(Rarity.RARE).setNoRepair().setISTER(ISTERProvider::disassembler));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.4, AttributeModifier.Operation.ADDITION));
        this.harvestRadius = harvestRadius;
        this.circleHarvest = circleHarvest;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull PlayerEntity user, @Nonnull Hand hand) {
        return ScythdReapBlocks.harvest(this.harvestRadius, this.circleHarvest, world, user, hand);
    }

    public boolean func_179218_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull LivingEntity entityliving) {
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer((ItemStack)stack, (int)0);
        if (energyContainer != null) {
            energyContainer.extract(this.getDestroyEnergy(stack, state.func_185887_b((IBlockReader)world, pos)), Action.EXECUTE, AutomationType.MANUAL);
        }
        return true;
    }

    public FloatingLong getDestroyEnergy(ItemStack itemStack, float hardness) {
        FloatingLong destroyEnergy = ((FloatingLong)MekanismConfig.gear.disassemblerEnergyUsage.get()).multiply((long)this.getMode(itemStack).getEfficiency());
        return hardness == 0.0f ? destroyEnergy.divide(2L) : destroyEnergy;
    }

    public static List<BlockPos> findPositions(BlockState state, BlockPos location, World world, int maxRange) {
        ArrayList<BlockPos> found = new ArrayList<BlockPos>();
        ObjectOpenHashSet checked = new ObjectOpenHashSet();
        found.add(location);
        Block startBlock = state.func_177230_c();
        int maxCount = MekanismConfig.gear.disassemblerMiningCount.get() - 1;
        for (int i = 0; i < found.size(); ++i) {
            BlockPos blockPos = (BlockPos)found.get(i);
            checked.add(blockPos);
            for (BlockPos pos : BlockPos.func_218278_a((BlockPos)blockPos.func_177982_a(-1, -1, -1), (BlockPos)blockPos.func_177982_a(1, 1, 1))) {
                Optional blockState;
                if (checked.contains(pos) || maxRange != -1 && !(WorldUtils.distanceBetween((BlockPos)location, (BlockPos)pos) <= (double)maxRange) || !(blockState = WorldUtils.getBlockState((IBlockReader)world, (BlockPos)pos)).isPresent() || startBlock != ((BlockState)blockState.get()).func_177230_c()) continue;
                found.add(pos.func_185334_h());
                Mekanism.packetHandler.sendToAllTracking((Object)new PacketLightningRender(PacketLightningRender.LightningPreset.TOOL_AOE, Objects.hash(blockPos, pos), Vector3d.func_237489_a_((Vector3i)blockPos), Vector3d.func_237489_a_((Vector3i)pos), 10), world, blockPos);
                if (found.size() <= maxCount) continue;
                return found;
            }
        }
        return found;
    }
}

