/*
 * Decompiled with CFR 0.152.
 */
package eu.lunekiska.scythd.compat.tooldefs;

import eu.lunekiska.scythd.utils.ScythdReapBlocks;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.HoeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BetterEndScytheTool
extends HoeItem {
    protected int harvestRadius;
    protected boolean circleHarvest;
    private int mineLevel = -1;

    public BetterEndScytheTool(IItemTier material, int attackDamage, float attackSpeed, Item.Properties properties) {
        this(material, attackDamage, attackSpeed, BetterEndScytheTool.getRadius(material), BetterEndScytheTool.shouldBeCircle(material), properties);
        this.mineLevel = material.func_200925_d();
    }

    public BetterEndScytheTool(IItemTier material, int attackDamage, float attackSpeed, int harvestRadius, boolean circleHarvest, Item.Properties properties) {
        super(material, attackDamage, attackSpeed, properties);
        this.harvestRadius = harvestRadius;
        this.circleHarvest = circleHarvest;
    }

    private static int getRadius(IItemTier material) {
        return (int)(Math.floor((double)material.func_200925_d() / 2.0) + 1.0);
    }

    private static boolean shouldBeCircle(IItemTier material) {
        return material.func_200925_d() % 2 == 0;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull PlayerEntity user, @Nonnull Hand hand) {
        return ScythdReapBlocks.harvest(this.harvestRadius, this.circleHarvest, world, user, hand);
    }

    @Nonnull
    public ActionResultType func_195939_a(@Nonnull ItemUseContext context) {
        BlockPos pos;
        World world;
        BlockState state;
        ActionResultType result = super.func_195939_a(context);
        if (result.func_226246_a_() && (state = (world = context.func_195991_k()).func_180495_p(pos = context.func_195995_a())).func_235901_b_((Property)FarmlandBlock.field_176531_a)) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)FarmlandBlock.field_176531_a, (Comparable)Integer.valueOf(0)));
        }
        return result;
    }

    public int getHarvestRadius() {
        return this.harvestRadius;
    }

    public boolean hasCircleHarvest() {
        return this.circleHarvest;
    }
}

