/*
 * Decompiled with CFR 0.152.
 */
package eu.lunekiska.scythd.compat.tooldefs;

import com.google.common.collect.ImmutableMultimap;
import eu.lunekiska.scythd.utils.ScythdReapBlocks;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.IModuleContainerItem;
import mekanism.common.content.gear.Modules;
import mekanism.common.content.gear.mekatool.ModuleExcavationEscalationUnit;
import mekanism.common.item.gear.ItemMekaTool;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.util.StorageUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class MekaTool
extends ItemMekaTool
implements IModuleContainerItem,
IModeItem,
IItemHUDProvider {
    protected int harvestRadius;
    protected boolean circleHarvest;

    public MekaTool(Item.Properties properties, int harvestRadius, boolean circleHarvest) {
        super(properties.func_208103_a(Rarity.EPIC).setNoRepair());
        Modules.setSupported((Item)this, (Modules.ModuleData[])new Modules.ModuleData[]{Modules.ENERGY_UNIT, Modules.ATTACK_AMPLIFICATION_UNIT, Modules.SILK_TOUCH_UNIT, Modules.VEIN_MINING_UNIT, Modules.FARMING_UNIT, Modules.TELEPORTATION_UNIT, Modules.EXCAVATION_ESCALATION_UNIT});
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.4, AttributeModifier.Operation.ADDITION));
        this.harvestRadius = harvestRadius;
        this.circleHarvest = circleHarvest;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull PlayerEntity user, @Nonnull Hand hand) {
        return ScythdReapBlocks.harvest(this.harvestRadius, this.circleHarvest, world, user, hand);
    }

    public boolean func_179218_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull LivingEntity entityliving) {
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer((ItemStack)stack, (int)0);
        if (energyContainer != null) {
            energyContainer.extract(this.getDestroyEnergy(stack, state.func_185887_b((IBlockReader)world, pos), false), Action.EXECUTE, AutomationType.MANUAL);
        }
        return true;
    }

    private FloatingLong getDestroyEnergy(ItemStack itemStack, float hardness, boolean silk) {
        FloatingLong destroyEnergy = silk ? (FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageSilk.get() : (FloatingLong)MekanismConfig.gear.mekaToolEnergyUsage.get();
        ModuleExcavationEscalationUnit module = (ModuleExcavationEscalationUnit)Modules.load((ItemStack)itemStack, (Modules.ModuleData)Modules.EXCAVATION_ESCALATION_UNIT);
        double efficiency = module != null && module.isEnabled() ? module.getEfficiency() : (double)MekanismConfig.gear.mekaToolBaseEfficiency.get();
        destroyEnergy = destroyEnergy.multiply(efficiency);
        return hardness == 0.0f ? destroyEnergy.divide(2L) : destroyEnergy;
    }
}

