/*
 * Decompiled with CFR 0.152.
 */
package xyz.dogboy.swp.blocks;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import xyz.dogboy.swp.Registry;
import xyz.dogboy.swp.blocks.BlockWoodenVariation;
import xyz.dogboy.swp.config.SWPConfig;
import xyz.dogboy.swp.tiles.TilePipe;

public class BlockPipe
extends BlockWoodenVariation {
    private static ItemStack extractionUpgrade;
    public static final PropertyBool NORTH;
    public static final PropertyBool EAST;
    public static final PropertyBool SOUTH;
    public static final PropertyBool WEST;
    public static final PropertyBool UP;
    public static final PropertyBool DOWN;
    public static final PropertyBool EXTRACTION;
    public static final PropertyBool EXTRACT_NORTH;
    public static final PropertyBool EXTRACT_EAST;
    public static final PropertyBool EXTRACT_SOUTH;
    public static final PropertyBool EXTRACT_WEST;
    public static final PropertyBool EXTRACT_UP;
    public static final PropertyBool EXTRACT_DOWN;
    public static final AxisAlignedBB MIDDLE_BB;
    public static final AxisAlignedBB NORTH_BB;
    public static final AxisAlignedBB EAST_BB;
    public static final AxisAlignedBB SOUTH_BB;
    public static final AxisAlignedBB WEST_BB;
    public static final AxisAlignedBB UP_BB;
    public static final AxisAlignedBB DOWN_BB;
    public static final List<ItemStack> stoneVariants;

    public BlockPipe() {
        super("pipe", Material.field_151575_d, MapColor.field_151663_o);
        this.func_149711_c(1.0f);
        this.func_149752_b(2.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EXTRACTION, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EXTRACT_NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EXTRACT_EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EXTRACT_SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EXTRACT_WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EXTRACT_UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EXTRACT_DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (!isActualState) {
            state = state.func_185899_b((IBlockAccess)worldIn, pos);
        }
        Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)MIDDLE_BB);
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_BB);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_BB);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_BB);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_BB);
        }
        if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue()) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)UP_BB);
        }
        if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)DOWN_BB);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = this.func_176221_a(state, source, pos);
        AxisAlignedBB boundingBox = MIDDLE_BB;
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            boundingBox = boundingBox.func_111270_a(NORTH_BB);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            boundingBox = boundingBox.func_111270_a(EAST_BB);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            boundingBox = boundingBox.func_111270_a(SOUTH_BB);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            boundingBox = boundingBox.func_111270_a(WEST_BB);
        }
        if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue()) {
            boundingBox = boundingBox.func_111270_a(UP_BB);
        }
        if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            boundingBox = boundingBox.func_111270_a(DOWN_BB);
        }
        return boundingBox;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TilePipe pipe = (TilePipe)worldIn.func_175625_s(pos);
        if (pipe == null) {
            return false;
        }
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)playerIn.func_184586_b(hand).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (fluidHandler != null) {
            return this.handleFluidHandlerActivate(playerIn, hand, pipe, fluidHandler);
        }
        ItemStack extractUpgrade = BlockPipe.getExtractionUpgrade();
        if (BlockPipe.areItemStacksEqual(playerIn.func_184586_b(hand), extractUpgrade) || playerIn.func_70093_af()) {
            return this.handleExtractUpgradeActivate(playerIn, hand, pipe);
        }
        return false;
    }

    private boolean handleFluidHandlerActivate(EntityPlayer playerIn, EnumHand hand, TilePipe pipe, IFluidHandlerItem fluidHandler) {
        IFluidTankProperties tankProperties = pipe.getTankProperties()[0];
        int maxDrain = tankProperties.getCapacity() - (tankProperties.getContents() == null ? 0 : tankProperties.getContents().amount);
        if (maxDrain <= 0) {
            return false;
        }
        FluidStack drained = fluidHandler.drain(maxDrain, false);
        if (drained == null) {
            return false;
        }
        maxDrain = pipe.fill(drained, false);
        if (maxDrain <= 0) {
            return false;
        }
        drained = fluidHandler.drain(maxDrain, true);
        if (drained == null) {
            return false;
        }
        pipe.fill(drained, true);
        playerIn.func_184611_a(hand, fluidHandler.getContainer());
        return true;
    }

    private boolean handleExtractUpgradeActivate(EntityPlayer playerIn, EnumHand hand, TilePipe pipe) {
        if (playerIn.func_70093_af()) {
            ItemStack extractUpgrade;
            if (!pipe.isExtractionEnabled()) {
                return false;
            }
            pipe.setExtractionEnabled(false);
            if (!playerIn.field_71075_bZ.field_75098_d && !playerIn.func_191521_c(extractUpgrade = BlockPipe.getExtractionUpgrade())) {
                playerIn.func_71019_a(extractUpgrade, false);
            }
            playerIn.func_184185_a(SoundEvents.field_187692_g, 1.0f, 1.0f);
        } else {
            if (pipe.isExtractionEnabled()) {
                return false;
            }
            pipe.setExtractionEnabled(true);
            if (!playerIn.field_71075_bZ.field_75098_d) {
                playerIn.func_184586_b(hand).func_190918_g(1);
            }
            playerIn.func_184185_a(SoundEvents.field_187604_bf, 1.0f, 1.0f);
        }
        return true;
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound baseBlock = stack.func_77978_p().func_74775_l("BaseBlock");
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TilePipe) {
            tileEntity.getTileData().func_74782_a("BaseBlock", (NBTBase)baseBlock);
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TilePipe();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, EXTRACTION, EXTRACT_NORTH, EXTRACT_EAST, EXTRACT_SOUTH, EXTRACT_WEST, EXTRACT_UP, EXTRACT_DOWN}, new IUnlistedProperty[]{BlockWoodenVariation.TEXTURE});
    }

    public boolean canConnectTo(IBlockAccess world, BlockPos pipePos, EnumFacing direction, boolean excludePipe) {
        TileEntity pipeTileEntity = world.func_175625_s(pipePos);
        if (pipeTileEntity instanceof TilePipe) {
            return ((TilePipe)pipeTileEntity).canConnectTo(direction, excludePipe);
        }
        return false;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn instanceof ChunkCache ? ((ChunkCache)worldIn).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : worldIn.func_175625_s(pos);
        boolean extraction = tileentity instanceof TilePipe && ((TilePipe)tileentity).isExtractionEnabled();
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos, EnumFacing.NORTH, false))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos, EnumFacing.EAST, false))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos, EnumFacing.SOUTH, false))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos, EnumFacing.WEST, false))).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos, EnumFacing.UP, false))).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos, EnumFacing.DOWN, false))).func_177226_a((IProperty)EXTRACTION, (Comparable)Boolean.valueOf(extraction)).func_177226_a((IProperty)EXTRACT_NORTH, (Comparable)Boolean.valueOf(extraction && this.canConnectTo(worldIn, pos, EnumFacing.NORTH, true))).func_177226_a((IProperty)EXTRACT_EAST, (Comparable)Boolean.valueOf(extraction && this.canConnectTo(worldIn, pos, EnumFacing.EAST, true))).func_177226_a((IProperty)EXTRACT_SOUTH, (Comparable)Boolean.valueOf(extraction && this.canConnectTo(worldIn, pos, EnumFacing.SOUTH, true))).func_177226_a((IProperty)EXTRACT_WEST, (Comparable)Boolean.valueOf(extraction && this.canConnectTo(worldIn, pos, EnumFacing.WEST, true))).func_177226_a((IProperty)EXTRACT_UP, (Comparable)Boolean.valueOf(extraction && this.canConnectTo(worldIn, pos, EnumFacing.UP, true))).func_177226_a((IProperty)EXTRACT_DOWN, (Comparable)Boolean.valueOf(extraction && this.canConnectTo(worldIn, pos, EnumFacing.DOWN, true)));
    }

    public ItemStack getItem(IBlockAccess world, BlockPos pos) {
        ItemStack itemStack = new ItemStack(Registry.PIPE_ITEM);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TilePipe) {
            itemStack.func_77982_d(new NBTTagCompound());
            itemStack.func_77978_p().func_74782_a("BaseBlock", (NBTBase)tileEntity.getTileData().func_74775_l("BaseBlock").func_74737_b());
        }
        return itemStack;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return this.getItem((IBlockAccess)worldIn, pos);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)this.getItem(world, pos));
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TilePipe && ((TilePipe)tileEntity).isExtractionEnabled()) {
            ItemStack extractUpgrade = BlockPipe.getExtractionUpgrade();
            drops.add((Object)extractUpgrade);
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.CENTER;
    }

    public static ItemStack getExtractionUpgrade() {
        block9: {
            if (extractionUpgrade == null) {
                try {
                    String upgrade = SWPConfig.pipeExtractionItem;
                    String[] data = upgrade.split(" ");
                    int meta = 0;
                    ResourceLocation resourcelocation = new ResourceLocation(data[0]);
                    Item item = (Item)Item.field_150901_e.func_82594_a((Object)resourcelocation);
                    if (item == null) {
                        throw new IllegalArgumentException("Invalid item name");
                    }
                    if (data.length > 1) {
                        try {
                            meta = Integer.parseInt(data[1]);
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Invalid item metadata: " + data[1]);
                        }
                    }
                    extractionUpgrade = new ItemStack(item, 1, meta);
                    if (data.length <= 2) break block9;
                    Object[] nbtTagStringArray = new String[data.length - 2];
                    System.arraycopy(data, 2, nbtTagStringArray, 0, nbtTagStringArray.length);
                    String nbtTagString = Joiner.on((char)' ').join(nbtTagStringArray);
                    try {
                        NBTTagCompound nbtTagCompound = JsonToNBT.func_180713_a((String)nbtTagString);
                        extractionUpgrade.func_77982_d(nbtTagCompound);
                    }
                    catch (NBTException e) {
                        throw new IllegalArgumentException("Invalid item nbt tag: " + nbtTagString);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to parse SWP pipe extraction upgrade item", e);
                }
            }
        }
        return extractionUpgrade.func_77946_l();
    }

    private static boolean areItemStacksEqual(ItemStack stackA, ItemStack stackB) {
        if (stackA.func_77973_b() != stackB.func_77973_b()) {
            return false;
        }
        if (stackA.func_77952_i() != stackB.func_77952_i()) {
            return false;
        }
        if (stackA.func_77978_p() == null && stackB.func_77978_p() != null) {
            return false;
        }
        return (stackA.func_77978_p() == null || stackA.func_77978_p().equals((Object)stackB.func_77978_p())) && stackA.areCapsCompatible(stackB);
    }

    static {
        NORTH = PropertyBool.func_177716_a((String)"north");
        EAST = PropertyBool.func_177716_a((String)"east");
        SOUTH = PropertyBool.func_177716_a((String)"south");
        WEST = PropertyBool.func_177716_a((String)"west");
        UP = PropertyBool.func_177716_a((String)"up");
        DOWN = PropertyBool.func_177716_a((String)"down");
        EXTRACTION = PropertyBool.func_177716_a((String)"extraction");
        EXTRACT_NORTH = PropertyBool.func_177716_a((String)"extract_north");
        EXTRACT_EAST = PropertyBool.func_177716_a((String)"extract_east");
        EXTRACT_SOUTH = PropertyBool.func_177716_a((String)"extract_south");
        EXTRACT_WEST = PropertyBool.func_177716_a((String)"extract_west");
        EXTRACT_UP = PropertyBool.func_177716_a((String)"extract_up");
        EXTRACT_DOWN = PropertyBool.func_177716_a((String)"extract_down");
        MIDDLE_BB = new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);
        NORTH_BB = new AxisAlignedBB(0.3125, 0.3125, 0.0, 0.6875, 0.6875, 0.25);
        EAST_BB = new AxisAlignedBB(1.0, 0.3125, 0.3125, 0.75, 0.6875, 0.6875);
        SOUTH_BB = new AxisAlignedBB(0.3125, 0.3125, 1.0, 0.6875, 0.6875, 0.75);
        WEST_BB = new AxisAlignedBB(0.0, 0.3125, 0.3125, 0.25, 0.6875, 0.6875);
        UP_BB = new AxisAlignedBB(0.3125, 1.0, 0.3125, 0.6875, 0.75, 0.6875);
        DOWN_BB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.25, 0.6875);
        stoneVariants = Collections.unmodifiableList(Arrays.asList(new ItemStack(Blocks.field_150348_b), new ItemStack(Blocks.field_150348_b, 1, 1), new ItemStack(Blocks.field_150348_b, 1, 2), new ItemStack(Blocks.field_150348_b, 1, 3), new ItemStack(Blocks.field_150348_b, 1, 4), new ItemStack(Blocks.field_150348_b, 1, 5), new ItemStack(Blocks.field_150348_b, 1, 6)));
    }
}

