/*
 * Decompiled with CFR 0.152.
 */
package xyz.dogboy.swp.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import xyz.dogboy.swp.blocks.BlockWoodenVariation;
import xyz.dogboy.swp.tiles.TilePump;

public class BlockPump
extends BlockWoodenVariation {
    public static final PropertyBool CONNECTED = PropertyBool.func_177716_a((String)"connected");
    public static final AxisAlignedBB BB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.3125, 0.9375);
    public static final AxisAlignedBB PIPE_BB = new AxisAlignedBB(0.3125, 0.3125, 0.3125, 0.6875, 1.0, 0.6875);

    public BlockPump() {
        super("pump", Material.field_151573_f, MapColor.field_151668_h);
        this.func_149711_c(4.0f);
        this.func_149752_b(6.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)CONNECTED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TilePump();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (!isActualState) {
            state = state.func_185899_b((IBlockAccess)worldIn, pos);
        }
        Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BB);
        if (((Boolean)state.func_177229_b((IProperty)CONNECTED)).booleanValue()) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)PIPE_BB);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = this.func_176221_a(state, source, pos);
        AxisAlignedBB boundingBox = BB;
        if (((Boolean)state.func_177229_b((IProperty)CONNECTED)).booleanValue()) {
            boundingBox = boundingBox.func_111270_a(PIPE_BB);
        }
        return boundingBox;
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{CONNECTED}, new IUnlistedProperty[]{BlockWoodenVariation.TEXTURE});
    }

    public boolean canConnectTo(IBlockAccess world, BlockPos pipePos, EnumFacing direction) {
        TileEntity tileEntity = world.func_175625_s(pipePos.func_177972_a(direction));
        return tileEntity != null && tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.func_176734_d());
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)CONNECTED, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos, EnumFacing.UP)));
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return super.getExtendedState(state, world, pos).func_177226_a((IProperty)CONNECTED, (Comparable)Boolean.valueOf(this.canConnectTo(world, pos, EnumFacing.UP)));
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.UP) {
            return BlockFaceShape.CENTER;
        }
        return BlockFaceShape.UNDEFINED;
    }
}

