/*
 * Decompiled with CFR 0.152.
 */
package xyz.dogboy.swp.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xyz.dogboy.swp.blocks.BlockPipe;
import xyz.dogboy.swp.client.ClientProxy;

@SideOnly(value=Side.CLIENT)
public class BakedWoodenVariationModel
extends BakedModelWrapper<IBakedModel> {
    private final Map<String, IBakedModel> cache = Maps.newHashMap();
    private final List<String> replacedTextures;
    private final IModel model;

    public BakedWoodenVariationModel(IBakedModel originalModel, IModel model, List<String> replacedTextures) {
        super(originalModel);
        this.model = model;
        this.replacedTextures = replacedTextures;
    }

    private TextureAtlasSprite getTexture(ResourceLocation resourceLocation) {
        return Minecraft.func_71410_x().func_147117_R().func_110572_b(resourceLocation.toString());
    }

    protected IBakedModel getActualModel(String texture) {
        IBakedModel bakedModel = this.originalModel;
        if (texture != null) {
            if (this.cache.containsKey(texture)) {
                bakedModel = this.cache.get(texture);
            } else if (this.model != null) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (String key : this.replacedTextures) {
                    builder.put((Object)key, (Object)texture);
                }
                IModel retextured = this.model.retexture(builder.build());
                IModelState modelState = retextured.getDefaultState();
                bakedModel = retextured.bake(modelState, DefaultVertexFormats.field_176600_a, this::getTexture);
                this.cache.put(texture, bakedModel);
            }
        }
        return bakedModel;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (state instanceof IExtendedBlockState) {
            String texture = (String)((IExtendedBlockState)state).getValue((IUnlistedProperty)BlockPipe.TEXTURE);
            return this.getActualModel(texture).func_188616_a(state, side, rand);
        }
        return this.originalModel.func_188616_a(state, side, rand);
    }

    public ItemOverrideList func_188617_f() {
        return WoodenVariationItemOverrideList.instance;
    }

    private static class WoodenVariationItemOverrideList
    extends ItemOverrideList {
        private static final WoodenVariationItemOverrideList instance = new WoodenVariationItemOverrideList();

        public WoodenVariationItemOverrideList() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            Block block;
            ItemStack baseBlock;
            if (stack.func_77942_o() && !(baseBlock = new ItemStack(stack.func_77978_p().func_74775_l("BaseBlock"))).func_190926_b() && (block = Block.func_149634_a((Item)baseBlock.func_77973_b())) != Blocks.field_150350_a) {
                String texture = ClientProxy.getTextureFromBlock(block, baseBlock.func_77952_i());
                return ((BakedWoodenVariationModel)originalModel).getActualModel(texture);
            }
            return originalModel;
        }
    }
}

