/*
 * Decompiled with CFR 0.152.
 */
package xyz.dogboy.swp.blocks;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import xyz.dogboy.swp.blocks.DynamicShapeBlock;
import xyz.dogboy.swp.tiles.PipeTileEntity;
import xyz.dogboy.swp.utils.PipeNetworkHelper;
import xyz.dogboy.swp.utils.SupportedWoodType;

public class PipeBlock
extends DynamicShapeBlock {
    public static final Map<Direction, BooleanProperty> DIRECTION_PROPERTY_MAP = new EnumMap<Direction, BooleanProperty>(Direction.class);
    public static final Map<Direction, BooleanProperty> DIRECTION_EXTRACTION_PROPERTY_MAP = new EnumMap<Direction, BooleanProperty>(Direction.class);
    private SupportedWoodType woodType;
    private static final VoxelShape MIDDLE_SHAPE;
    private static final Map<Direction, VoxelShape> PIPE_EXTENSION_SHAPE_MAP;
    private static final Map<BlockState, VoxelShape> SHAPE_CACHE;

    public PipeBlock(AbstractBlock.Properties properties, SupportedWoodType woodType) {
        super(properties);
        this.woodType = woodType;
        BlockState defaultState = (BlockState)this.func_176194_O().func_177621_b();
        for (Direction direction : Direction.values()) {
            defaultState = (BlockState)defaultState.func_206870_a((Property)DIRECTION_PROPERTY_MAP.get(direction), (Comparable)Boolean.valueOf(false));
            defaultState = (BlockState)defaultState.func_206870_a((Property)DIRECTION_EXTRACTION_PROPERTY_MAP.get(direction), (Comparable)Boolean.valueOf(false));
        }
        this.func_180632_j(defaultState);
    }

    @Override
    protected VoxelShape getVoxelShape(BlockState state) {
        if (SHAPE_CACHE.containsKey(state)) {
            return SHAPE_CACHE.get(state);
        }
        VoxelShape shape = MIDDLE_SHAPE;
        for (Direction direction : Direction.values()) {
            if (!((Boolean)state.func_177229_b((Property)DIRECTION_PROPERTY_MAP.get(direction))).booleanValue()) continue;
            shape = PipeBlock.mergeVoxelShapes(shape, PIPE_EXTENSION_SHAPE_MAP.get(direction));
        }
        SHAPE_CACHE.put(state, shape);
        return shape;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof PipeTileEntity)) {
            return ActionResultType.PASS;
        }
        Direction direction = PipeBlock.getDirectionOfClick(pos, rayTraceResult);
        if (direction != null) {
            if (player.func_213453_ef()) {
                return this.shiftRightClick(state, world, pos, player, direction);
            }
            if (player.func_184586_b(hand).func_77973_b() == Blocks.field_150331_J.func_199767_j()) {
                return this.rightClickPiston(state, world, pos, player, hand, direction);
            }
        }
        return super.func_225533_a_(state, world, pos, player, hand, rayTraceResult);
    }

    private static Direction getDirectionOfClick(BlockPos pos, BlockRayTraceResult ray) {
        Vector3d halfBlock = new Vector3d(0.5, 0.5, 0.5);
        Vector3d smallerPosition = ray.func_216347_e().func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()).func_186678_a(0.99).func_178787_e(halfBlock.func_186678_a(0.01));
        for (Direction direction : Direction.values()) {
            VoxelShape shape = PIPE_EXTENSION_SHAPE_MAP.get(direction);
            if (!shape.func_197752_a().func_72318_a(smallerPosition)) continue;
            return direction;
        }
        return null;
    }

    private ActionResultType shiftRightClick(BlockState state, World world, BlockPos pos, PlayerEntity player, Direction direction) {
        if (!((Boolean)state.func_177229_b((Property)DIRECTION_EXTRACTION_PROPERTY_MAP.get(direction))).booleanValue()) {
            return ActionResultType.PASS;
        }
        world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)DIRECTION_EXTRACTION_PROPERTY_MAP.get(direction), (Comparable)Boolean.valueOf(false)), 19);
        if (!player.func_184812_l_() && !player.func_191521_c(new ItemStack((IItemProvider)Blocks.field_150331_J))) {
            player.func_71019_a(new ItemStack((IItemProvider)Blocks.field_150331_J), false);
        }
        player.func_184185_a(SoundEvents.field_187692_g, 1.0f, 1.0f);
        return ActionResultType.SUCCESS;
    }

    private ActionResultType rightClickPiston(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, Direction direction) {
        if (((Boolean)state.func_177229_b((Property)DIRECTION_EXTRACTION_PROPERTY_MAP.get(direction))).booleanValue()) {
            return ActionResultType.PASS;
        }
        if (!PipeNetworkHelper.canConnectTo(state, (IBlockReader)world, pos, direction, true)) {
            return ActionResultType.PASS;
        }
        world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)DIRECTION_EXTRACTION_PROPERTY_MAP.get(direction), (Comparable)Boolean.valueOf(true)), 19);
        if (!player.func_184812_l_()) {
            player.func_184586_b(hand).func_190918_g(1);
        }
        player.func_184185_a(SoundEvents.field_187604_bf, 1.0f, 1.0f);
        return ActionResultType.SUCCESS;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos pos2, boolean flag) {
        if (!world.func_201670_d()) {
            BlockState newState;
            BlockState oldState = world.func_180495_p(pos);
            if (!this.areStatesEqual(oldState, newState = this.updateState(world.func_180495_p(pos), world, pos))) {
                world.func_180501_a(pos, this.updateState(world.func_180495_p(pos), world, pos), 19);
            }
            PipeNetworkHelper.generateNetwork((IWorldReader)world, pos);
        }
        super.func_220069_a(state, world, pos, block, pos2, flag);
    }

    private boolean areStatesEqual(BlockState state1, BlockState state2) {
        AtomicBoolean wrong = new AtomicBoolean(false);
        DIRECTION_PROPERTY_MAP.values().forEach(property -> {
            if (!((Boolean)state1.func_177229_b((Property)property)).equals(state2.func_177229_b((Property)property))) {
                wrong.set(true);
            }
        });
        if (wrong.get()) {
            return false;
        }
        DIRECTION_EXTRACTION_PROPERTY_MAP.values().forEach(property -> {
            if (!((Boolean)state1.func_177229_b((Property)property)).equals(state2.func_177229_b((Property)property))) {
                wrong.set(true);
            }
        });
        return !wrong.get();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PipeTileEntity();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = this.func_176223_P();
        return this.updateState(state, context.func_195991_k(), context.func_195995_a());
    }

    public BlockState updateState(BlockState state, World worldIn, BlockPos pos) {
        EnumMap<Direction, Comparable> map = new EnumMap<Direction, Comparable>(Direction.class);
        for (Direction direction : Direction.values()) {
            map.put(direction, state.func_177229_b((Property)DIRECTION_EXTRACTION_PROPERTY_MAP.get(direction)));
        }
        for (Direction direction : Direction.values()) {
            state = (BlockState)state.func_206870_a((Property)DIRECTION_PROPERTY_MAP.get(direction), (Comparable)Boolean.valueOf(PipeNetworkHelper.canConnectTo(state, (IBlockReader)worldIn, pos, direction, false)));
            state = (BlockState)state.func_206870_a((Property)DIRECTION_EXTRACTION_PROPERTY_MAP.get(direction), (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((Property)DIRECTION_EXTRACTION_PROPERTY_MAP.get(direction)) != false && PipeNetworkHelper.canConnectTo(state, (IBlockReader)worldIn, pos, direction, true)));
        }
        if (worldIn.func_201670_d()) {
            return state;
        }
        for (Direction direction : Direction.values()) {
            if (!((Boolean)map.get(direction)).booleanValue() || ((Boolean)state.func_177229_b((Property)DIRECTION_EXTRACTION_PROPERTY_MAP.get(direction))).booleanValue()) continue;
            worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack((IItemProvider)Blocks.field_150331_J)));
        }
        return state;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder lootContextBuilder) {
        List drops = super.func_220076_a(state, lootContextBuilder);
        for (Direction direction : Direction.values()) {
            if (!((Boolean)state.func_177229_b((Property)DIRECTION_EXTRACTION_PROPERTY_MAP.get(direction))).booleanValue()) continue;
            drops.add(new ItemStack((IItemProvider)Blocks.field_150331_J));
        }
        return drops;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        DIRECTION_PROPERTY_MAP.values().forEach(xva$0 -> builder.func_206894_a(new Property[]{xva$0}));
        DIRECTION_EXTRACTION_PROPERTY_MAP.values().forEach(xva$0 -> builder.func_206894_a(new Property[]{xva$0}));
    }

    public SupportedWoodType getWoodType() {
        return this.woodType;
    }

    static {
        for (Direction direction : Direction.values()) {
            DIRECTION_PROPERTY_MAP.put(direction, BooleanProperty.func_177716_a((String)direction.func_176742_j().toLowerCase()));
            DIRECTION_EXTRACTION_PROPERTY_MAP.put(direction, BooleanProperty.func_177716_a((String)("extract_" + direction.func_176742_j().toLowerCase())));
        }
        MIDDLE_SHAPE = Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
        PIPE_EXTENSION_SHAPE_MAP = new EnumMap<Direction, VoxelShape>(Direction.class);
        SHAPE_CACHE = new HashMap<BlockState, VoxelShape>();
        PIPE_EXTENSION_SHAPE_MAP.put(Direction.NORTH, Block.func_208617_a((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)4.0));
        PIPE_EXTENSION_SHAPE_MAP.put(Direction.EAST, Block.func_208617_a((double)12.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0));
        PIPE_EXTENSION_SHAPE_MAP.put(Direction.SOUTH, Block.func_208617_a((double)5.0, (double)5.0, (double)12.0, (double)11.0, (double)11.0, (double)16.0));
        PIPE_EXTENSION_SHAPE_MAP.put(Direction.WEST, Block.func_208617_a((double)0.0, (double)5.0, (double)5.0, (double)4.0, (double)11.0, (double)11.0));
        PIPE_EXTENSION_SHAPE_MAP.put(Direction.UP, Block.func_208617_a((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0));
        PIPE_EXTENSION_SHAPE_MAP.put(Direction.DOWN, Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0));
    }
}

