/*
 * Decompiled with CFR 0.152.
 */
package xyz.dogboy.swp.blocks;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import xyz.dogboy.swp.blocks.DynamicShapeBlock;
import xyz.dogboy.swp.blocks.PipeBlock;
import xyz.dogboy.swp.registry.BlockRegistry;
import xyz.dogboy.swp.tiles.PumpTileEntity;
import xyz.dogboy.swp.utils.SupportedWoodType;

public class PumpBlock
extends DynamicShapeBlock {
    public static final BooleanProperty CONNECTED = BooleanProperty.func_177716_a((String)"connected");
    public static final VoxelShape PUMP_SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)5.0, (double)15.0);
    public static final VoxelShape PIPE_SHAPE = Block.func_208617_a((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);

    public PumpBlock(AbstractBlock.Properties properties) {
        super(properties);
        BlockState defaultState = (BlockState)this.func_176194_O().func_177621_b();
        defaultState = (BlockState)defaultState.func_206870_a((Property)CONNECTED, (Comparable)Boolean.valueOf(false));
        this.func_180632_j(defaultState);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block p_220069_4_, BlockPos p_220069_5_, boolean p_220069_6_) {
        BlockState newState;
        BlockState oldState;
        if (!world.func_201670_d() && !PumpBlock.areStatesEqual(oldState = world.func_180495_p(pos), newState = this.updateState(world.func_180495_p(pos), (IBlockReader)world, pos))) {
            world.func_180501_a(pos, this.updateState(world.func_180495_p(pos), (IBlockReader)world, pos), 19);
        }
        super.func_220069_a(state, world, pos, p_220069_4_, p_220069_5_, p_220069_6_);
    }

    private static boolean areStatesEqual(BlockState state1, BlockState state2) {
        return state1.func_177230_c() == state2.func_177230_c();
    }

    @Override
    protected VoxelShape getVoxelShape(BlockState state) {
        VoxelShape shape = PUMP_SHAPE;
        if (((Boolean)state.func_177229_b((Property)CONNECTED)).booleanValue()) {
            shape = PumpBlock.mergeVoxelShapes(shape, PIPE_SHAPE);
        }
        return shape;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PumpTileEntity();
    }

    public boolean canConnectTo(IBlockReader world, BlockPos pipePos, Direction direction, boolean excludePipe) {
        TileEntity tileEntity;
        BlockState state = world.func_180495_p(pipePos.func_177972_a(direction));
        if (excludePipe) {
            if (state.func_177230_c() instanceof PipeBlock || state.func_177230_c() instanceof PumpBlock) {
                return false;
            }
        } else if (state.func_177230_c() instanceof PipeBlock || state.func_177230_c() instanceof PumpBlock && direction == Direction.DOWN) {
            return true;
        }
        return (tileEntity = world.func_175625_s(pipePos.func_177972_a(direction))) != null && tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.func_176734_d()).isPresent();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = this.func_176223_P();
        return this.updateState(state, (IBlockReader)context.func_195991_k(), context.func_195995_a());
    }

    public BlockState updateState(BlockState state, IBlockReader world, BlockPos pos) {
        Block block = world.func_180495_p(pos.func_177972_a(Direction.UP)).func_177230_c();
        if (block instanceof PipeBlock) {
            PumpBlock pump = BlockRegistry.getPumpByWoodType(BlockRegistry.getTypeByPipe((PipeBlock)block)).get();
            return (BlockState)pump.func_176223_P().func_206870_a((Property)CONNECTED, (Comparable)Boolean.valueOf(true));
        }
        if (this.canConnectTo(world, pos, Direction.UP, true)) {
            Block pump = (Block)((Supplier)BlockRegistry.WOOD_TYPE_PUMPS.get((Object)SupportedWoodType.OAK)).get();
            return (BlockState)pump.func_176223_P().func_206870_a((Property)CONNECTED, (Comparable)Boolean.valueOf(true));
        }
        return ((Block)BlockRegistry.PUMP.get()).func_176223_P();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{CONNECTED});
    }
}

