/*
 * Decompiled with CFR 0.152.
 */
package xyz.dogboy.swp.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.LogMarkers;
import org.apache.commons.lang3.tuple.Pair;
import xyz.dogboy.swp.SimpleWoodenPipes;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SWPConfig {
    public static final ForgeConfigSpec spec;
    public static final General GENERAL;

    private SWPConfig() {
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        SimpleWoodenPipes.LOGGER.debug(LogMarkers.FORGEMOD, "Loaded SimpleWoodenPipes config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading configEvent) {
        SimpleWoodenPipes.LOGGER.debug(LogMarkers.CORE, "SimpleWoodenPipes config just got changed on the file system!");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(x$0 -> new General((ForgeConfigSpec.Builder)x$0));
        spec = (ForgeConfigSpec)specPair.getRight();
        GENERAL = (General)specPair.getLeft();
    }

    public static class General {
        public final ForgeConfigSpec.ConfigValue<Integer> transferRate;
        public final ForgeConfigSpec.ConfigValue<Integer> pumpRate;
        public final ForgeConfigSpec.ConfigValue<Integer> internalVolume;

        private General(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            this.transferRate = builder.comment("The transfer rate of pipes").translation("simplewoodenpipes.config.transferRate").defineInRange("transferRate", 50, 1, Integer.MAX_VALUE);
            this.pumpRate = builder.comment("The pump rate of pumps").translation("simplewoodenpipes.config.pumpRate").defineInRange("pumpRate", 25, 1, Integer.MAX_VALUE);
            this.internalVolume = builder.comment("The internal volume of pipes").translation("simplewoodenpipes.config.internalVolume").defineInRange("internalVolume", 1000, 1, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

