/*
 * Decompiled with CFR 0.152.
 */
package xyz.dogboy.swp.datagen;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import xyz.dogboy.swp.blocks.PipeBlock;
import xyz.dogboy.swp.registry.BlockRegistry;
import xyz.dogboy.swp.utils.SupportedWoodType;

public class BlockStateGenerator
extends BlockStateProvider {
    ExistingFileHelper helper;

    public BlockStateGenerator(DataGenerator p_i232520_1_, ExistingFileHelper fileHelper) {
        super(p_i232520_1_, "simplewoodenpipes", fileHelper);
        this.helper = fileHelper;
    }

    protected void registerStatesAndModels() {
        this.registerPipeMultiparts();
        this.registerPumpMultiparts();
    }

    private void registerPipeMultiparts() {
        BlockModelBuilder[][] pipeParts = this.createPipeParts();
        for (SupportedWoodType type : SupportedWoodType.values()) {
            this.registerPipeMultipart(type, pipeParts[0][type.ordinal()], pipeParts[1][type.ordinal()], pipeParts[2][0]);
        }
    }

    private void registerPipeMultipart(SupportedWoodType type, BlockModelBuilder centerPart, BlockModelBuilder side, BlockModelBuilder extraction) {
        Block pipeBlock = (Block)((Supplier)BlockRegistry.WOOD_TYPE_PIPES.get((Object)type)).get();
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(pipeBlock);
        builder.part().modelFile((ModelFile)centerPart).uvLock(false).addModel();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).uvLock(false).addModel()).condition((Property)PipeBlock.DIRECTION_PROPERTY_MAP.get(Direction.NORTH), (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)extraction).uvLock(false).addModel()).condition((Property)PipeBlock.DIRECTION_EXTRACTION_PROPERTY_MAP.get(Direction.NORTH), (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).uvLock(false).rotationY(90).addModel()).condition((Property)PipeBlock.DIRECTION_PROPERTY_MAP.get(Direction.EAST), (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)extraction).uvLock(false).rotationY(90).addModel()).condition((Property)PipeBlock.DIRECTION_EXTRACTION_PROPERTY_MAP.get(Direction.EAST), (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).uvLock(false).rotationY(180).addModel()).condition((Property)PipeBlock.DIRECTION_PROPERTY_MAP.get(Direction.SOUTH), (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)extraction).uvLock(false).rotationY(180).addModel()).condition((Property)PipeBlock.DIRECTION_EXTRACTION_PROPERTY_MAP.get(Direction.SOUTH), (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).uvLock(false).rotationY(270).addModel()).condition((Property)PipeBlock.DIRECTION_PROPERTY_MAP.get(Direction.WEST), (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)extraction).uvLock(false).rotationY(270).addModel()).condition((Property)PipeBlock.DIRECTION_EXTRACTION_PROPERTY_MAP.get(Direction.WEST), (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).uvLock(false).rotationX(-90).addModel()).condition((Property)PipeBlock.DIRECTION_PROPERTY_MAP.get(Direction.UP), (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)extraction).uvLock(false).rotationX(-90).addModel()).condition((Property)PipeBlock.DIRECTION_EXTRACTION_PROPERTY_MAP.get(Direction.UP), (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).uvLock(false).rotationX(90).addModel()).condition((Property)PipeBlock.DIRECTION_PROPERTY_MAP.get(Direction.DOWN), (Comparable[])new Boolean[]{true});
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)extraction).uvLock(false).rotationX(90).addModel()).condition((Property)PipeBlock.DIRECTION_EXTRACTION_PROPERTY_MAP.get(Direction.DOWN), (Comparable[])new Boolean[]{true});
    }

    private BlockModelBuilder[][] createPipeParts() {
        BlockModelBuilder[] cores = new BlockModelBuilder[SupportedWoodType.values().length];
        for (SupportedWoodType type : SupportedWoodType.values()) {
            BlockModelProvider blockModelProvider = this.models();
            StringBuilder stringBuilder = new StringBuilder();
            this.models();
            BlockModelBuilder builder = (BlockModelBuilder)blockModelProvider.getBuilder(stringBuilder.append("block").append("/").append(type.prefix).append("_pipe_middle").toString());
            this.addCube(builder, 6, 6, 6, 10, 10, 10, "#wood");
            this.addCube(builder, 4, 10, 6, 6, 12, 10, "#wood");
            this.addCube(builder, 4, 4, 6, 6, 6, 10, "#wood");
            this.addCube(builder, 10, 4, 6, 12, 6, 10, "#wood");
            this.addCube(builder, 10, 10, 6, 12, 12, 10, "#wood");
            this.addCube(builder, 6, 10, 4, 10, 12, 6, "#wood");
            this.addCube(builder, 6, 4, 10, 10, 6, 12, "#wood");
            this.addCube(builder, 6, 10, 10, 10, 12, 12, "#wood");
            this.addCube(builder, 6, 4, 4, 10, 6, 6, "#wood");
            this.addCube(builder, 10, 4, 4, 12, 12, 6, "#wood");
            this.addCube(builder, 10, 4, 10, 12, 12, 12, "#wood");
            this.addCube(builder, 4, 4, 10, 6, 12, 12, "#wood");
            this.addCube(builder, 4, 4, 4, 6, 12, 6, "#wood");
            ((BlockModelBuilder)builder.texture("wood", type.texturePath)).texture("particle", type.texturePath);
            cores[type.ordinal()] = builder;
        }
        BlockModelBuilder[] sides = new BlockModelBuilder[SupportedWoodType.values().length];
        for (SupportedWoodType type : SupportedWoodType.values()) {
            BlockModelProvider blockModelProvider = this.models();
            StringBuilder stringBuilder = new StringBuilder();
            this.models();
            BlockModelBuilder builder = (BlockModelBuilder)blockModelProvider.getBuilder(stringBuilder.append("block").append("/").append(type.prefix).append("_pipe_side").toString());
            this.addCube(builder, 5, 5, 0, 11, 6, 4, "#wood");
            this.addCube(builder, 5, 10, 0, 11, 11, 4, "#wood");
            this.addCube(builder, 10, 6, 0, 11, 10, 4, "#wood");
            this.addCube(builder, 5, 6, 0, 6, 10, 4, "#wood");
            ((BlockModelBuilder)builder.texture("wood", type.texturePath)).texture("particle", type.texturePath);
            sides[type.ordinal()] = builder;
        }
        BlockModelBuilder[] extraction = new BlockModelBuilder[1];
        BlockModelProvider blockModelProvider = this.models();
        StringBuilder stringBuilder = new StringBuilder();
        this.models();
        BlockModelBuilder builder = (BlockModelBuilder)blockModelProvider.getBuilder(stringBuilder.append("block").append("/pipe_extraction").toString());
        this.addCube(builder, 4, 4, 0, 12, 5, 2, "#iron");
        this.addCube(builder, 4, 11, 0, 12, 12, 2, "#iron");
        this.addCube(builder, 4, 5, 0, 5, 11, 2, "#iron");
        this.addCube(builder, 11, 5, 0, 12, 11, 2, "#iron");
        builder.texture("iron", new ResourceLocation("minecraft", "block/iron_block"));
        extraction[0] = builder;
        return new BlockModelBuilder[][]{cores, sides, extraction};
    }

    private void registerPumpMultiparts() {
        ModelFile.ExistingModelFile pump = new ModelFile.ExistingModelFile(new ResourceLocation("simplewoodenpipes", "block/pump_unconnected"), this.helper);
        ModelFile[] pipes = this.createPipesForPump();
        for (SupportedWoodType type : SupportedWoodType.values()) {
            this.registerPumpMultipart(type, (ModelFile)pump, pipes[type.ordinal()]);
        }
    }

    private ModelFile[] createPipesForPump() {
        ModelFile[] pipes = new ModelFile[SupportedWoodType.values().length];
        for (SupportedWoodType type : SupportedWoodType.values()) {
            BlockModelProvider blockModelProvider = this.models();
            StringBuilder stringBuilder = new StringBuilder();
            this.models();
            BlockModelBuilder builder = (BlockModelBuilder)blockModelProvider.getBuilder(stringBuilder.append("block").append("/").append(type.prefix).append("_pump").toString());
            this.addCube(builder, 10, 5, 5, 11, 16, 11, "#wood");
            this.addCube(builder, 5, 5, 5, 6, 16, 11, "#wood");
            this.addCube(builder, 6, 5, 5, 10, 16, 6, "#wood");
            this.addCube(builder, 6, 5, 10, 10, 16, 11, "#wood");
            ((BlockModelBuilder)builder.texture("wood", type.texturePath)).texture("particle", type.texturePath);
            pipes[type.ordinal()] = builder;
        }
        return pipes;
    }

    private void registerPumpMultipart(SupportedWoodType type, ModelFile pump, ModelFile pipe) {
        Block pumpBlock = (Block)((Supplier)BlockRegistry.WOOD_TYPE_PUMPS.get((Object)type)).get();
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(pumpBlock);
        builder.part().modelFile(pump).addModel();
        builder.part().modelFile(pipe).addModel();
    }

    private BlockModelBuilder addCube(BlockModelBuilder builder, int fromX, int fromY, int fromZ, int toX, int toY, int toZ, String texture) {
        AtomicInteger integer = new AtomicInteger();
        return (BlockModelBuilder)builder.element().from((float)fromX, (float)fromY, (float)fromZ).to((float)toX, (float)toY, (float)toZ).allFaces((direction, faceBuilder) -> {
            faceBuilder.texture(texture);
            switch (integer.getAndIncrement()) {
                case 2: 
                case 3: {
                    faceBuilder.uvs((float)fromX, (float)fromY, (float)toX, (float)toY);
                    break;
                }
                case 4: 
                case 5: {
                    faceBuilder.uvs((float)fromZ, (float)fromY, (float)toZ, (float)toY);
                    break;
                }
                case 0: 
                case 1: {
                    faceBuilder.uvs((float)fromX, (float)fromZ, (float)toX, (float)toZ);
                }
            }
        }).end();
    }
}

