/*
 * Decompiled with CFR 0.152.
 */
package xyz.dogboy.swp.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import xyz.dogboy.swp.blocks.PipeBlock;
import xyz.dogboy.swp.blocks.PumpBlock;
import xyz.dogboy.swp.utils.SupportedWoodType;

@Mod.EventBusSubscriber(modid="simplewoodenpipes")
public class BlockRegistry {
    public static final String PIPE_POSTFIX = "_pipe";
    public static final String PUMP_POSTFIX = "_pump";
    public static final Item.Properties DEFAULT_ITEM_PROPERTIES = new Item.Properties().func_200916_a(ItemGroup.field_78028_d);
    public static final AbstractBlock.Properties DEFAULT_BLOCK_PROPERTIES = AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(2.5f);
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"simplewoodenpipes");
    public static final DeferredRegister<Item> BLOCK_ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"simplewoodenpipes");
    public static final RegistryObject<Block> PUMP = BlockRegistry.registerBlockWithItem("pump", () -> new PumpBlock(DEFAULT_BLOCK_PROPERTIES));
    public static final RegistryObject<Block> TANK = null;
    public static final BiMap<SupportedWoodType, Supplier<PipeBlock>> WOOD_TYPE_PIPES = HashBiMap.create();
    public static final BiMap<SupportedWoodType, Supplier<PumpBlock>> WOOD_TYPE_PUMPS = HashBiMap.create();

    private BlockRegistry() {
    }

    public static void registerAll(IEventBus bus) {
        BlockRegistry.registerBlocks();
        BLOCKS.register(bus);
        BLOCK_ITEMS.register(bus);
    }

    private static void registerBlocks() {
        BlockRegistry.registerPipes();
        BlockRegistry.registerPumps();
    }

    private static void registerPipes() {
        for (SupportedWoodType supportedWoodType : SupportedWoodType.values()) {
            String registryName = supportedWoodType.prefix + PIPE_POSTFIX;
            RegistryObject<PipeBlock> pipeBlock = BlockRegistry.registerBlockWithPipeItem(registryName, () -> new PipeBlock(DEFAULT_BLOCK_PROPERTIES, supportedWoodType));
            WOOD_TYPE_PIPES.put((Object)supportedWoodType, pipeBlock);
        }
    }

    private static void registerPumps() {
        for (SupportedWoodType supportedWoodType : SupportedWoodType.values()) {
            String registryName = supportedWoodType.prefix + PUMP_POSTFIX;
            RegistryObject<PumpBlock> pumpBlock = BlockRegistry.registerBlock(registryName, () -> new PumpBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)PUMP.get())).func_222379_b((Block)PUMP.get())));
            WOOD_TYPE_PUMPS.put((Object)supportedWoodType, pumpBlock);
        }
    }

    private static <T extends Block> RegistryObject<T> registerBlockWithItem(String registryName, Supplier<T> blockSupplier) {
        RegistryObject registryObject = BLOCKS.register(registryName, blockSupplier);
        BLOCK_ITEMS.register(registryName, () -> new BlockItem((Block)registryObject.get(), DEFAULT_ITEM_PROPERTIES));
        return registryObject;
    }

    private static <T extends Block> RegistryObject<T> registerBlockWithPipeItem(String registryName, Supplier<T> blockSupplier) {
        RegistryObject registryObject = BLOCKS.register(registryName, blockSupplier);
        BLOCK_ITEMS.register(registryName, () -> new PipeItem((Block)registryObject.get(), DEFAULT_ITEM_PROPERTIES));
        return registryObject;
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String registryName, Supplier<T> blockSupplier) {
        return BLOCKS.register(registryName, blockSupplier);
    }

    public static Supplier<PumpBlock> getPumpByWoodType(SupportedWoodType type) {
        return BlockRegistry.getByWoodType(type, WOOD_TYPE_PUMPS);
    }

    private static <T extends Block> Supplier<T> getByWoodType(SupportedWoodType type, BiMap<SupportedWoodType, Supplier<T>> map) {
        ValueHolder valueHolder = new ValueHolder();
        map.forEach((supportedWoodType, blockSupplier) -> {
            if (supportedWoodType == type) {
                valueHolder.setValue(blockSupplier);
            }
        });
        return (Supplier)valueHolder.getValue();
    }

    public static SupportedWoodType getTypeByPipe(PipeBlock pipe) {
        return BlockRegistry.getTypeByBlock(pipe, WOOD_TYPE_PIPES);
    }

    private static <T extends Block> SupportedWoodType getTypeByBlock(T block, BiMap<SupportedWoodType, Supplier<T>> map) {
        ValueHolder valueHolder = new ValueHolder();
        map.forEach((supportedWoodType, blockSupplier) -> {
            if (blockSupplier.get() == block) {
                valueHolder.setValue(supportedWoodType);
            }
        });
        return (SupportedWoodType)((Object)valueHolder.getValue());
    }

    private static class ValueHolder<Type> {
        private Type value;

        private ValueHolder() {
        }

        public void setValue(Type value) {
            this.value = value;
        }

        public Type getValue() {
            return this.value;
        }
    }

    private static class PipeItem
    extends BlockItem {
        public PipeItem(Block p_i48527_1_, Item.Properties p_i48527_2_) {
            super(p_i48527_1_, p_i48527_2_);
        }

        protected boolean func_194125_a(ItemGroup p_194125_1_) {
            boolean isAllowed = super.func_194125_a(p_194125_1_);
            String modId = BlockRegistry.getTypeByPipe((PipeBlock)((PipeBlock)this.func_179223_d())).requiresModId;
            if (modId.isEmpty()) {
                return isAllowed;
            }
            return ModList.get().isLoaded(modId) && isAllowed;
        }

        public void func_77624_a(ItemStack itemStack, @Nullable World World2, List<ITextComponent> lines, ITooltipFlag flag) {
            super.func_77624_a(itemStack, World2, lines, flag);
            SupportedWoodType type = BlockRegistry.getTypeByPipe((PipeBlock)this.func_179223_d());
            if (!type.fireSafe) {
                lines.add((ITextComponent)new TranslationTextComponent("simplewoodenpipes.tooltip.pipe.low_temp_only"));
            } else {
                lines.add((ITextComponent)new TranslationTextComponent("simplewoodenpipes.tooltip.pipe.also_high_temp"));
            }
            lines.add((ITextComponent)new TranslationTextComponent("simplewoodenpipes.tooltip.pipe.add_piston"));
        }
    }
}

