/*
 * Decompiled with CFR 0.152.
 */
package xyz.dogboy.swp.registry;

import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import xyz.dogboy.swp.registry.BlockRegistry;
import xyz.dogboy.swp.tiles.PipeTileEntity;
import xyz.dogboy.swp.tiles.PumpTileEntity;
import xyz.dogboy.swp.tiles.TankTileEntity;

public class TileRegistry {
    public static final DeferredRegister<TileEntityType<?>> TILE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"simplewoodenpipes");
    public static final RegistryObject<TileEntityType<PipeTileEntity>> PIPE = TILE_TYPES.register("pipe", () -> TileEntityType.Builder.func_223042_a(PipeTileEntity::new, (Block[])TileRegistry.getPipeBlocks()).func_206865_a(null));
    public static final RegistryObject<TileEntityType<PumpTileEntity>> PUMP = TILE_TYPES.register("pump", () -> TileEntityType.Builder.func_223042_a(PumpTileEntity::new, (Block[])TileRegistry.getPumpBlocks()).func_206865_a(null));
    public static final RegistryObject<TileEntityType<TankTileEntity>> TANK = null;

    private TileRegistry() {
    }

    private static Block[] getPumpBlocks() {
        Block[] pumpBlocks = new Block[BlockRegistry.WOOD_TYPE_PUMPS.size() + 1];
        BlockRegistry.WOOD_TYPE_PUMPS.forEach((supportedWoodType, blockSupplier) -> {
            pumpBlocks[supportedWoodType.ordinal()] = (Block)blockSupplier.get();
        });
        pumpBlocks[pumpBlocks.length - 1] = (Block)BlockRegistry.PUMP.get();
        return pumpBlocks;
    }

    private static Block[] getPipeBlocks() {
        Block[] pipeBlocks = new Block[BlockRegistry.WOOD_TYPE_PIPES.size()];
        BlockRegistry.WOOD_TYPE_PIPES.forEach((supportedWoodType, blockSupplier) -> {
            pipeBlocks[supportedWoodType.ordinal()] = (Block)blockSupplier.get();
        });
        return pipeBlocks;
    }

    public static void registerAll(IEventBus modEventBus) {
        TILE_TYPES.register(modEventBus);
    }
}

