/*
 * Decompiled with CFR 0.152.
 */
package xyz.dogboy.swp.tiles;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import xyz.dogboy.swp.blocks.PipeBlock;
import xyz.dogboy.swp.config.SWPConfig;
import xyz.dogboy.swp.registry.BlockRegistry;
import xyz.dogboy.swp.registry.TileRegistry;
import xyz.dogboy.swp.tiles.FluidProvidingTileEntity;
import xyz.dogboy.swp.tiles.PumpTileEntity;
import xyz.dogboy.swp.utils.Both;

public class PipeTileEntity
extends FluidProvidingTileEntity
implements ITickableTileEntity {
    public List<Both<BlockPos, Direction>> connectedTanks = new ArrayList<Both<BlockPos, Direction>>();

    public PipeTileEntity() {
        super((TileEntityType)TileRegistry.PIPE.get());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction direction) {
        if (direction == null) {
            return super.getCapability(cap, null);
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && ((Boolean)this.func_195044_w().func_177229_b((Property)PipeBlock.DIRECTION_PROPERTY_MAP.get(direction))).booleanValue()) {
            return LazyOptional.of(() -> this.fluidTank).cast();
        }
        return super.getCapability(cap, direction);
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_201670_d()) {
            return;
        }
        int temperature = this.fluidTank.getFluid().getFluid().getAttributes().getTemperature();
        boolean isTemperatureImmune = BlockRegistry.getTypeByPipe((PipeBlock)((PipeBlock)this.func_195044_w().func_177230_c())).fireSafe;
        if (!isTemperatureImmune && temperature >= 550) {
            this.field_145850_b.func_180501_a(this.field_174879_c, Blocks.field_150480_ab.func_176223_P(), 3);
            return;
        }
        for (Direction direction : Direction.values()) {
            LazyOptional fluidHandler;
            TileEntity tileEntity;
            if (!this.isConnectedInDirection(direction) || (tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction))) == null || !(fluidHandler = tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.func_176734_d())).isPresent() || !this.isExtractionInDirection(direction) && !(tileEntity instanceof PumpTileEntity)) continue;
            this.pullFromTank((LazyOptional<IFluidHandler>)fluidHandler);
        }
        if (this.fluidTank.isEmpty()) {
            return;
        }
        this.pushInto();
    }

    private void pullFromTank(LazyOptional<IFluidHandler> pullFrom) {
        int freeSpace = this.fluidTank.getSpace();
        if (freeSpace <= 0) {
            return;
        }
        pullFrom.ifPresent(iFluidHandler -> {
            FluidStack drained = iFluidHandler.drain(Math.min(freeSpace, (Integer)SWPConfig.GENERAL.transferRate.get()), IFluidHandler.FluidAction.EXECUTE);
            this.fluidTank.fill(drained, IFluidHandler.FluidAction.EXECUTE);
        });
    }

    private void pushInto() {
        AtomicInteger removedFluid = new AtomicInteger();
        for (Both<BlockPos, Direction> tankConnection : this.connectedTanks) {
            TileEntity tank = this.field_145850_b.func_175625_s(tankConnection.left());
            if (tank == null || this.fluidTank.isEmpty()) continue;
            LazyOptional pushInto = tank.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, tankConnection.right().func_176734_d());
            pushInto.ifPresent(iFluidHandler -> {
                FluidStack toRemove = this.fluidTank.getFluid().copy();
                toRemove.setAmount(Math.min(toRemove.getAmount(), (Integer)SWPConfig.GENERAL.transferRate.get() - removedFluid.get()));
                int pushed = iFluidHandler.fill(toRemove, IFluidHandler.FluidAction.EXECUTE);
                toRemove.setAmount(pushed);
                this.fluidTank.drain(toRemove, IFluidHandler.FluidAction.EXECUTE);
                removedFluid.addAndGet(pushed);
            });
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        AtomicInteger iterator = new AtomicInteger();
        CompoundNBT tankData = new CompoundNBT();
        tankData.func_74768_a("count", this.connectedTanks.size());
        this.connectedTanks.forEach(blockPosDirectionBoth -> {
            CompoundNBT connectionNBT = NBTUtil.func_186859_a((BlockPos)((BlockPos)blockPosDirectionBoth.left()));
            connectionNBT.func_74768_a("direction", ((Direction)blockPosDirectionBoth.right()).ordinal());
            tankData.func_218657_a(iterator.get() + "", (INBT)connectionNBT);
        });
        nbt.func_218657_a("connectionData", (INBT)tankData);
        return nbt;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        CompoundNBT tankData = nbt.func_74775_l("connectionData");
        for (int i = 0; i < tankData.func_74762_e("count"); ++i) {
            CompoundNBT connectionNBT = tankData.func_74775_l(i + "");
            BlockPos pos = NBTUtil.func_186861_c((CompoundNBT)connectionNBT);
            Direction direction = Direction.values()[connectionNBT.func_74762_e("direction")];
            this.connectedTanks.add(new Both<BlockPos, Direction>(pos, direction));
        }
    }

    private boolean isExtractionInDirection(Direction direction) {
        return this.isConnectedInDirection(direction) && (Boolean)this.func_195044_w().func_177229_b((Property)PipeBlock.DIRECTION_EXTRACTION_PROPERTY_MAP.get(direction)) != false;
    }

    private boolean isConnectedInDirection(Direction direction) {
        return (Boolean)this.func_195044_w().func_177229_b((Property)PipeBlock.DIRECTION_PROPERTY_MAP.get(direction));
    }
}

