/*
 * Decompiled with CFR 0.152.
 */
package xyz.dogboy.swp.tiles;

import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import xyz.dogboy.swp.SimpleWoodenPipes;
import xyz.dogboy.swp.blocks.PipeBlock;
import xyz.dogboy.swp.blocks.PumpBlock;
import xyz.dogboy.swp.config.SWPConfig;
import xyz.dogboy.swp.registry.TileRegistry;
import xyz.dogboy.swp.tiles.FluidProvidingTileEntity;

public class PumpTileEntity
extends FluidProvidingTileEntity
implements ITickableTileEntity {
    private static final Method isInfinite = ObfuscationReflectionHelper.findMethod(FlowingFluid.class, (String)"func_205579_d", (Class[])new Class[0]);

    public PumpTileEntity() {
        super((TileEntityType)TileRegistry.PUMP.get());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction direction) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && direction == Direction.UP && ((Boolean)this.func_195044_w().func_177229_b((Property)PumpBlock.CONNECTED)).booleanValue()) {
            return LazyOptional.of(() -> this.fluidTank).cast();
        }
        return super.getCapability(cap, direction);
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_201670_d()) {
            return;
        }
        this.fillPump();
        this.pushPump();
    }

    private void pushPump() {
        if (!((Boolean)this.func_195044_w().func_177229_b((Property)PumpBlock.CONNECTED)).booleanValue() || this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_177230_c() instanceof PipeBlock || this.fluidTank.getFluid().isEmpty()) {
            return;
        }
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        LazyOptional pushInto = tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.DOWN);
        pushInto.ifPresent(iFluidHandler -> {
            FluidStack toRemove = this.fluidTank.getFluid().copy();
            toRemove.setAmount(Math.min(toRemove.getAmount(), (Integer)SWPConfig.GENERAL.transferRate.get()));
            int pushed = iFluidHandler.fill(toRemove, IFluidHandler.FluidAction.EXECUTE);
            toRemove.setAmount(pushed);
            this.fluidTank.drain(toRemove, IFluidHandler.FluidAction.EXECUTE);
        });
    }

    private void fillPump() {
        if (this.shouldFill() && this.canFill()) {
            this.fluidTank.fill(new FluidStack(this.field_145850_b.func_204610_c(this.field_174879_c.func_177977_b()).func_206886_c(), ((Integer)SWPConfig.GENERAL.pumpRate.get()).intValue()), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    private boolean shouldFill() {
        if (this.fluidTank.getSpace() == 0) {
            return false;
        }
        if (this.fluidTank.isEmpty()) {
            return true;
        }
        Fluid tankFluid = this.fluidTank.getFluid().getFluid();
        return tankFluid == this.field_145850_b.func_204610_c(this.field_174879_c.func_177977_b()).func_206886_c();
    }

    private boolean canFill() {
        BlockPos pos = this.func_174877_v().func_177977_b();
        int fluidSources = 0;
        FluidState fluid = this.field_145850_b.func_204610_c(pos);
        if (!(fluid.func_206886_c() instanceof FlowingFluid)) {
            return false;
        }
        try {
            boolean isFluidInfinite = (Boolean)isInfinite.invoke((Object)fluid.func_206886_c(), new Object[0]);
            if (!isFluidInfinite || !fluid.func_206889_d()) {
                return false;
            }
            for (Direction direction : Direction.values()) {
                if (!direction.func_176740_k().func_176722_c() || fluid.func_206886_c() != this.field_145850_b.func_204610_c(pos.func_177972_a(direction)).func_206886_c() || !this.field_145850_b.func_204610_c(pos.func_177972_a(direction)).func_206889_d()) continue;
                ++fluidSources;
            }
            if (fluidSources >= 2) {
                return true;
            }
        }
        catch (Exception e) {
            SimpleWoodenPipes.LOGGER.error((Object)e);
        }
        return false;
    }
}

