/*
 * Decompiled with CFR 0.152.
 */
package xyz.dogboy.swp.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import xyz.dogboy.swp.SimpleWoodenPipes;
import xyz.dogboy.swp.blocks.PipeBlock;
import xyz.dogboy.swp.blocks.PumpBlock;
import xyz.dogboy.swp.tiles.PipeTileEntity;
import xyz.dogboy.swp.utils.Both;

public class PipeNetworkHelper {
    private PipeNetworkHelper() {
    }

    public static void generateNetwork(IWorldReader world, BlockPos pos) {
        List<BlockPos> pipes = PipeNetworkHelper.getConnectedPipes(world, pos);
        List<Both<BlockPos, Direction>> tanks = PipeNetworkHelper.getConnectedTanks(pipes, world);
        PipeNetworkHelper.updateReferences(pipes, tanks, world);
    }

    private static List<BlockPos> getConnectedPipes(IWorldReader world, BlockPos pos) {
        ArrayList<BlockPos> connectedPipes = new ArrayList<BlockPos>();
        try {
            PipeNetworkHelper.addConnectedToPipes(world, pos, connectedPipes);
        }
        catch (Exception e) {
            SimpleWoodenPipes.LOGGER.error("Cant generate Connected Pipes Network. Network too large. Please don't escalate so much", (Throwable)e);
        }
        return connectedPipes;
    }

    private static List<BlockPos> addConnectedToPipes(IWorldReader world, BlockPos pos, List<BlockPos> connectedPipes) {
        connectedPipes.add(pos);
        for (Direction direction : Direction.values()) {
            if (connectedPipes.contains(pos.func_177972_a(direction)) || !PipeNetworkHelper.canConnectTo(world.func_180495_p(pos), (IBlockReader)world, pos, direction, false) || !(world.func_180495_p(pos.func_177972_a(direction)).func_177230_c() instanceof PipeBlock)) continue;
            PipeNetworkHelper.addConnectedToPipes(world, pos.func_177972_a(direction), connectedPipes);
        }
        return connectedPipes;
    }

    private static List<Both<BlockPos, Direction>> getConnectedTanks(List<BlockPos> pipes, IWorldReader world) {
        ArrayList<Both<BlockPos, Direction>> connectedTanks = new ArrayList<Both<BlockPos, Direction>>();
        pipes.forEach(pos -> PipeNetworkHelper.addConnectedTanks(connectedTanks, pos, world));
        return connectedTanks;
    }

    private static List<Both<BlockPos, Direction>> addConnectedTanks(List<Both<BlockPos, Direction>> tanks, BlockPos pos, IWorldReader world) {
        for (Direction direction : Direction.values()) {
            if (tanks.contains(pos.func_177972_a(direction)) || !PipeNetworkHelper.canConnectTo(world.func_180495_p(pos), (IBlockReader)world, pos, direction, true) || ((Boolean)world.func_180495_p(pos).func_177229_b((Property)PipeBlock.DIRECTION_EXTRACTION_PROPERTY_MAP.get(direction))).booleanValue() || world.func_180495_p(pos.func_177972_a(direction)).func_177230_c() instanceof PumpBlock) continue;
            tanks.add(new Both<BlockPos, Direction>(pos.func_177972_a(direction), direction));
        }
        return tanks;
    }

    private static void updateReferences(List<BlockPos> pipes, List<Both<BlockPos, Direction>> tanks, IWorldReader world) {
        pipes.forEach(pipe -> {
            ((PipeTileEntity)world.func_175625_s((BlockPos)pipe)).connectedTanks = tanks;
        });
    }

    public static boolean canConnectTo(BlockState state, IBlockReader world, BlockPos pipePos, Direction direction, boolean withoutPipe) {
        TileEntity tileEntity;
        BlockState connectTo = world.func_180495_p(pipePos.func_177972_a(direction));
        if (withoutPipe) {
            if (connectTo.func_177230_c() instanceof PipeBlock || state.func_177230_c() instanceof PumpBlock) {
                return false;
            }
        } else {
            if (connectTo.func_177230_c() instanceof PumpBlock && direction == Direction.DOWN) {
                return true;
            }
            if (connectTo.func_177230_c() instanceof PipeBlock) {
                return ((PipeBlock)connectTo.func_177230_c()).getWoodType() == ((PipeBlock)state.func_177230_c()).getWoodType();
            }
        }
        return (tileEntity = world.func_175625_s(pipePos.func_177972_a(direction))) != null && tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.func_176734_d()).isPresent();
    }
}

