/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplylight.data;

import com.flanks255.simplylight.SimplyLight;
import com.flanks255.simplylight.blocks.LampBlock;
import com.flanks255.simplylight.blocks.RodLamp;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class BlockStates
extends BlockStateProvider {
    public BlockStates(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "simplylight", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.generateLampBlock();
        this.generateThinLamps();
        this.myDirectionalBlock(SimplyLight.LIGHTBULB.get(), $ -> this.models().getExistingFile(this.modLoc("block/lightbulb")), 180);
        this.generateRodLamp();
        this.generateWallLamp();
    }

    private void generateWallLamp() {
        ModelFile.ExistingModelFile wallModel = this.models().getExistingFile(this.modLoc("block/wall_lamp"));
        ModelFile.ExistingModelFile floorModel = this.models().getExistingFile(this.modLoc("block/floorlamp"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(SimplyLight.WALL_LAMP.get()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP).modelForState().modelFile((ModelFile)floorModel).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.DOWN).modelForState().modelFile((ModelFile)floorModel).rotationX(180).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)wallModel).rotationY(270).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)wallModel).rotationY(90).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)wallModel).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)wallModel).rotationY(180).addModel();
    }

    private void generateThinLamps() {
        this.myDirectionalBlock(SimplyLight.ILLUMINANTSLAB.get(), $ -> this.models().getExistingFile(this.modLoc("block/illuminant_slab")), 180);
        this.myDirectionalBlock(SimplyLight.ILLUMINANTPANEL.get(), $ -> this.models().getExistingFile(this.modLoc("block/illuminant_panel")), 180);
    }

    void generateRodLamp() {
        RodLamp block = SimplyLight.RODLAMP.get();
        ModelFile.ExistingModelFile model = this.models().getExistingFile(this.modLoc("block/rodlamp"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)model).rotationX(90).addModel()).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)model).rotationX(90).rotationY(90).addModel();
    }

    private void generateLampBlock() {
        ResourceLocation offTex = this.modLoc("block/illuminant_block");
        ResourceLocation onTex = this.modLoc("block/illuminant_block_on");
        ModelBuilder.ElementBuilder illuminantBlockBuilder = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(SimplyLight.ILLUMINANTBLOCK.get().getRegistryName().m_135815_(), "cube")).texture("all", offTex)).texture("particle", offTex)).ao(false)).element();
        ModelBuilder modelIlluminantBlock = illuminantBlockBuilder.cube("#all").shade(false).end();
        ModelBuilder.ElementBuilder illuminantBlockBuilder_On = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(SimplyLight.ILLUMINANTBLOCK_ON.get().getRegistryName().m_135815_(), "cube")).texture("all", onTex)).texture("particle", onTex)).ao(false)).element();
        ModelBuilder modelIlluminantBlock_on = illuminantBlockBuilder_On.cube("#all").shade(false).end();
        VariantBlockStateBuilder LampBlockBuilder = this.getVariantBuilder(SimplyLight.ILLUMINANTBLOCK.get());
        LampBlockBuilder.partialState().with((Property)LampBlock.ON, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)modelIlluminantBlock_on).addModel();
        LampBlockBuilder.partialState().with((Property)LampBlock.ON, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)modelIlluminantBlock).addModel();
        VariantBlockStateBuilder LampBlockOnBuilder = this.getVariantBuilder(SimplyLight.ILLUMINANTBLOCK_ON.get());
        LampBlockOnBuilder.partialState().with((Property)LampBlock.ON, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)modelIlluminantBlock_on).addModel();
        LampBlockOnBuilder.partialState().with((Property)LampBlock.ON, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)modelIlluminantBlock).addModel();
    }

    public void myDirectionalBlock(Block block, Function<BlockState, ModelFile> modelFunc, int angleOffset) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(dir == Direction.DOWN ? 180 : (dir.m_122434_().m_122479_() ? 90 : 0)).rotationY(dir.m_122434_().m_122478_() ? 0 : ((int)dir.m_122435_() + angleOffset) % 360).build();
        }, new Property[]{BlockStateProperties.f_61362_});
    }
}

