/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplylight.data;

import com.flanks255.simplylight.SimplyLight;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;

public class LootTables
extends LootTableProvider {
    public LootTables(DataGenerator gen) {
        super(gen);
    }

    @Nonnull
    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(Blocks::new, (Object)LootContextParamSets.f_81421_));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, @Nonnull ValidationContext validationTracker) {
        map.forEach((name, table) -> net.minecraft.world.level.storage.loot.LootTables.m_79202_((ValidationContext)validationTracker, (ResourceLocation)name, (LootTable)table));
    }

    private static class Blocks
    extends BlockLoot {
        private Blocks() {
        }

        protected void addTables() {
            for (RegistryObject block : SimplyLight.BLOCKS.getEntries()) {
                this.m_124288_((Block)block.get());
            }
        }

        @Nonnull
        protected Iterable<Block> getKnownBlocks() {
            return ForgeRegistries.BLOCKS.getValues().stream().filter(b -> b.getRegistryName().m_135827_().equals("simplylight")).collect(Collectors.toList());
        }
    }
}

