/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.boss_tools.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mcreator.boss_tools.BossToolsModElements;
import net.mcreator.boss_tools.gui.RocketTier1GUIFuelGui;
import net.mcreator.boss_tools.procedures.RocketEntityIsHurt1Procedure;
import net.mcreator.boss_tools.procedures.RocketOnEntityTickUpdateProcedure;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EntityArmorInvWrapper;
import net.minecraftforge.items.wrapper.EntityHandsInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;

@BossToolsModElements.ModElement.Tag
public class RocketEntity
extends BossToolsModElements.ModElement {
    public static EntityType entity = null;

    public RocketEntity(BossToolsModElements instance) {
        super(instance, 77);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        NetworkLoader.registerMessages();
    }

    @Override
    public void initElements() {
        entity = (EntityType)EntityType.Builder.func_220322_a(CustomEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(100).setUpdateInterval(3).setCustomClientFactory(CustomEntity::new).func_220320_c().func_220321_a(1.0f, 3.0f).func_206830_a("rocket").setRegistryName("rocket");
        this.elements.entities.add(() -> entity);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)entity, renderManager -> new MobRenderer(renderManager, new ModelRocketTier1(), 0.5f){

            public ResourceLocation func_110775_a(Entity entity) {
                return new ResourceLocation("boss_tools:textures/rockettier1newnew.png");
            }
        });
    }

    private static class RocketSpin2Packet {
        private double animationpitch;
        private int entityId;

        public RocketSpin2Packet(int entityId, double animationpitch) {
            this.animationpitch = animationpitch;
            this.entityId = entityId;
        }

        public static void encode(RocketSpin2Packet msg, PacketBuffer buf) {
            buf.writeInt(msg.entityId);
            buf.writeDouble(msg.animationpitch);
        }

        public static RocketSpin2Packet decode(PacketBuffer buf) {
            return new RocketSpin2Packet(buf.readInt(), buf.readDouble());
        }

        public static void handle(RocketSpin2Packet msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(msg.entityId);
                if (entity instanceof LivingEntity) {
                    ((LivingEntity)entity).getPersistentData().func_74780_a("AnimationPitch", msg.animationpitch);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    private static class RocketSpinPacket {
        private double animation;
        private int entityId;

        public RocketSpinPacket(int entityId, double animation) {
            this.animation = animation;
            this.entityId = entityId;
        }

        public static void encode(RocketSpinPacket msg, PacketBuffer buf) {
            buf.writeInt(msg.entityId);
            buf.writeDouble(msg.animation);
        }

        public static RocketSpinPacket decode(PacketBuffer buf) {
            return new RocketSpinPacket(buf.readInt(), buf.readDouble());
        }

        public static void handle(RocketSpinPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(msg.entityId);
                if (entity instanceof LivingEntity) {
                    ((LivingEntity)entity).getPersistentData().func_74780_a("Animation", msg.animation);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    private static class NetworkLoader {
        public static SimpleChannel INSTANCE;
        private static int id;

        private NetworkLoader() {
        }

        public static int nextID() {
            return id++;
        }

        public static void registerMessages() {
            INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("boss_tools", "rocket_link"), () -> "1.0", s -> true, s -> true);
            INSTANCE.registerMessage(NetworkLoader.nextID(), RocketSpinPacket.class, RocketSpinPacket::encode, RocketSpinPacket::decode, RocketSpinPacket::handle);
            INSTANCE.registerMessage(NetworkLoader.nextID(), RocketSpin2Packet.class, RocketSpin2Packet::encode, RocketSpin2Packet::decode, RocketSpin2Packet::handle);
        }

        static {
            id = 1;
        }
    }

    public static class ModelRocketTier1
    extends EntityModel<Entity> {
        private final ModelRenderer Rocket;

        public ModelRocketTier1() {
            this.field_78090_t = 512;
            this.field_78089_u = 256;
            this.Rocket = new ModelRenderer((Model)this);
            this.Rocket.func_78793_a(0.0f, 23.0f, 0.0f);
            this.Rocket.func_78784_a(43, 17).func_228303_a_(11.0f, -7.0f, -1.0f, 1.0f, 6.0f, 2.0f, 0.0f, false);
            this.Rocket.func_78784_a(43, 17).func_228303_a_(-1.0f, -7.0f, -12.0f, 2.0f, 6.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(43, 17).func_228303_a_(-12.0f, -7.0f, -1.0f, 1.0f, 6.0f, 2.0f, 0.0f, false);
            this.Rocket.func_78784_a(43, 17).func_228303_a_(-1.0f, -7.0f, 11.0f, 2.0f, 6.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(273, 90).func_228303_a_(4.0f, -31.0f, -8.0f, 3.0f, 7.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(273, 90).func_228303_a_(-7.0f, -31.0f, -8.0f, 3.0f, 7.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(85, 46).func_228303_a_(3.0f, -31.0f, -8.1f, 1.0f, 7.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(86, 47).func_228303_a_(-4.0f, -31.0f, -8.1f, 1.0f, 7.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(87, 52).func_228303_a_(-3.0f, -31.0f, -8.1f, 6.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(89, 52).func_228303_a_(-3.0f, -25.0f, -8.1f, 6.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(274, 82).func_228303_a_(-7.0f, -39.0f, -8.0f, 14.0f, 8.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(276, 135).func_228303_a_(-7.0f, -24.0f, -8.0f, 14.0f, 19.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(279, 120).func_228303_a_(-7.0f, -39.0f, 7.0f, 14.0f, 34.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(276, 107).func_228303_a_(-8.0f, -39.0f, -7.0f, 1.0f, 34.0f, 14.0f, 0.0f, false);
            this.Rocket.func_78784_a(307, 78).func_228303_a_(-8.0f, -40.0f, -8.0f, 1.0f, 35.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(307, 78).func_228303_a_(-8.0f, -40.0f, 7.0f, 1.0f, 35.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(37, 23).func_228303_a_(-7.0f, -40.0f, 7.0f, 14.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(37, 23).func_228303_a_(-7.0f, -40.0f, -8.0f, 14.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(29, 17).func_228303_a_(-8.0f, -40.0f, -7.0f, 1.0f, 1.0f, 14.0f, 0.0f, false);
            this.Rocket.func_78784_a(29, 17).func_228303_a_(7.0f, -40.0f, -7.0f, 1.0f, 1.0f, 14.0f, 0.0f, false);
            this.Rocket.func_78784_a(307, 78).func_228303_a_(7.0f, -40.0f, 7.0f, 1.0f, 35.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(307, 78).func_228303_a_(7.0f, -37.0f, -8.0f, 1.0f, 32.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(307, 78).func_228303_a_(7.0f, -40.0f, -8.0f, 1.0f, 3.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(43, 17).func_228303_a_(10.0f, -9.0f, -1.0f, 1.0f, 6.0f, 2.0f, 0.0f, false);
            this.Rocket.func_78784_a(43, 17).func_228303_a_(-1.0f, -9.0f, -11.0f, 2.0f, 6.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(43, 17).func_228303_a_(-11.0f, -9.0f, -1.0f, 1.0f, 6.0f, 2.0f, 0.0f, false);
            this.Rocket.func_78784_a(43, 17).func_228303_a_(-1.0f, -9.0f, 10.0f, 2.0f, 6.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(43, 17).func_228303_a_(9.0f, -10.0f, -1.0f, 1.0f, 6.0f, 2.0f, 0.0f, false);
            this.Rocket.func_78784_a(43, 17).func_228303_a_(-1.0f, -10.0f, -10.0f, 2.0f, 6.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(43, 17).func_228303_a_(-10.0f, -10.0f, -1.0f, 1.0f, 6.0f, 2.0f, 0.0f, false);
            this.Rocket.func_78784_a(43, 17).func_228303_a_(-1.0f, -10.0f, 9.0f, 2.0f, 6.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(43, 17).func_228303_a_(12.0f, -7.0f, -1.0f, 1.0f, 7.0f, 2.0f, 0.0f, false);
            this.Rocket.func_78784_a(43, 17).func_228303_a_(-1.0f, -7.0f, -13.0f, 2.0f, 7.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(43, 17).func_228303_a_(-13.0f, -7.0f, -1.0f, 1.0f, 7.0f, 2.0f, 0.0f, false);
            this.Rocket.func_78784_a(43, 17).func_228303_a_(-1.0f, -7.0f, 12.0f, 2.0f, 7.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(43, 17).func_228303_a_(13.0f, -11.0f, -1.0f, 1.0f, 13.0f, 2.0f, 0.0f, false);
            this.Rocket.func_78784_a(43, 17).func_228303_a_(-1.0f, -11.0f, -14.0f, 2.0f, 13.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(43, 17).func_228303_a_(-14.0f, -11.0f, -1.0f, 1.0f, 13.0f, 2.0f, 0.0f, false);
            this.Rocket.func_78784_a(43, 17).func_228303_a_(-1.0f, -11.0f, 13.0f, 2.0f, 13.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(43, 17).func_228303_a_(8.0f, -11.0f, -1.0f, 1.0f, 6.0f, 2.0f, 0.0f, false);
            this.Rocket.func_78784_a(43, 17).func_228303_a_(-1.0f, -11.0f, -9.0f, 2.0f, 6.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(43, 17).func_228303_a_(-9.0f, -11.0f, -1.0f, 1.0f, 6.0f, 2.0f, 0.0f, false);
            this.Rocket.func_78784_a(43, 17).func_228303_a_(-1.0f, -11.0f, 8.0f, 2.0f, 6.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(277, 106).func_228303_a_(7.0f, -39.0f, -7.0f, 1.0f, 34.0f, 14.0f, 0.0f, false);
            this.Rocket.func_78784_a(33, 87).func_228303_a_(4.0f, -41.0f, -7.0f, 2.0f, 1.0f, 14.0f, 0.0f, false);
            this.Rocket.func_78784_a(33, 87).func_228303_a_(6.0f, -41.0f, -6.0f, 1.0f, 1.0f, 12.0f, 0.0f, false);
            this.Rocket.func_78784_a(33, 87).func_228303_a_(-7.0f, -41.0f, -6.0f, 1.0f, 1.0f, 12.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(-7.0f, -41.0f, -7.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(6.0f, -41.0f, -7.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(5.0f, -42.0f, -6.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(5.0f, -43.0f, -6.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(4.0f, -45.0f, -5.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(4.0f, -44.0f, -5.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(4.0f, -45.0f, 4.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(4.0f, -44.0f, 4.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(-5.0f, -45.0f, -5.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(-4.0f, -47.0f, -4.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(-3.0f, -49.0f, -3.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(-3.0f, -48.0f, -3.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(2.0f, -49.0f, -3.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(2.0f, -48.0f, -3.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(-3.0f, -49.0f, 2.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(-2.0f, -50.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(-2.0f, -51.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(-2.0f, -50.0f, -2.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(-2.0f, -51.0f, -2.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(1.0f, -50.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(1.0f, -51.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(1.0f, -50.0f, -2.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(1.0f, -51.0f, -2.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(-3.0f, -48.0f, 2.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(2.0f, -49.0f, 2.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(2.0f, -48.0f, 2.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(-4.0f, -46.0f, -4.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(-4.0f, -47.0f, 3.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(-4.0f, -46.0f, 3.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(3.0f, -47.0f, -4.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(3.0f, -46.0f, -4.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(3.0f, -47.0f, 3.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(3.0f, -46.0f, 3.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(-5.0f, -44.0f, -5.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(-5.0f, -45.0f, 4.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(-5.0f, -44.0f, 4.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(-6.0f, -42.0f, -6.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(-6.0f, -43.0f, -6.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(5.0f, -42.0f, 5.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(5.0f, -43.0f, 5.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(-6.0f, -42.0f, 5.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(-6.0f, -43.0f, 5.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(-7.0f, -41.0f, 6.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(249, 94).func_228303_a_(6.0f, -41.0f, 6.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(31, 17).func_228303_a_(4.0f, -5.0f, -8.0f, 4.0f, 1.0f, 16.0f, 0.0f, false);
            this.Rocket.func_78784_a(31, 17).func_228303_a_(3.0f, -40.0f, -7.0f, 4.0f, 1.0f, 14.0f, 0.0f, false);
            this.Rocket.func_78784_a(64, 5).func_228303_a_(-1.0f, -68.0f, -1.0f, 2.0f, 2.0f, 2.0f, 0.0f, false);
            this.Rocket.func_78784_a(500, 146).func_228303_a_(-1.0f, -66.0f, -1.0f, 2.0f, 15.0f, 2.0f, 0.0f, false);
            this.Rocket.func_78784_a(64, 102).func_228303_a_(-1.0f, -50.0f, -2.0f, 2.0f, 1.0f, 4.0f, 0.0f, false);
            this.Rocket.func_78784_a(64, 102).func_228303_a_(-1.0f, -51.0f, -2.0f, 2.0f, 1.0f, 4.0f, 0.0f, false);
            this.Rocket.func_78784_a(64, 102).func_228303_a_(-2.0f, -50.0f, -1.0f, 1.0f, 1.0f, 2.0f, 0.0f, false);
            this.Rocket.func_78784_a(64, 102).func_228303_a_(-2.0f, -51.0f, -1.0f, 1.0f, 1.0f, 2.0f, 0.0f, false);
            this.Rocket.func_78784_a(64, 102).func_228303_a_(1.0f, -50.0f, -1.0f, 1.0f, 1.0f, 2.0f, 0.0f, false);
            this.Rocket.func_78784_a(64, 102).func_228303_a_(1.0f, -51.0f, -1.0f, 1.0f, 1.0f, 2.0f, 0.0f, false);
            this.Rocket.func_78784_a(88, 110).func_228303_a_(-3.0f, -49.0f, -2.0f, 6.0f, 1.0f, 4.0f, 0.0f, false);
            this.Rocket.func_78784_a(88, 110).func_228303_a_(-3.0f, -48.0f, -2.0f, 6.0f, 1.0f, 4.0f, 0.0f, false);
            this.Rocket.func_78784_a(88, 110).func_228303_a_(-2.0f, -49.0f, -3.0f, 4.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(88, 110).func_228303_a_(-2.0f, -48.0f, -3.0f, 4.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(88, 110).func_228303_a_(-2.0f, -49.0f, 2.0f, 4.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(88, 110).func_228303_a_(-2.0f, -48.0f, 2.0f, 4.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(88, 88).func_228303_a_(-3.0f, -47.0f, -4.0f, 6.0f, 1.0f, 8.0f, 0.0f, false);
            this.Rocket.func_78784_a(88, 88).func_228303_a_(-3.0f, -46.0f, -4.0f, 6.0f, 1.0f, 8.0f, 0.0f, false);
            this.Rocket.func_78784_a(88, 88).func_228303_a_(3.0f, -47.0f, -3.0f, 1.0f, 1.0f, 6.0f, 0.0f, false);
            this.Rocket.func_78784_a(88, 88).func_228303_a_(3.0f, -46.0f, -3.0f, 1.0f, 1.0f, 6.0f, 0.0f, false);
            this.Rocket.func_78784_a(88, 88).func_228303_a_(-4.0f, -47.0f, -3.0f, 1.0f, 1.0f, 6.0f, 0.0f, false);
            this.Rocket.func_78784_a(88, 88).func_228303_a_(-4.0f, -46.0f, -3.0f, 1.0f, 1.0f, 6.0f, 0.0f, false);
            this.Rocket.func_78784_a(75, 97).func_228303_a_(-4.0f, -45.0f, -5.0f, 8.0f, 1.0f, 10.0f, 0.0f, false);
            this.Rocket.func_78784_a(75, 97).func_228303_a_(-4.0f, -44.0f, -5.0f, 8.0f, 1.0f, 10.0f, 0.0f, false);
            this.Rocket.func_78784_a(75, 97).func_228303_a_(-5.0f, -45.0f, -4.0f, 1.0f, 1.0f, 8.0f, 0.0f, false);
            this.Rocket.func_78784_a(75, 97).func_228303_a_(-5.0f, -44.0f, -4.0f, 1.0f, 1.0f, 8.0f, 0.0f, false);
            this.Rocket.func_78784_a(75, 97).func_228303_a_(4.0f, -45.0f, -4.0f, 1.0f, 1.0f, 8.0f, 0.0f, false);
            this.Rocket.func_78784_a(75, 97).func_228303_a_(4.0f, -44.0f, -4.0f, 1.0f, 1.0f, 8.0f, 0.0f, false);
            this.Rocket.func_78784_a(65, 106).func_228303_a_(-5.0f, -42.0f, -6.0f, 10.0f, 1.0f, 12.0f, 0.0f, false);
            this.Rocket.func_78784_a(65, 106).func_228303_a_(-5.0f, -43.0f, -6.0f, 10.0f, 1.0f, 12.0f, 0.0f, false);
            this.Rocket.func_78784_a(65, 106).func_228303_a_(-6.0f, -42.0f, -5.0f, 1.0f, 1.0f, 10.0f, 0.0f, false);
            this.Rocket.func_78784_a(65, 106).func_228303_a_(-6.0f, -43.0f, -5.0f, 1.0f, 1.0f, 10.0f, 0.0f, false);
            this.Rocket.func_78784_a(65, 106).func_228303_a_(5.0f, -42.0f, -5.0f, 1.0f, 1.0f, 10.0f, 0.0f, false);
            this.Rocket.func_78784_a(65, 106).func_228303_a_(5.0f, -43.0f, -5.0f, 1.0f, 1.0f, 10.0f, 0.0f, false);
            this.Rocket.func_78784_a(66, 94).func_228303_a_(-6.0f, -41.0f, -7.0f, 10.0f, 1.0f, 14.0f, 0.0f, false);
            this.Rocket.func_78784_a(444, 32).func_228303_a_(-7.0f, -5.0f, -6.0f, 11.0f, 1.0f, 14.0f, 0.0f, false);
            this.Rocket.func_78784_a(30, 14).func_228303_a_(-7.0f, -40.0f, -7.0f, 10.0f, 1.0f, 14.0f, 0.0f, false);
            this.Rocket.func_78784_a(43, 17).func_228303_a_(-7.0f, -5.0f, -8.0f, 11.0f, 1.0f, 2.0f, 0.0f, false);
            this.Rocket.func_78784_a(27, 15).func_228303_a_(-8.0f, -5.0f, -8.0f, 1.0f, 1.0f, 16.0f, 0.0f, false);
            this.Rocket.func_78784_a(33, 23).func_228303_a_(-3.0f, -4.0f, -3.0f, 6.0f, 1.0f, 6.0f, 0.0f, false);
            this.Rocket.func_78784_a(30, 23).func_228303_a_(-3.0f, -3.0f, -3.0f, 1.0f, 1.0f, 6.0f, 0.0f, false);
            this.Rocket.func_78784_a(14, 2).func_228303_a_(-3.0f, -3.0f, -3.0f, 6.0f, 0.0f, 6.0f, 0.0f, false);
            this.Rocket.func_78784_a(33, 29).func_228303_a_(-4.0f, -2.0f, 3.0f, 8.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(37, 26).func_228303_a_(-4.0f, -2.0f, -4.0f, 8.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(45, 20).func_228303_a_(3.0f, -2.0f, -3.0f, 1.0f, 1.0f, 6.0f, 0.0f, false);
            this.Rocket.func_78784_a(37, 20).func_228303_a_(-4.0f, -2.0f, -3.0f, 1.0f, 1.0f, 6.0f, 0.0f, false);
            this.Rocket.func_78784_a(34, 17).func_228303_a_(2.0f, -3.0f, -3.0f, 1.0f, 1.0f, 6.0f, 0.0f, false);
            this.Rocket.func_78784_a(39, 26).func_228303_a_(-2.0f, -3.0f, 2.0f, 4.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(40, 11).func_228303_a_(-2.0f, -3.0f, -3.0f, 4.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(34, 30).func_228303_a_(-5.0f, -1.0f, -5.0f, 10.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(32, 16).func_228303_a_(-5.0f, -1.0f, 4.0f, 10.0f, 1.0f, 1.0f, 0.0f, false);
            this.Rocket.func_78784_a(34, 23).func_228303_a_(4.0f, -1.0f, -4.0f, 1.0f, 1.0f, 8.0f, 0.0f, false);
            this.Rocket.func_78784_a(34, 17).func_228303_a_(-5.0f, -1.0f, -4.0f, 1.0f, 1.0f, 8.0f, 0.0f, false);
        }

        public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            this.Rocket.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        }

        public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        public void func_225597_a_(Entity e, float f, float f1, float f2, float f3, float f4) {
            this.Rocket.field_78796_g = f3 / 57.295776f;
            this.Rocket.field_78808_h = f2 / 57.295776f;
            if (e instanceof LivingEntity) {
                this.Rocket.field_78808_h = (float)((LivingEntity)e).getPersistentData().func_74769_h("Animation");
            }
            this.Rocket.field_78795_f = f2 / 57.295776f;
            if (e instanceof LivingEntity) {
                this.Rocket.field_78795_f = (float)((LivingEntity)e).getPersistentData().func_74769_h("AnimationPitch");
            }
        }
    }

    public static class CustomEntity
    extends CreatureEntity {
        private final ItemStackHandler inventory = new ItemStackHandler(9){

            public int getSlotLimit(int slot) {
                return 64;
            }
        };
        private final CombinedInvWrapper combined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, new EntityHandsInvWrapper((LivingEntity)this), new EntityArmorInvWrapper((LivingEntity)this)});

        public CustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            this((EntityType<CustomEntity>)entity, world);
        }

        public CustomEntity(EntityType<CustomEntity> type, World world) {
            super(type, world);
            this.field_70728_aV = 5;
            this.func_94061_f(false);
            this.func_110163_bv();
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        protected void func_184651_r() {
            super.func_184651_r();
        }

        public CreatureAttribute func_70668_bt() {
            return CreatureAttribute.field_223222_a_;
        }

        public boolean func_213397_c(double distanceToClosestPlayer) {
            return false;
        }

        public double func_70042_X() {
            return super.func_70042_X() + -1.7000000000000002;
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(""));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(""));
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            CustomEntity entity = this;
            Entity sourceentity = source.func_76346_g();
            HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
            $_dependencies.put("entity", (Object)entity);
            $_dependencies.put("x", x);
            $_dependencies.put("y", y);
            $_dependencies.put("z", z);
            $_dependencies.put("world", this.field_70170_p);
            RocketEntityIsHurt1Procedure.executeProcedure($_dependencies);
            if (source.func_76364_f() instanceof ArrowEntity) {
                return false;
            }
            if (source.func_76364_f() instanceof PlayerEntity) {
                return false;
            }
            if (source.func_76364_f() instanceof PotionEntity) {
                return false;
            }
            if (source == DamageSource.field_76379_h) {
                return false;
            }
            if (source == DamageSource.field_76367_g) {
                return false;
            }
            if (source == DamageSource.field_76369_e) {
                return false;
            }
            if (source == DamageSource.field_180137_b) {
                return false;
            }
            return super.func_70097_a(source, amount);
        }

        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
            if (this.func_70089_S() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side == null) {
                return LazyOptional.of(() -> this.combined).cast();
            }
            return super.getCapability(capability, side);
        }

        protected void func_213337_cE() {
            super.func_213337_cE();
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack itemstack = this.inventory.getStackInSlot(i);
                if (itemstack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)itemstack)) continue;
                this.func_199701_a_(itemstack);
            }
        }

        public void func_213281_b(CompoundNBT compound) {
            super.func_213281_b(compound);
            compound.func_218657_a("InventoryCustom", (INBT)this.inventory.serializeNBT());
        }

        public void func_70037_a(CompoundNBT compound) {
            super.func_70037_a(compound);
            INBT inventoryCustom = compound.func_74781_a("InventoryCustom");
            if (inventoryCustom instanceof CompoundNBT) {
                this.inventory.deserializeNBT((CompoundNBT)inventoryCustom);
            }
        }

        public boolean func_184645_a(final PlayerEntity sourceentity, Hand hand) {
            ItemStack itemstack = sourceentity.func_184586_b(hand);
            boolean retval = true;
            if (sourceentity.func_226563_dT_()) {
                if (sourceentity instanceof ServerPlayerEntity) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)sourceentity), (INamedContainerProvider)new INamedContainerProvider(){

                        public ITextComponent func_145748_c_() {
                            return new StringTextComponent("Rocket");
                        }

                        public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
                            PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
                            packetBuffer.func_179255_a(new BlockPos((Entity)sourceentity));
                            packetBuffer.writeByte(0);
                            packetBuffer.func_150787_b(this.func_145782_y());
                            return new RocketTier1GUIFuelGui.GuiContainerMod(id, inventory, packetBuffer);
                        }
                    }, buf -> {
                        buf.func_179255_a(new BlockPos((Entity)sourceentity));
                        buf.writeByte(0);
                        buf.func_150787_b(this.func_145782_y());
                    });
                }
                return true;
            }
            super.func_184645_a(sourceentity, hand);
            sourceentity.func_184220_m((Entity)this);
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            CustomEntity entity = this;
            return retval;
        }

        public void func_70030_z() {
            super.func_70030_z();
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            CustomEntity entity = this;
            HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
            $_dependencies.put("entity", (Object)entity);
            $_dependencies.put("x", x);
            $_dependencies.put("y", y);
            $_dependencies.put("z", z);
            $_dependencies.put("world", this.field_70170_p);
            RocketOnEntityTickUpdateProcedure.executeProcedure($_dependencies);
            if (!this.field_70170_p.field_72995_K) {
                NetworkLoader.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this), (Object)new RocketSpinPacket(this.func_145782_y(), this.getPersistentData().func_74769_h("Animation")));
            }
            if (!this.field_70170_p.field_72995_K) {
                NetworkLoader.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this), (Object)new RocketSpin2Packet(this.func_145782_y(), this.getPersistentData().func_74769_h("AnimationPitch")));
            }
        }

        protected void func_110147_ax() {
            super.func_110147_ax();
            if (this.func_110148_a(SharedMonsterAttributes.field_111263_d) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111267_a) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1000.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_188791_g) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111264_e) == null) {
                this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
            }
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(0.0);
        }
    }
}

