/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.boss_tools.mixin;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.mcreator.boss_tools.world.dimension.MarsDimension;
import net.mcreator.boss_tools.world.dimension.MercuryDimension;
import net.mcreator.boss_tools.world.dimension.MoonDimension;
import net.mcreator.boss_tools.world.dimension.OrbitMarsDimension;
import net.mcreator.boss_tools.world.dimension.OrbitMercuryDimension;
import net.mcreator.boss_tools.world.dimension.OrbitMoonDimension;
import net.mcreator.boss_tools.world.dimension.UmlaufbahnerdeDimension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.dimension.DimensionType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldRenderer.class})
public class MixinWorldRenderer {
    private static final ResourceLocation SUN_TEXTUREST = new ResourceLocation("boss_tools", "textures/sky/sun.png");
    private static final ResourceLocation MOON_TEXTUREST = new ResourceLocation("boss_tools", "textures/sky/moon.png");
    private static final ResourceLocation EARTH = new ResourceLocation("boss_tools", "textures/sky/earth.png");
    private static final ResourceLocation EARTH_LIGHT_TEXTURES = new ResourceLocation("boss_tools", "textures/sky/earth_light.png");
    private static final ResourceLocation PHOBOS = new ResourceLocation("boss_tools", "textures/sky/phobos.png");
    private static final ResourceLocation DEIMOS = new ResourceLocation("boss_tools", "textures/sky/deimos.png");
    private static final ResourceLocation MARS = new ResourceLocation("boss_tools", "textures/sky/mars.png");
    private static final ResourceLocation PLUTO = new ResourceLocation("boss_tools", "textures/sky/mercury.png");
    private static final ResourceLocation SKY_TEXTURE = new ResourceLocation("boss_tools", "textures/sky/sky.png");
    private Minecraft mc = Minecraft.func_71410_x();

    @Inject(at={@At(value="HEAD")}, method={"Lnet/minecraft/client/renderer/WorldRenderer;renderSky(Lcom/mojang/blaze3d/matrix/MatrixStack;F)V"})
    public void renderSky(MatrixStack matrixStackIn, float partialTicks, CallbackInfo ci) {
        DimensionType dimensionType = Minecraft.func_71410_x().field_71441_e.field_73011_w.func_186058_p();
        if (dimensionType == MoonDimension.type) {
            this.renderSkyMoon(matrixStackIn, partialTicks);
        }
        if (dimensionType == MarsDimension.type) {
            this.renderMarsSky(matrixStackIn, partialTicks);
        }
        if (dimensionType == MercuryDimension.type) {
            this.renderSkyMercury(matrixStackIn, partialTicks);
        }
        if (dimensionType == UmlaufbahnerdeDimension.type) {
            this.renderSkyOverworldOrbit(matrixStackIn, partialTicks);
        }
        if (dimensionType == OrbitMoonDimension.type) {
            this.renderSkyMoonOrbit(matrixStackIn, partialTicks);
        }
        if (dimensionType == OrbitMarsDimension.type) {
            this.renderSkyMarsOrbit(matrixStackIn, partialTicks);
        }
        if (dimensionType == OrbitMercuryDimension.type) {
            this.renderSkyMercuryOrbit(matrixStackIn, partialTicks);
        }
    }

    private void renderSkyMoon(MatrixStack matrixStack, float partialTicks) {
        ClientWorld world = this.mc.field_71441_e;
        RenderSystem.disableTexture();
        Vec3d vector3d = world.func_228318_a_(this.mc.field_71460_t.func_215316_n().func_216780_d(), partialTicks);
        float f = (float)vector3d.field_72450_a;
        float f1 = (float)vector3d.field_72448_b;
        float f2 = (float)vector3d.field_72449_c;
        FogRenderer.func_228373_b_();
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableFog();
        RenderSystem.color3f((float)f, (float)f1, (float)f2);
        this.mc.field_71438_f.field_175012_t.func_177359_a();
        this.mc.field_71438_f.field_175014_r.func_227892_a_(0L);
        this.mc.field_71438_f.field_175012_t.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
        VertexBuffer.func_177361_b();
        this.mc.field_71438_f.field_175014_r.func_227895_d_();
        Matrix4f matrix4f1 = matrixStack.func_227866_c_().func_227870_a_();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.func_110434_K().func_110577_a(SKY_TEXTURE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -100.0f, 8.0f, -100.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 100.0f, 8.0f, -100.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 100.0f, 8.0f, 100.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -100.0f, 8.0f, 100.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.disableTexture();
        RenderSystem.disableFog();
        RenderSystem.disableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float[] afloat = world.field_73011_w.func_76560_a(world.func_72929_e(partialTicks), partialTicks);
        if (afloat != null) {
            RenderSystem.disableTexture();
            RenderSystem.shadeModel((int)7425);
            matrixStack.func_227860_a_();
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            float f3 = MathHelper.func_76126_a((float)world.func_72929_e(partialTicks)) < 0.0f ? 180.0f : 0.0f;
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f3));
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
            float f4 = afloat[0];
            float f5 = afloat[1];
            float f6 = afloat[2];
            Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
            bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_227888_a_(matrix4f, 0.0f, 100.0f, 0.0f).func_227885_a_(f4, f5, f6, afloat[3]).func_181675_d();
            for (int j = 0; j <= 16; ++j) {
                float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                float f8 = MathHelper.func_76126_a((float)f7);
                float f9 = MathHelper.func_76134_b((float)f7);
                bufferbuilder.func_227888_a_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).func_227885_a_(afloat[0], afloat[1], afloat[2], 0.0f).func_181675_d();
            }
            bufferbuilder.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
            matrixStack.func_227865_b_();
            RenderSystem.shadeModel((int)7424);
        }
        RenderSystem.enableTexture();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        matrixStack.func_227860_a_();
        float f11 = 1.0f - world.func_72867_j(partialTicks);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(world.func_72929_e(partialTicks) * 60.0f));
        matrix4f1 = matrixStack.func_227866_c_().func_227870_a_();
        float f12 = 30.0f;
        this.mc.func_110434_K().func_110577_a(SUN_TEXTUREST);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -f12, 100.0f, -f12).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, f12, 100.0f, -f12).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, f12, 100.0f, f12).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -f12, 100.0f, f12).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        f12 = 30.0f;
        this.mc.func_110434_K().func_110577_a(EARTH);
        int k = world.func_72853_d();
        int l = k % 4;
        int i1 = k / 4 % 2;
        float f13 = (float)(l + 0) / 4.0f;
        float f14 = (float)(i1 + 0) / 2.0f;
        float f15 = (float)(l + 1) / 4.0f;
        float f16 = (float)(i1 + 1) / 2.0f;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -9.0f, -100.0f, 9.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 9.0f, -100.0f, 9.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 9.0f, -100.0f, -9.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -9.0f, -100.0f, -9.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        this.mc.func_110434_K().func_110577_a(EARTH_LIGHT_TEXTURES);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -25.0f, -100.0f, 25.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 25.0f, -100.0f, 25.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 25.0f, -100.0f, -25.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -25.0f, -100.0f, -25.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.disableTexture();
        float f10 = 1.0f;
        if (f10 > 0.0f) {
            RenderSystem.color4f((float)f10, (float)f10, (float)f10, (float)f10);
            this.mc.field_71438_f.field_175013_s.func_177359_a();
            this.mc.field_71438_f.field_175014_r.func_227892_a_(0L);
            this.mc.field_71438_f.field_175013_s.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            this.mc.field_71438_f.field_175014_r.func_227895_d_();
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableFog();
        matrixStack.func_227865_b_();
        RenderSystem.disableTexture();
        RenderSystem.color3f((float)0.0f, (float)0.0f, (float)0.0f);
        double d0 = 2.0;
        if (d0 < 0.0) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 12.0, 0.0);
            this.mc.field_71438_f.field_175011_u.func_177359_a();
            this.mc.field_71438_f.field_175014_r.func_227892_a_(0L);
            this.mc.field_71438_f.field_175011_u.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            this.mc.field_71438_f.field_175014_r.func_227895_d_();
            matrixStack.func_227865_b_();
        }
        RenderSystem.color3f((float)(f * 0.2f + 0.04f), (float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.6f + 0.1f));
        RenderSystem.enableTexture();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableFog();
    }

    private void renderMarsSky(MatrixStack matrixStack, float partialTicks) {
        ClientWorld world = this.mc.field_71441_e;
        RenderSystem.disableTexture();
        Vec3d vector3d = world.func_228318_a_(this.mc.field_71460_t.func_215316_n().func_216780_d(), partialTicks);
        float f = (float)vector3d.field_72450_a;
        float f1 = (float)vector3d.field_72448_b;
        float f2 = (float)vector3d.field_72449_c;
        FogRenderer.func_228373_b_();
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableFog();
        RenderSystem.color3f((float)f, (float)f1, (float)f2);
        this.mc.field_71438_f.field_175012_t.func_177359_a();
        this.mc.field_71438_f.field_175014_r.func_227892_a_(0L);
        this.mc.field_71438_f.field_175012_t.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
        VertexBuffer.func_177361_b();
        this.mc.field_71438_f.field_175014_r.func_227895_d_();
        Matrix4f matrix4f1 = matrixStack.func_227866_c_().func_227870_a_();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.func_110434_K().func_110577_a(SKY_TEXTURE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -100.0f, 8.0f, -100.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 100.0f, 8.0f, -100.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 100.0f, 8.0f, 100.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -100.0f, 8.0f, 100.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.disableTexture();
        RenderSystem.disableFog();
        RenderSystem.disableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float[] afloat = world.field_73011_w.func_76560_a(world.func_72929_e(partialTicks), partialTicks);
        if (afloat != null) {
            RenderSystem.disableTexture();
            RenderSystem.shadeModel((int)7425);
            matrixStack.func_227860_a_();
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            float f3 = MathHelper.func_76126_a((float)world.func_72929_e(partialTicks)) < 0.0f ? 180.0f : 0.0f;
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f3));
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
            float f4 = afloat[0];
            float f5 = afloat[1];
            float f6 = afloat[2];
            Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
            bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_227888_a_(matrix4f, 0.0f, 100.0f, 0.0f).func_227885_a_(f4, f5, f6, afloat[3]).func_181675_d();
            for (int j = 0; j <= 16; ++j) {
                float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                float f8 = MathHelper.func_76126_a((float)f7);
                float f9 = MathHelper.func_76134_b((float)f7);
                bufferbuilder.func_227888_a_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).func_227885_a_(afloat[0], afloat[1], afloat[2], 0.0f).func_181675_d();
            }
            bufferbuilder.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
            matrixStack.func_227865_b_();
            RenderSystem.shadeModel((int)7424);
        }
        RenderSystem.enableTexture();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        matrixStack.func_227860_a_();
        float f11 = 1.0f - world.func_72867_j(partialTicks);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(world.func_72929_e(partialTicks) * 60.0f));
        matrix4f1 = matrixStack.func_227866_c_().func_227870_a_();
        float f12 = 30.0f;
        this.mc.func_110434_K().func_110577_a(SUN_TEXTUREST);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -f12, 100.0f, -f12).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, f12, 100.0f, -f12).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, f12, 100.0f, f12).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -f12, 100.0f, f12).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        f12 = 30.0f;
        this.mc.func_110434_K().func_110577_a(PHOBOS);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-130.0f));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(100.0f));
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -3.0f, -100.0f, 3.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 3.0f, -100.0f, 3.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 3.0f, -100.0f, -3.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -3.0f, -100.0f, -3.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        this.mc.func_110434_K().func_110577_a(EARTH);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-130.0f));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(210.0f));
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -1.0f, -100.0f, 1.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 1.0f, -100.0f, 1.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 1.0f, -100.0f, -1.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -1.0f, -100.0f, -1.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        this.mc.func_110434_K().func_110577_a(DEIMOS);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-110.0f));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -4.0f, -100.0f, 4.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 4.0f, -100.0f, 4.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 4.0f, -100.0f, -4.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -4.0f, -100.0f, -4.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.disableTexture();
        float f10 = 1.0f;
        if (f10 > 0.0f) {
            RenderSystem.color4f((float)f10, (float)f10, (float)f10, (float)f10);
            this.mc.field_71438_f.field_175013_s.func_177359_a();
            this.mc.field_71438_f.field_175014_r.func_227892_a_(0L);
            this.mc.field_71438_f.field_175013_s.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            this.mc.field_71438_f.field_175014_r.func_227895_d_();
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableFog();
        matrixStack.func_227865_b_();
        RenderSystem.disableTexture();
        RenderSystem.color3f((float)0.0f, (float)0.0f, (float)0.0f);
        double d0 = 2.0;
        if (d0 < 0.0) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 12.0, 0.0);
            this.mc.field_71438_f.field_175011_u.func_177359_a();
            this.mc.field_71438_f.field_175014_r.func_227892_a_(0L);
            this.mc.field_71438_f.field_175011_u.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            this.mc.field_71438_f.field_175014_r.func_227895_d_();
            matrixStack.func_227865_b_();
        }
        RenderSystem.color3f((float)(f * 0.2f + 0.04f), (float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.6f + 0.1f));
        RenderSystem.enableTexture();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableFog();
    }

    private void renderSkyMercury(MatrixStack matrixStack, float partialTicks) {
        ClientWorld world = this.mc.field_71441_e;
        RenderSystem.disableTexture();
        Vec3d vector3d = world.func_228318_a_(this.mc.field_71460_t.func_215316_n().func_216780_d(), partialTicks);
        float f = (float)vector3d.field_72450_a;
        float f1 = (float)vector3d.field_72448_b;
        float f2 = (float)vector3d.field_72449_c;
        FogRenderer.func_228373_b_();
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableFog();
        RenderSystem.color3f((float)f, (float)f1, (float)f2);
        this.mc.field_71438_f.field_175012_t.func_177359_a();
        this.mc.field_71438_f.field_175014_r.func_227892_a_(0L);
        this.mc.field_71438_f.field_175012_t.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
        VertexBuffer.func_177361_b();
        this.mc.field_71438_f.field_175014_r.func_227895_d_();
        Matrix4f matrix4f1 = matrixStack.func_227866_c_().func_227870_a_();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.func_110434_K().func_110577_a(SKY_TEXTURE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -100.0f, 8.0f, -100.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 100.0f, 8.0f, -100.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 100.0f, 8.0f, 100.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -100.0f, 8.0f, 100.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.disableTexture();
        RenderSystem.disableFog();
        RenderSystem.disableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float[] afloat = world.field_73011_w.func_76560_a(world.func_72929_e(partialTicks), partialTicks);
        if (afloat != null) {
            RenderSystem.disableTexture();
            RenderSystem.shadeModel((int)7425);
            matrixStack.func_227860_a_();
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            float f3 = MathHelper.func_76126_a((float)world.func_72929_e(partialTicks)) < 0.0f ? 180.0f : 0.0f;
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f3));
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
            float f4 = afloat[0];
            float f5 = afloat[1];
            float f6 = afloat[2];
            Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
            bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_227888_a_(matrix4f, 0.0f, 100.0f, 0.0f).func_227885_a_(f4, f5, f6, afloat[3]).func_181675_d();
            for (int j = 0; j <= 16; ++j) {
                float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                float f8 = MathHelper.func_76126_a((float)f7);
                float f9 = MathHelper.func_76134_b((float)f7);
                bufferbuilder.func_227888_a_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).func_227885_a_(afloat[0], afloat[1], afloat[2], 0.0f).func_181675_d();
            }
            bufferbuilder.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
            matrixStack.func_227865_b_();
            RenderSystem.shadeModel((int)7424);
        }
        RenderSystem.enableTexture();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        matrixStack.func_227860_a_();
        float f11 = 1.0f - world.func_72867_j(partialTicks);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(world.func_72929_e(partialTicks) * 60.0f));
        matrix4f1 = matrixStack.func_227866_c_().func_227870_a_();
        float f12 = 30.0f;
        this.mc.func_110434_K().func_110577_a(SUN_TEXTUREST);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -60.0f, 100.0f, -60.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 60.0f, 100.0f, -60.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 60.0f, 100.0f, 60.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -60.0f, 100.0f, 60.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        f12 = 30.0f;
        this.mc.func_110434_K().func_110577_a(SKY_TEXTURE);
        int k = world.func_72853_d();
        int l = k % 4;
        int i1 = k / 4 % 2;
        float f13 = (float)(l + 0) / 4.0f;
        float f14 = (float)(i1 + 0) / 2.0f;
        float f15 = (float)(l + 1) / 4.0f;
        float f16 = (float)(i1 + 1) / 2.0f;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -9.0f, -100.0f, 9.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 9.0f, -100.0f, 9.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 9.0f, -100.0f, -9.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -9.0f, -100.0f, -9.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.disableTexture();
        float f10 = 1.0f;
        if (f10 > 0.0f) {
            RenderSystem.color4f((float)f10, (float)f10, (float)f10, (float)f10);
            this.mc.field_71438_f.field_175013_s.func_177359_a();
            this.mc.field_71438_f.field_175014_r.func_227892_a_(0L);
            this.mc.field_71438_f.field_175013_s.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            this.mc.field_71438_f.field_175014_r.func_227895_d_();
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableFog();
        matrixStack.func_227865_b_();
        RenderSystem.disableTexture();
        RenderSystem.color3f((float)0.0f, (float)0.0f, (float)0.0f);
        double d0 = 2.0;
        if (d0 < 0.0) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 12.0, 0.0);
            this.mc.field_71438_f.field_175011_u.func_177359_a();
            this.mc.field_71438_f.field_175014_r.func_227892_a_(0L);
            this.mc.field_71438_f.field_175011_u.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            this.mc.field_71438_f.field_175014_r.func_227895_d_();
            matrixStack.func_227865_b_();
        }
        RenderSystem.color3f((float)(f * 0.2f + 0.04f), (float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.6f + 0.1f));
        RenderSystem.enableTexture();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableFog();
    }

    private void renderSkyOverworldOrbit(MatrixStack matrixStack, float partialTicks) {
        ClientWorld world = this.mc.field_71441_e;
        RenderSystem.disableTexture();
        Vec3d vector3d = world.func_228318_a_(this.mc.field_71460_t.func_215316_n().func_216780_d(), partialTicks);
        float f = (float)vector3d.field_72450_a;
        float f1 = (float)vector3d.field_72448_b;
        float f2 = (float)vector3d.field_72449_c;
        FogRenderer.func_228373_b_();
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableFog();
        RenderSystem.color3f((float)f, (float)f1, (float)f2);
        this.mc.field_71438_f.field_175012_t.func_177359_a();
        this.mc.field_71438_f.field_175014_r.func_227892_a_(0L);
        this.mc.field_71438_f.field_175012_t.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
        VertexBuffer.func_177361_b();
        this.mc.field_71438_f.field_175014_r.func_227895_d_();
        Matrix4f matrix4f1 = matrixStack.func_227866_c_().func_227870_a_();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.func_110434_K().func_110577_a(SKY_TEXTURE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -100.0f, 8.0f, -100.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 100.0f, 8.0f, -100.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 100.0f, 8.0f, 100.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -100.0f, 8.0f, 100.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.disableTexture();
        RenderSystem.disableFog();
        RenderSystem.disableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float[] afloat = world.field_73011_w.func_76560_a(world.func_72929_e(partialTicks), partialTicks);
        if (afloat != null) {
            RenderSystem.disableTexture();
            RenderSystem.shadeModel((int)7425);
            matrixStack.func_227860_a_();
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            float f3 = MathHelper.func_76126_a((float)world.func_72929_e(partialTicks)) < 0.0f ? 180.0f : 0.0f;
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f3));
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
            float f4 = afloat[0];
            float f5 = afloat[1];
            float f6 = afloat[2];
            Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
            bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_227888_a_(matrix4f, 0.0f, 100.0f, 0.0f).func_227885_a_(f4, f5, f6, afloat[3]).func_181675_d();
            for (int j = 0; j <= 16; ++j) {
                float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                float f8 = MathHelper.func_76126_a((float)f7);
                float f9 = MathHelper.func_76134_b((float)f7);
                bufferbuilder.func_227888_a_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).func_227885_a_(afloat[0], afloat[1], afloat[2], 0.0f).func_181675_d();
            }
            bufferbuilder.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
            matrixStack.func_227865_b_();
            RenderSystem.shadeModel((int)7424);
        }
        RenderSystem.enableTexture();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        matrixStack.func_227860_a_();
        float f11 = 1.0f - world.func_72867_j(partialTicks);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(0.0f));
        matrix4f1 = matrixStack.func_227866_c_().func_227870_a_();
        this.mc.func_110434_K().func_110577_a(EARTH);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float f17 = (float)this.mc.field_71439_g.func_174824_e((float)partialTicks).field_72448_b;
        bufferbuilder.func_227888_a_(matrix4f1, -40.0f, -f17 - 18.0f, 40.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 40.0f, -f17 - 18.0f, 40.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 40.0f, -f17 - 18.0f, -40.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -40.0f, -f17 - 18.0f, -40.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(world.func_72929_e(partialTicks) * 60.0f));
        matrix4f1 = matrixStack.func_227866_c_().func_227870_a_();
        float f12 = 30.0f;
        this.mc.func_110434_K().func_110577_a(SUN_TEXTUREST);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -f12, 100.0f, -f12).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, f12, 100.0f, -f12).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, f12, 100.0f, f12).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -f12, 100.0f, f12).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        f12 = 30.0f;
        this.mc.func_110434_K().func_110577_a(MOON_TEXTUREST);
        int k = world.func_72853_d();
        int l = k % 4;
        int i1 = k / 4 % 2;
        float f13 = (float)(l + 0) / 4.0f;
        float f14 = (float)(i1 + 0) / 2.0f;
        float f15 = (float)(l + 1) / 4.0f;
        float f16 = (float)(i1 + 1) / 2.0f;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -9.0f, -100.0f, 9.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 9.0f, -100.0f, 9.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 9.0f, -100.0f, -9.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -9.0f, -100.0f, -9.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.disableTexture();
        float f10 = 1.0f;
        if (f10 > 0.0f) {
            RenderSystem.color4f((float)f10, (float)f10, (float)f10, (float)f10);
            this.mc.field_71438_f.field_175013_s.func_177359_a();
            this.mc.field_71438_f.field_175014_r.func_227892_a_(0L);
            this.mc.field_71438_f.field_175013_s.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            this.mc.field_71438_f.field_175014_r.func_227895_d_();
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableFog();
        matrixStack.func_227865_b_();
        RenderSystem.disableTexture();
        RenderSystem.color3f((float)0.0f, (float)0.0f, (float)0.0f);
        double d0 = 2.0;
        if (d0 < 0.0) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 12.0, 0.0);
            this.mc.field_71438_f.field_175011_u.func_177359_a();
            this.mc.field_71438_f.field_175014_r.func_227892_a_(0L);
            this.mc.field_71438_f.field_175011_u.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            this.mc.field_71438_f.field_175014_r.func_227895_d_();
            matrixStack.func_227865_b_();
        }
        RenderSystem.color3f((float)(f * 0.2f + 0.04f), (float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.6f + 0.1f));
        RenderSystem.enableTexture();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableFog();
    }

    private void renderSkyMoonOrbit(MatrixStack matrixStack, float partialTicks) {
        ClientWorld world = this.mc.field_71441_e;
        RenderSystem.disableTexture();
        Vec3d vector3d = world.func_228318_a_(this.mc.field_71460_t.func_215316_n().func_216780_d(), partialTicks);
        float f = (float)vector3d.field_72450_a;
        float f1 = (float)vector3d.field_72448_b;
        float f2 = (float)vector3d.field_72449_c;
        FogRenderer.func_228373_b_();
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableFog();
        RenderSystem.color3f((float)f, (float)f1, (float)f2);
        this.mc.field_71438_f.field_175012_t.func_177359_a();
        this.mc.field_71438_f.field_175014_r.func_227892_a_(0L);
        this.mc.field_71438_f.field_175012_t.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
        VertexBuffer.func_177361_b();
        this.mc.field_71438_f.field_175014_r.func_227895_d_();
        Matrix4f matrix4f1 = matrixStack.func_227866_c_().func_227870_a_();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.func_110434_K().func_110577_a(SKY_TEXTURE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -100.0f, 8.0f, -100.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 100.0f, 8.0f, -100.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 100.0f, 8.0f, 100.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -100.0f, 8.0f, 100.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.disableTexture();
        RenderSystem.disableFog();
        RenderSystem.disableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float[] afloat = world.field_73011_w.func_76560_a(world.func_72929_e(partialTicks), partialTicks);
        if (afloat != null) {
            RenderSystem.disableTexture();
            RenderSystem.shadeModel((int)7425);
            matrixStack.func_227860_a_();
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            float f3 = MathHelper.func_76126_a((float)world.func_72929_e(partialTicks)) < 0.0f ? 180.0f : 0.0f;
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f3));
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
            float f4 = afloat[0];
            float f5 = afloat[1];
            float f6 = afloat[2];
            Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
            bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_227888_a_(matrix4f, 0.0f, 100.0f, 0.0f).func_227885_a_(f4, f5, f6, afloat[3]).func_181675_d();
            for (int j = 0; j <= 16; ++j) {
                float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                float f8 = MathHelper.func_76126_a((float)f7);
                float f9 = MathHelper.func_76134_b((float)f7);
                bufferbuilder.func_227888_a_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).func_227885_a_(afloat[0], afloat[1], afloat[2], 0.0f).func_181675_d();
            }
            bufferbuilder.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
            matrixStack.func_227865_b_();
            RenderSystem.shadeModel((int)7424);
        }
        RenderSystem.enableTexture();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        matrixStack.func_227860_a_();
        float f11 = 1.0f - world.func_72867_j(partialTicks);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(0.0f));
        matrix4f1 = matrixStack.func_227866_c_().func_227870_a_();
        this.mc.func_110434_K().func_110577_a(MOON_TEXTUREST);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float f17 = (float)this.mc.field_71439_g.func_174824_e((float)partialTicks).field_72448_b;
        bufferbuilder.func_227888_a_(matrix4f1, -25.0f, -f17 - 18.0f, 25.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 25.0f, -f17 - 18.0f, 25.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 25.0f, -f17 - 18.0f, -25.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -25.0f, -f17 - 18.0f, -25.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(world.func_72929_e(partialTicks) * 60.0f));
        matrix4f1 = matrixStack.func_227866_c_().func_227870_a_();
        float f12 = 30.0f;
        this.mc.func_110434_K().func_110577_a(SUN_TEXTUREST);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -f12, 100.0f, -f12).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, f12, 100.0f, -f12).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, f12, 100.0f, f12).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -f12, 100.0f, f12).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        f12 = 30.0f;
        this.mc.func_110434_K().func_110577_a(SKY_TEXTURE);
        int k = world.func_72853_d();
        int l = k % 4;
        int i1 = k / 4 % 2;
        float f13 = (float)(l + 0) / 4.0f;
        float f14 = (float)(i1 + 0) / 2.0f;
        float f15 = (float)(l + 1) / 4.0f;
        float f16 = (float)(i1 + 1) / 2.0f;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -9.0f, -100.0f, 9.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 9.0f, -100.0f, 9.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 9.0f, -100.0f, -9.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -9.0f, -100.0f, -9.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.disableTexture();
        float f10 = 1.0f;
        if (f10 > 0.0f) {
            RenderSystem.color4f((float)f10, (float)f10, (float)f10, (float)f10);
            this.mc.field_71438_f.field_175013_s.func_177359_a();
            this.mc.field_71438_f.field_175014_r.func_227892_a_(0L);
            this.mc.field_71438_f.field_175013_s.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            this.mc.field_71438_f.field_175014_r.func_227895_d_();
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableFog();
        matrixStack.func_227865_b_();
        RenderSystem.disableTexture();
        RenderSystem.color3f((float)0.0f, (float)0.0f, (float)0.0f);
        double d0 = 2.0;
        if (d0 < 0.0) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 12.0, 0.0);
            this.mc.field_71438_f.field_175011_u.func_177359_a();
            this.mc.field_71438_f.field_175014_r.func_227892_a_(0L);
            this.mc.field_71438_f.field_175011_u.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            this.mc.field_71438_f.field_175014_r.func_227895_d_();
            matrixStack.func_227865_b_();
        }
        RenderSystem.color3f((float)(f * 0.2f + 0.04f), (float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.6f + 0.1f));
        RenderSystem.enableTexture();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableFog();
    }

    private void renderSkyMarsOrbit(MatrixStack matrixStack, float partialTicks) {
        ClientWorld world = this.mc.field_71441_e;
        RenderSystem.disableTexture();
        Vec3d vector3d = world.func_228318_a_(this.mc.field_71460_t.func_215316_n().func_216780_d(), partialTicks);
        float f = (float)vector3d.field_72450_a;
        float f1 = (float)vector3d.field_72448_b;
        float f2 = (float)vector3d.field_72449_c;
        FogRenderer.func_228373_b_();
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableFog();
        RenderSystem.color3f((float)f, (float)f1, (float)f2);
        this.mc.field_71438_f.field_175012_t.func_177359_a();
        this.mc.field_71438_f.field_175014_r.func_227892_a_(0L);
        this.mc.field_71438_f.field_175012_t.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
        VertexBuffer.func_177361_b();
        this.mc.field_71438_f.field_175014_r.func_227895_d_();
        Matrix4f matrix4f1 = matrixStack.func_227866_c_().func_227870_a_();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.func_110434_K().func_110577_a(SKY_TEXTURE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -100.0f, 8.0f, -100.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 100.0f, 8.0f, -100.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 100.0f, 8.0f, 100.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -100.0f, 8.0f, 100.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.disableTexture();
        RenderSystem.disableFog();
        RenderSystem.disableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float[] afloat = world.field_73011_w.func_76560_a(world.func_72929_e(partialTicks), partialTicks);
        if (afloat != null) {
            RenderSystem.disableTexture();
            RenderSystem.shadeModel((int)7425);
            matrixStack.func_227860_a_();
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            float f3 = MathHelper.func_76126_a((float)world.func_72929_e(partialTicks)) < 0.0f ? 180.0f : 0.0f;
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f3));
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
            float f4 = afloat[0];
            float f5 = afloat[1];
            float f6 = afloat[2];
            Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
            bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_227888_a_(matrix4f, 0.0f, 100.0f, 0.0f).func_227885_a_(f4, f5, f6, afloat[3]).func_181675_d();
            for (int j = 0; j <= 16; ++j) {
                float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                float f8 = MathHelper.func_76126_a((float)f7);
                float f9 = MathHelper.func_76134_b((float)f7);
                bufferbuilder.func_227888_a_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).func_227885_a_(afloat[0], afloat[1], afloat[2], 0.0f).func_181675_d();
            }
            bufferbuilder.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
            matrixStack.func_227865_b_();
            RenderSystem.shadeModel((int)7424);
        }
        RenderSystem.enableTexture();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        matrixStack.func_227860_a_();
        float f11 = 1.0f - world.func_72867_j(partialTicks);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(0.0f));
        matrix4f1 = matrixStack.func_227866_c_().func_227870_a_();
        this.mc.func_110434_K().func_110577_a(MARS);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float f17 = (float)this.mc.field_71439_g.func_174824_e((float)partialTicks).field_72448_b;
        bufferbuilder.func_227888_a_(matrix4f1, -45.0f, -f17 - 18.0f, 45.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 45.0f, -f17 - 18.0f, 45.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 45.0f, -f17 - 18.0f, -45.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -45.0f, -f17 - 18.0f, -45.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(world.func_72929_e(partialTicks) * 60.0f));
        matrix4f1 = matrixStack.func_227866_c_().func_227870_a_();
        float f12 = 30.0f;
        this.mc.func_110434_K().func_110577_a(SUN_TEXTUREST);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -f12, 100.0f, -f12).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, f12, 100.0f, -f12).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, f12, 100.0f, f12).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -f12, 100.0f, f12).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        f12 = 30.0f;
        this.mc.func_110434_K().func_110577_a(SKY_TEXTURE);
        int k = world.func_72853_d();
        int l = k % 4;
        int i1 = k / 4 % 2;
        float f13 = (float)(l + 0) / 4.0f;
        float f14 = (float)(i1 + 0) / 2.0f;
        float f15 = (float)(l + 1) / 4.0f;
        float f16 = (float)(i1 + 1) / 2.0f;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -9.0f, -100.0f, 9.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 9.0f, -100.0f, 9.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 9.0f, -100.0f, -9.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -9.0f, -100.0f, -9.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.disableTexture();
        float f10 = 1.0f;
        if (f10 > 0.0f) {
            RenderSystem.color4f((float)f10, (float)f10, (float)f10, (float)f10);
            this.mc.field_71438_f.field_175013_s.func_177359_a();
            this.mc.field_71438_f.field_175014_r.func_227892_a_(0L);
            this.mc.field_71438_f.field_175013_s.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            this.mc.field_71438_f.field_175014_r.func_227895_d_();
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableFog();
        matrixStack.func_227865_b_();
        RenderSystem.disableTexture();
        RenderSystem.color3f((float)0.0f, (float)0.0f, (float)0.0f);
        double d0 = 2.0;
        if (d0 < 0.0) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 12.0, 0.0);
            this.mc.field_71438_f.field_175011_u.func_177359_a();
            this.mc.field_71438_f.field_175014_r.func_227892_a_(0L);
            this.mc.field_71438_f.field_175011_u.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            this.mc.field_71438_f.field_175014_r.func_227895_d_();
            matrixStack.func_227865_b_();
        }
        RenderSystem.color3f((float)(f * 0.2f + 0.04f), (float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.6f + 0.1f));
        RenderSystem.enableTexture();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableFog();
    }

    private void renderSkyMercuryOrbit(MatrixStack matrixStack, float partialTicks) {
        ClientWorld world = this.mc.field_71441_e;
        RenderSystem.disableTexture();
        Vec3d vector3d = world.func_228318_a_(this.mc.field_71460_t.func_215316_n().func_216780_d(), partialTicks);
        float f = (float)vector3d.field_72450_a;
        float f1 = (float)vector3d.field_72448_b;
        float f2 = (float)vector3d.field_72449_c;
        FogRenderer.func_228373_b_();
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableFog();
        RenderSystem.color3f((float)f, (float)f1, (float)f2);
        this.mc.field_71438_f.field_175012_t.func_177359_a();
        this.mc.field_71438_f.field_175014_r.func_227892_a_(0L);
        this.mc.field_71438_f.field_175012_t.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
        VertexBuffer.func_177361_b();
        this.mc.field_71438_f.field_175014_r.func_227895_d_();
        Matrix4f matrix4f1 = matrixStack.func_227866_c_().func_227870_a_();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.func_110434_K().func_110577_a(SKY_TEXTURE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -100.0f, 8.0f, -100.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 100.0f, 8.0f, -100.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 100.0f, 8.0f, 100.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -100.0f, 8.0f, 100.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.disableTexture();
        RenderSystem.disableFog();
        RenderSystem.disableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float[] afloat = world.field_73011_w.func_76560_a(world.func_72929_e(partialTicks), partialTicks);
        if (afloat != null) {
            RenderSystem.disableTexture();
            RenderSystem.shadeModel((int)7425);
            matrixStack.func_227860_a_();
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            float f3 = MathHelper.func_76126_a((float)world.func_72929_e(partialTicks)) < 0.0f ? 180.0f : 0.0f;
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f3));
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
            float f4 = afloat[0];
            float f5 = afloat[1];
            float f6 = afloat[2];
            Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
            bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_227888_a_(matrix4f, 0.0f, 100.0f, 0.0f).func_227885_a_(f4, f5, f6, afloat[3]).func_181675_d();
            for (int j = 0; j <= 16; ++j) {
                float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                float f8 = MathHelper.func_76126_a((float)f7);
                float f9 = MathHelper.func_76134_b((float)f7);
                bufferbuilder.func_227888_a_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).func_227885_a_(afloat[0], afloat[1], afloat[2], 0.0f).func_181675_d();
            }
            bufferbuilder.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
            matrixStack.func_227865_b_();
            RenderSystem.shadeModel((int)7424);
        }
        RenderSystem.enableTexture();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        matrixStack.func_227860_a_();
        float f11 = 1.0f - world.func_72867_j(partialTicks);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(0.0f));
        matrix4f1 = matrixStack.func_227866_c_().func_227870_a_();
        this.mc.func_110434_K().func_110577_a(PLUTO);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float f17 = (float)this.mc.field_71439_g.func_174824_e((float)partialTicks).field_72448_b;
        bufferbuilder.func_227888_a_(matrix4f1, -45.0f, -f17 - 18.0f, 45.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 45.0f, -f17 - 18.0f, 45.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 45.0f, -f17 - 18.0f, -45.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -45.0f, -f17 - 18.0f, -45.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(world.func_72929_e(partialTicks) * 60.0f));
        matrix4f1 = matrixStack.func_227866_c_().func_227870_a_();
        float f12 = 45.0f;
        this.mc.func_110434_K().func_110577_a(SUN_TEXTUREST);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -f12, 100.0f, -f12).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, f12, 100.0f, -f12).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, f12, 100.0f, f12).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -f12, 100.0f, f12).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        f12 = 30.0f;
        this.mc.func_110434_K().func_110577_a(SKY_TEXTURE);
        int k = world.func_72853_d();
        int l = k % 4;
        int i1 = k / 4 % 2;
        float f13 = (float)(l + 0) / 4.0f;
        float f14 = (float)(i1 + 0) / 2.0f;
        float f15 = (float)(l + 1) / 4.0f;
        float f16 = (float)(i1 + 1) / 2.0f;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix4f1, -9.0f, -100.0f, 9.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 9.0f, -100.0f, 9.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, 9.0f, -100.0f, -9.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix4f1, -9.0f, -100.0f, -9.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
        RenderSystem.disableTexture();
        float f10 = 1.0f;
        if (f10 > 0.0f) {
            RenderSystem.color4f((float)f10, (float)f10, (float)f10, (float)f10);
            this.mc.field_71438_f.field_175013_s.func_177359_a();
            this.mc.field_71438_f.field_175014_r.func_227892_a_(0L);
            this.mc.field_71438_f.field_175013_s.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            this.mc.field_71438_f.field_175014_r.func_227895_d_();
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableFog();
        matrixStack.func_227865_b_();
        RenderSystem.disableTexture();
        RenderSystem.color3f((float)0.0f, (float)0.0f, (float)0.0f);
        double d0 = 2.0;
        if (d0 < 0.0) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 12.0, 0.0);
            this.mc.field_71438_f.field_175011_u.func_177359_a();
            this.mc.field_71438_f.field_175014_r.func_227892_a_(0L);
            this.mc.field_71438_f.field_175011_u.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            this.mc.field_71438_f.field_175014_r.func_227895_d_();
            matrixStack.func_227865_b_();
        }
        RenderSystem.color3f((float)(f * 0.2f + 0.04f), (float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.6f + 0.1f));
        RenderSystem.enableTexture();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableFog();
    }
}

