/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.mrscauthd.boss_tools.BossToolsModElements;
import net.mrscauthd.boss_tools.entity.AlienEntity;

@BossToolsModElements.ModElement.Tag
public class TextureSync
extends BossToolsModElements.ModElement {
    public TextureSync(BossToolsModElements instance) {
        super(instance, 754);
        MinecraftForge.EVENT_BUS.register((Object)this);
        NetworkLoader.registerMessages();
    }

    public static void executeProcedure(Map<String, Object> dependencies) {
        Entity entity = (Entity)dependencies.get("entity");
        if (entity instanceof AlienEntity && !entity.field_70170_p.field_72995_K) {
            NetworkLoader.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new TextureSpinPacket(entity.func_145782_y(), entity.getPersistentData().func_74769_h("texture")));
        }
    }

    @SubscribeEvent
    public void onEntity(EntityEvent event) {
        if (event != null && event.getEntity() != null) {
            Entity entity = event.getEntity();
            double i = entity.func_226277_ct_();
            double j = entity.func_226278_cu_();
            double k = entity.func_226281_cx_();
            World world = entity.field_70170_p;
            HashMap<String, Object> dependencies = new HashMap<String, Object>();
            dependencies.put("x", i);
            dependencies.put("y", j);
            dependencies.put("z", k);
            dependencies.put("world", world);
            dependencies.put("entity", entity);
            dependencies.put("event", event);
            TextureSync.executeProcedure(dependencies);
        }
    }

    private static class TextureSpinPacket {
        private double texture;
        private int entityId;

        public TextureSpinPacket(int entityId, double texture) {
            this.texture = texture;
            this.entityId = entityId;
        }

        public static void encode(TextureSpinPacket msg, PacketBuffer buf) {
            buf.writeInt(msg.entityId);
            buf.writeDouble(msg.texture);
        }

        public static TextureSpinPacket decode(PacketBuffer buf) {
            return new TextureSpinPacket(buf.readInt(), buf.readDouble());
        }

        public static void handle(TextureSpinPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(msg.entityId);
                if (entity instanceof LivingEntity) {
                    ((LivingEntity)entity).getPersistentData().func_74780_a("texture", msg.texture);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    private static class NetworkLoader {
        public static SimpleChannel INSTANCE;
        private static int id;

        private NetworkLoader() {
        }

        public static int nextID() {
            return id++;
        }

        public static void registerMessages() {
            INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("boss_tools", "texture_link"), () -> "1.0", s -> true, s -> true);
            INSTANCE.registerMessage(NetworkLoader.nextID(), TextureSpinPacket.class, TextureSpinPacket::encode, TextureSpinPacket::decode, TextureSpinPacket::handle);
        }

        static {
            id = 1;
        }
    }
}

