/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.entity;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.INPC;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.IMerchant;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.village.GossipManager;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.mrscauthd.boss_tools.AlienJobs;
import net.mrscauthd.boss_tools.BossToolsModVariables;
import net.mrscauthd.boss_tools.FollowGoal;
import net.mrscauthd.boss_tools.TradeGoal;
import net.mrscauthd.boss_tools.entity.AlienTrade;

public class AlienEntity
extends AgeableEntity
implements IMerchant,
INPC {
    @Nullable
    private PlayerEntity customer;
    private Set<UUID> tradedCustomers = new HashSet<UUID>();
    @Nullable
    private MerchantOffers offers;
    private final GossipManager gossip = new GossipManager();
    private static final DataParameter<Integer> ALIEN_TYPE = EntityDataManager.func_187226_a(AlienEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151166_bC});
    public AlienJobs job;

    public AlienEntity(EntityType<? extends AgeableEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public int getJobId() {
        return (Integer)this.field_70180_af.func_187225_a(ALIEN_TYPE);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(2, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.1, TEMPTATION_ITEMS, false));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new TradeGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new FollowGoal(this, 1.1, false));
    }

    protected void resetCustomer() {
        this.func_70932_a_(null);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.resetCustomer();
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187910_gj;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187912_gl;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    public void func_70932_a_(@Nullable PlayerEntity player) {
        this.customer = player;
    }

    @Nullable
    public PlayerEntity func_70931_l_() {
        return this.customer;
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        List<Object> x = new ArrayList();
        x = Arrays.asList(AlienJobs.values());
        int max = x.size() - 1;
        int min = 0;
        this.job = (AlienJobs)((Object)x.get(new Random().nextInt(max + 1 - min) + min));
        this.field_70180_af.func_187227_b(ALIEN_TYPE, (Object)this.job.id);
        this.getPersistentData().func_74780_a("texture", (double)this.job.id);
        return spawnDataIn;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ALIEN_TYPE, (Object)0);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        for (MerchantOffer merchantoffer : this.func_213706_dY()) {
            merchantoffer.func_222203_h();
        }
        for (MerchantOffer merchantoffer : this.func_213706_dY()) {
            int max = 2;
            int min = 0;
            merchantoffer.func_222207_a((int)Math.floor(amount * (float)new Random().nextInt(max + 1 - min) + (float)min));
        }
        return super.func_70097_a(source, amount);
    }

    public MerchantOffers func_213706_dY() {
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            int max = 7;
            int min = 2;
            for (int i = 0; i < new Random().nextInt(max + 1 - min) + min; ++i) {
                this.populateTradeData(i);
            }
        }
        return this.offers;
    }

    public void func_213703_a(@Nullable MerchantOffers offers) {
    }

    public void func_213704_a(MerchantOffer offer) {
        offer.func_222219_j();
        if (this.customer != null) {
            this.tradedCustomers.add(this.customer.func_110124_au());
        }
    }

    public void func_110297_a_(ItemStack stack) {
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public int func_213708_dV() {
        return 0;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public void func_213702_q(int xpIn) {
    }

    public boolean func_213705_dZ() {
        return false;
    }

    public boolean isPreviousCustomer(PlayerEntity player) {
        return this.tradedCustomers.contains(player.func_110124_au());
    }

    public SoundEvent func_213714_ea() {
        return null;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.job == null) {
            List<Object> x = new ArrayList();
            x = Arrays.asList(AlienJobs.values());
            int max = x.size() - 1;
            int min = 0;
            this.job = (AlienJobs)((Object)x.get(new Random().nextInt(max + 1 - min) + min));
            this.field_70180_af.func_187227_b(ALIEN_TYPE, (Object)this.job.id);
            this.getPersistentData().func_74780_a("texture", (double)this.job.id);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Offers", 10)) {
            this.offers = new MerchantOffers(compound.func_74775_l("Offers"));
        }
        if (compound.func_74764_b("JobId")) {
            int x = compound.func_74762_e("JobId");
            List<Object> y = new ArrayList();
            y = Arrays.asList(AlienJobs.values());
            this.job = (AlienJobs)((Object)y.get(x));
            this.getPersistentData().func_74780_a("texture", (double)this.job.id);
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        MerchantOffers merchantoffers = this.func_213706_dY();
        compound.func_218657_a("Offers", (INBT)merchantoffers.func_222199_a());
        compound.func_74768_a("JobId", (int)this.getPersistentData().func_74769_h("texture"));
    }

    protected void addTrades(MerchantOffers givenMerchantOffers, VillagerTrades.ITrade[] newTrades, int maxNumbers) {
        HashSet set = Sets.newHashSet();
        if (newTrades.length > maxNumbers) {
            while (set.size() < maxNumbers) {
                set.add(this.field_70146_Z.nextInt(newTrades.length));
            }
        } else {
            for (int i = 0; i < newTrades.length; ++i) {
                set.add(i);
            }
        }
        for (Integer integer : set) {
            VillagerTrades.ITrade villagertrades$itrade = newTrades[integer];
            MerchantOffer merchantoffer = villagertrades$itrade.func_221182_a((Entity)this, this.field_70146_Z);
            if (merchantoffer == null) continue;
            givenMerchantOffers.add((Object)merchantoffer);
        }
    }

    protected void populateTradeData(int i) {
        VillagerTrades.ITrade[] avillagertrades$itrade;
        Int2ObjectMap<VillagerTrades.ITrade[]> int2objectmap = AlienTrade.TRADES.get((Object)this.job);
        if (int2objectmap != null && !int2objectmap.isEmpty() && (avillagertrades$itrade = (VillagerTrades.ITrade[])int2objectmap.get(i)) != null) {
            MerchantOffers merchantoffers = this.func_213706_dY();
            int max = 18;
            int min = 3;
            this.addTrades(this.func_213706_dY(), avillagertrades$itrade, new Random().nextInt(max + 1 - min) + min);
        }
    }

    public boolean hasCustomer() {
        return this.customer != null;
    }

    public ActionResultType func_230254_b_(PlayerEntity sourceentity, Hand hand) {
        ItemStack itemstack = sourceentity.func_184586_b(hand);
        if (!this.hasCustomer()) {
            if (hand == Hand.MAIN_HAND) {
                if (!this.field_70170_p.field_72995_K) {
                    // empty if block
                }
                sourceentity.func_195066_a(Stats.field_188074_H);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.displayMerchantGui(sourceentity);
            }
        }
        return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
    }

    private void displayMerchantGui(PlayerEntity player) {
        this.recalculateSpecialPricesFor(player);
        this.func_70932_a_(player);
        this.func_213707_a(player, (ITextComponent)new TranslationTextComponent(this.func_145748_c_().getString() + " - " + this.job.getJobDisplayname().getString()), 1);
    }

    private void recalculateSpecialPricesFor(PlayerEntity playerIn) {
        int i = this.getPlayerReputation(playerIn);
        if (i != 0) {
            for (MerchantOffer merchantoffer : this.func_213706_dY()) {
                merchantoffer.func_222207_a(-MathHelper.func_76141_d((float)((float)i * merchantoffer.func_222211_m())));
            }
        }
        if (playerIn.func_70644_a(Effects.field_220310_F)) {
            EffectInstance effectinstance = playerIn.func_70660_b(Effects.field_220310_F);
            int k = effectinstance.func_76458_c();
            for (MerchantOffer merchantoffer1 : this.func_213706_dY()) {
                double d0 = 0.3 + 0.0625 * (double)k;
                int j = (int)Math.floor(d0 * (double)merchantoffer1.func_222218_a().func_190916_E());
                merchantoffer1.func_222207_a(-Math.max(j, 1));
            }
        }
    }

    public int getPlayerReputation(PlayerEntity player) {
        return this.gossip.func_220921_a(player.func_110124_au(), gossipType -> true);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return null;
    }

    public ResourceLocation getTexture() {
        List<Object> y = new ArrayList();
        y = Arrays.asList(AlienJobs.values());
        return ((AlienJobs)((Object)y.get((int)((int)this.getPersistentData().func_74769_h((String)"texture"))))).TEXTURE;
    }

    public void func_70030_z() {
        super.func_70030_z();
        double x = this.func_226277_ct_();
        double y = this.func_226278_cu_();
        double z = this.func_226281_cx_();
        AlienEntity entity = this;
        if (!BossToolsModVariables.AlienSpawing && !((Entity)entity).field_70170_p.func_201670_d()) {
            entity.func_70106_y();
        }
    }
}

