/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.entity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.villager.IVillagerDataHolder;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.DyeableArmorItem;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.SuspiciousStewItem;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.mrscauthd.boss_tools.AlienJobs;

public class AlienTrade {
    public static Map<AlienJobs, Int2ObjectMap<VillagerTrades.ITrade[]>> TRADES = (Map)Util.func_200696_a((Object)Maps.newHashMap(), p_221237_0_ -> {
        p_221237_0_.put(AlienJobs.JOB1, AlienTrade.gatAsIntMap((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151015_O, 20, 16, 2), new EmeraldForItemsTrade((IItemProvider)Items.field_151174_bG, 26, 16, 2), new EmeraldForItemsTrade((IItemProvider)Items.field_151172_bF, 22, 16, 2), new EmeraldForItemsTrade((IItemProvider)Items.field_185164_cV, 15, 16, 2), new ItemsForEmeraldsTrade(Items.field_151025_P, 1, 6, 16, 1)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Blocks.field_150423_aK, 6, 12, 10), new ItemsForEmeraldsTrade(Items.field_151158_bO, 1, 4, 5), new ItemsForEmeraldsTrade(Items.field_151034_e, 1, 4, 16, 5)}, (Object)3, (Object)new VillagerTrades.ITrade[]{new ItemsForEmeraldsTrade(Items.field_151106_aX, 3, 18, 10), new EmeraldForItemsTrade((IItemProvider)Blocks.field_150440_ba, 4, 12, 20)}, (Object)4, (Object)new VillagerTrades.ITrade[]{new ItemsForEmeraldsTrade(Blocks.field_150414_aQ, 1, 1, 12, 15), new SuspiciousStewForEmeraldTrade(Effects.field_76439_r, 100, 15), new SuspiciousStewForEmeraldTrade(Effects.field_76430_j, 160, 15), new SuspiciousStewForEmeraldTrade(Effects.field_76437_t, 140, 15), new SuspiciousStewForEmeraldTrade(Effects.field_76440_q, 120, 15), new SuspiciousStewForEmeraldTrade(Effects.field_76436_u, 280, 15), new SuspiciousStewForEmeraldTrade(Effects.field_76443_y, 7, 15)}, (Object)5, (Object)new VillagerTrades.ITrade[]{new ItemsForEmeraldsTrade(Items.field_151150_bK, 3, 3, 30), new ItemsForEmeraldsTrade(Items.field_151060_bw, 4, 3, 30)})));
        p_221237_0_.put(AlienJobs.JOB2, AlienTrade.gatAsIntMap((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151007_F, 20, 16, 2), new EmeraldForItemsTrade((IItemProvider)Items.field_151044_h, 10, 16, 2), new ItemsForEmeraldsAndItemsTrade((IItemProvider)Items.field_196086_aW, 6, Items.field_196102_ba, 6, 16, 1), new ItemsForEmeraldsTrade(Items.field_203797_aN, 3, 1, 16, 1)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_196086_aW, 15, 16, 10), new ItemsForEmeraldsAndItemsTrade((IItemProvider)Items.field_196087_aX, 6, Items.field_196104_bb, 6, 16, 5), new ItemsForEmeraldsTrade(Items.field_222113_pS, 2, 1, 5)}, (Object)3, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_196087_aX, 13, 16, 20), new EnchantedItemForEmeraldsTrade(Items.field_151112_aM, 3, 3, 10, 0.2f)}, (Object)4, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_196088_aY, 6, 12, 30)}, (Object)5, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_196089_aZ, 4, 12, 30), new EmeraldForVillageTypeItemTrade(1, 12, 30, (Map<VillagerType, Item>)ImmutableMap.builder().put((Object)VillagerType.field_221175_c, (Object)Items.field_151124_az).put((Object)VillagerType.field_221179_g, (Object)Items.field_185150_aH).put((Object)VillagerType.field_221177_e, (Object)Items.field_185150_aH).put((Object)VillagerType.field_221173_a, (Object)Items.field_185152_aJ).put((Object)VillagerType.field_221174_b, (Object)Items.field_185152_aJ).put((Object)VillagerType.field_221176_d, (Object)Items.field_185153_aK).put((Object)VillagerType.field_221178_f, (Object)Items.field_185154_aL).build())})));
        p_221237_0_.put(AlienJobs.JOB3, AlienTrade.gatAsIntMap((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Blocks.field_196556_aL, 18, 16, 2), new EmeraldForItemsTrade((IItemProvider)Blocks.field_196568_aX, 18, 16, 2), new EmeraldForItemsTrade((IItemProvider)Blocks.field_196602_ba, 18, 16, 2), new EmeraldForItemsTrade((IItemProvider)Blocks.field_196563_aS, 18, 16, 2), new ItemsForEmeraldsTrade(Items.field_151097_aZ, 2, 1, 1)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_222069_lA, 12, 16, 10), new EmeraldForItemsTrade((IItemProvider)Items.field_196120_bj, 12, 16, 10), new EmeraldForItemsTrade((IItemProvider)Items.field_222086_lz, 12, 16, 10), new EmeraldForItemsTrade((IItemProvider)Items.field_196112_bf, 12, 16, 10), new EmeraldForItemsTrade((IItemProvider)Items.field_196116_bh, 12, 16, 10), new ItemsForEmeraldsTrade(Blocks.field_196556_aL, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196557_aM, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196558_aN, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196559_aO, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196560_aP, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196561_aQ, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196562_aR, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196563_aS, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196564_aT, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196565_aU, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196566_aV, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196567_aW, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196568_aX, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196569_aY, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196570_aZ, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196602_ba, 1, 1, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196724_fH, 1, 4, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196725_fI, 1, 4, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196727_fJ, 1, 4, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196729_fK, 1, 4, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196731_fL, 1, 4, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196733_fM, 1, 4, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196735_fN, 1, 4, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196737_fO, 1, 4, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196739_fP, 1, 4, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196741_fQ, 1, 4, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196743_fR, 1, 4, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196745_fS, 1, 4, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196747_fT, 1, 4, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196749_fU, 1, 4, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196751_fV, 1, 4, 16, 5), new ItemsForEmeraldsTrade(Blocks.field_196753_fW, 1, 4, 16, 5)}, (Object)3, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_222081_ls, 12, 16, 20), new EmeraldForItemsTrade((IItemProvider)Items.field_196122_bk, 12, 16, 20), new EmeraldForItemsTrade((IItemProvider)Items.field_196108_bd, 12, 16, 20), new EmeraldForItemsTrade((IItemProvider)Items.field_222078_li, 12, 16, 20), new EmeraldForItemsTrade((IItemProvider)Items.field_196118_bi, 12, 16, 20), new ItemsForEmeraldsTrade(Blocks.field_196587_am, 3, 1, 12, 10), new ItemsForEmeraldsTrade(Blocks.field_196592_aq, 3, 1, 12, 10), new ItemsForEmeraldsTrade(Blocks.field_196550_aA, 3, 1, 12, 10), new ItemsForEmeraldsTrade(Blocks.field_196551_aB, 3, 1, 12, 10), new ItemsForEmeraldsTrade(Blocks.field_196599_ax, 3, 1, 12, 10), new ItemsForEmeraldsTrade(Blocks.field_196600_ay, 3, 1, 12, 10), new ItemsForEmeraldsTrade(Blocks.field_196597_av, 3, 1, 12, 10), new ItemsForEmeraldsTrade(Blocks.field_196595_at, 3, 1, 12, 10), new ItemsForEmeraldsTrade(Blocks.field_196601_az, 3, 1, 12, 10), new ItemsForEmeraldsTrade(Blocks.field_196590_ap, 3, 1, 12, 10), new ItemsForEmeraldsTrade(Blocks.field_196596_au, 3, 1, 12, 10), new ItemsForEmeraldsTrade(Blocks.field_196593_ar, 3, 1, 12, 10), new ItemsForEmeraldsTrade(Blocks.field_196589_ao, 3, 1, 12, 10), new ItemsForEmeraldsTrade(Blocks.field_196588_an, 3, 1, 12, 10), new ItemsForEmeraldsTrade(Blocks.field_196594_as, 3, 1, 12, 10), new ItemsForEmeraldsTrade(Blocks.field_196598_aw, 3, 1, 12, 10)}, (Object)4, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_222085_ly, 12, 16, 30), new EmeraldForItemsTrade((IItemProvider)Items.field_196126_bm, 12, 16, 30), new EmeraldForItemsTrade((IItemProvider)Items.field_222083_lx, 12, 16, 30), new EmeraldForItemsTrade((IItemProvider)Items.field_222079_lj, 12, 16, 30), new EmeraldForItemsTrade((IItemProvider)Items.field_196110_be, 12, 16, 30), new EmeraldForItemsTrade((IItemProvider)Items.field_196124_bl, 12, 16, 30), new ItemsForEmeraldsTrade(Items.field_196191_eg, 3, 1, 12, 15), new ItemsForEmeraldsTrade(Items.field_196202_er, 3, 1, 12, 15), new ItemsForEmeraldsTrade(Items.field_196194_ej, 3, 1, 12, 15), new ItemsForEmeraldsTrade(Items.field_196205_eu, 3, 1, 12, 15), new ItemsForEmeraldsTrade(Items.field_196197_em, 3, 1, 12, 15), new ItemsForEmeraldsTrade(Items.field_196204_et, 3, 1, 12, 15), new ItemsForEmeraldsTrade(Items.field_196196_el, 3, 1, 12, 15), new ItemsForEmeraldsTrade(Items.field_196198_en, 3, 1, 12, 15), new ItemsForEmeraldsTrade(Items.field_196206_ev, 3, 1, 12, 15), new ItemsForEmeraldsTrade(Items.field_196201_eq, 3, 1, 12, 15), new ItemsForEmeraldsTrade(Items.field_196193_ei, 3, 1, 12, 15), new ItemsForEmeraldsTrade(Items.field_196200_ep, 3, 1, 12, 15), new ItemsForEmeraldsTrade(Items.field_196203_es, 3, 1, 12, 15), new ItemsForEmeraldsTrade(Items.field_196195_ek, 3, 1, 12, 15), new ItemsForEmeraldsTrade(Items.field_196192_eh, 3, 1, 12, 15), new ItemsForEmeraldsTrade(Items.field_196199_eo, 3, 1, 12, 15)}, (Object)5, (Object)new VillagerTrades.ITrade[]{new ItemsForEmeraldsTrade(Items.field_151159_an, 2, 3, 30)})));
        p_221237_0_.put(AlienJobs.JOB4, AlienTrade.gatAsIntMap((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151055_y, 32, 16, 2), new ItemsForEmeraldsTrade(Items.field_151032_g, 1, 16, 1), new ItemsForEmeraldsAndItemsTrade((IItemProvider)Blocks.field_150351_n, 10, Items.field_151145_ak, 10, 12, 1)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151145_ak, 26, 12, 10), new ItemsForEmeraldsTrade(Items.field_151031_f, 2, 1, 5)}, (Object)3, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151007_F, 14, 16, 20), new ItemsForEmeraldsTrade(Items.field_222114_py, 3, 1, 10)}, (Object)4, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151008_G, 24, 16, 30), new EnchantedItemForEmeraldsTrade(Items.field_151031_f, 2, 3, 15)}, (Object)5, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_221737_dE, 8, 12, 30), new EnchantedItemForEmeraldsTrade(Items.field_222114_py, 3, 3, 15), new ItemWithPotionForEmeraldsAndItemsTrade(Items.field_151032_g, 5, Items.field_185167_i, 5, 2, 12, 30)})));
        p_221237_0_.put(AlienJobs.JOB5, AlienTrade.gatAsIntMap((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.builder().put((Object)1, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151121_aF, 24, 16, 2), new EnchantedBookForEmeraldsTrade(1), new ItemsForEmeraldsTrade(Blocks.field_150342_X, 9, 1, 12, 1)}).put((Object)2, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151122_aG, 4, 12, 10), new EnchantedBookForEmeraldsTrade(5), new ItemsForEmeraldsTrade(Items.field_222111_pQ, 1, 1, 5)}).put((Object)3, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_196136_br, 5, 12, 20), new EnchantedBookForEmeraldsTrade(10), new ItemsForEmeraldsTrade(Items.field_221650_am, 1, 4, 10)}).put((Object)4, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151099_bA, 2, 12, 30), new EnchantedBookForEmeraldsTrade(15), new ItemsForEmeraldsTrade(Items.field_151113_aN, 5, 1, 15), new ItemsForEmeraldsTrade(Items.field_151111_aL, 4, 1, 15)}).put((Object)5, (Object)new VillagerTrades.ITrade[]{new ItemsForEmeraldsTrade(Items.field_151057_cb, 20, 1, 30)}).build()));
        p_221237_0_.put(AlienJobs.JOB6, AlienTrade.gatAsIntMap((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151121_aF, 24, 16, 2), new ItemsForEmeraldsTrade(Items.field_151148_bJ, 7, 1, 1)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_221792_df, 11, 16, 10), new EmeraldForMapTrade(13, Structure.field_236376_l_, MapDecoration.Type.MONUMENT, 12, 5)}, (Object)3, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151111_aL, 1, 12, 20), new EmeraldForMapTrade(14, Structure.field_236368_d_, MapDecoration.Type.MANSION, 12, 10)}, (Object)4, (Object)new VillagerTrades.ITrade[]{new ItemsForEmeraldsTrade(Items.field_151160_bD, 7, 1, 15), new ItemsForEmeraldsTrade(Items.field_196191_eg, 3, 1, 15), new ItemsForEmeraldsTrade(Items.field_196202_er, 3, 1, 15), new ItemsForEmeraldsTrade(Items.field_196194_ej, 3, 1, 15), new ItemsForEmeraldsTrade(Items.field_196205_eu, 3, 1, 15), new ItemsForEmeraldsTrade(Items.field_196197_em, 3, 1, 15), new ItemsForEmeraldsTrade(Items.field_196204_et, 3, 1, 15), new ItemsForEmeraldsTrade(Items.field_196196_el, 3, 1, 15), new ItemsForEmeraldsTrade(Items.field_196198_en, 3, 1, 15), new ItemsForEmeraldsTrade(Items.field_196206_ev, 3, 1, 15), new ItemsForEmeraldsTrade(Items.field_196201_eq, 3, 1, 15), new ItemsForEmeraldsTrade(Items.field_196193_ei, 3, 1, 15), new ItemsForEmeraldsTrade(Items.field_196200_ep, 3, 1, 15), new ItemsForEmeraldsTrade(Items.field_196203_es, 3, 1, 15), new ItemsForEmeraldsTrade(Items.field_196195_ek, 3, 1, 15), new ItemsForEmeraldsTrade(Items.field_196192_eh, 3, 1, 15), new ItemsForEmeraldsTrade(Items.field_196199_eo, 3, 1, 15)}, (Object)5, (Object)new VillagerTrades.ITrade[]{new ItemsForEmeraldsTrade(Items.field_222099_pF, 8, 1, 30)})));
        p_221237_0_.put(AlienJobs.JOB7, AlienTrade.gatAsIntMap((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151078_bh, 32, 16, 2), new ItemsForEmeraldsTrade(Items.field_151137_ax, 1, 2, 1)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151043_k, 3, 12, 10), new ItemsForEmeraldsTrade(Items.field_196128_bn, 1, 1, 5)}, (Object)3, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_179556_br, 2, 12, 20), new ItemsForEmeraldsTrade(Blocks.field_150426_aN, 4, 1, 12, 10)}, (Object)4, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_203183_eM, 4, 12, 30), new EmeraldForItemsTrade((IItemProvider)Items.field_151069_bo, 9, 12, 30), new ItemsForEmeraldsTrade(Items.field_151079_bi, 5, 1, 15)}, (Object)5, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151075_bm, 22, 12, 30), new ItemsForEmeraldsTrade(Items.field_151062_by, 3, 1, 30)})));
        p_221237_0_.put(AlienJobs.JOB8, AlienTrade.gatAsIntMap((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151044_h, 15, 16, 2), new ItemsForEmeraldsTrade(new ItemStack((IItemProvider)Items.field_151165_aa), 7, 1, 12, 1, 0.2f), new ItemsForEmeraldsTrade(new ItemStack((IItemProvider)Items.field_151167_ab), 4, 1, 12, 1, 0.2f), new ItemsForEmeraldsTrade(new ItemStack((IItemProvider)Items.field_151028_Y), 5, 1, 12, 1, 0.2f), new ItemsForEmeraldsTrade(new ItemStack((IItemProvider)Items.field_151030_Z), 9, 1, 12, 1, 0.2f)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151042_j, 4, 12, 10), new ItemsForEmeraldsTrade(new ItemStack((IItemProvider)Items.field_222109_pP), 36, 1, 12, 5, 0.2f), new ItemsForEmeraldsTrade(new ItemStack((IItemProvider)Items.field_151029_X), 1, 1, 12, 5, 0.2f), new ItemsForEmeraldsTrade(new ItemStack((IItemProvider)Items.field_151022_W), 3, 1, 12, 5, 0.2f)}, (Object)3, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151129_at, 1, 12, 20), new EmeraldForItemsTrade((IItemProvider)Items.field_151045_i, 1, 12, 20), new ItemsForEmeraldsTrade(new ItemStack((IItemProvider)Items.field_151020_U), 1, 1, 12, 10, 0.2f), new ItemsForEmeraldsTrade(new ItemStack((IItemProvider)Items.field_151023_V), 4, 1, 12, 10, 0.2f), new ItemsForEmeraldsTrade(new ItemStack((IItemProvider)Items.field_185159_cQ), 5, 1, 12, 10, 0.2f)}, (Object)4, (Object)new VillagerTrades.ITrade[]{new EnchantedItemForEmeraldsTrade(Items.field_151173_ae, 14, 3, 15, 0.2f), new EnchantedItemForEmeraldsTrade(Items.field_151175_af, 8, 3, 15, 0.2f)}, (Object)5, (Object)new VillagerTrades.ITrade[]{new EnchantedItemForEmeraldsTrade(Items.field_151161_ac, 8, 3, 30, 0.2f), new EnchantedItemForEmeraldsTrade(Items.field_151163_ad, 16, 3, 30, 0.2f)})));
        p_221237_0_.put(AlienJobs.JOB9, AlienTrade.gatAsIntMap((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151044_h, 15, 16, 2), new ItemsForEmeraldsTrade(new ItemStack((IItemProvider)Items.field_151036_c), 3, 1, 12, 1, 0.2f), new EnchantedItemForEmeraldsTrade(Items.field_151040_l, 2, 3, 1)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151042_j, 4, 12, 10), new ItemsForEmeraldsTrade(new ItemStack((IItemProvider)Items.field_222109_pP), 36, 1, 12, 5, 0.2f)}, (Object)3, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151145_ak, 24, 12, 20)}, (Object)4, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151045_i, 1, 12, 30), new EnchantedItemForEmeraldsTrade(Items.field_151056_x, 12, 3, 15, 0.2f)}, (Object)5, (Object)new VillagerTrades.ITrade[]{new EnchantedItemForEmeraldsTrade(Items.field_151048_u, 8, 3, 30, 0.2f)})));
        p_221237_0_.put(AlienJobs.JOB10, AlienTrade.gatAsIntMap((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151044_h, 15, 16, 2), new ItemsForEmeraldsTrade(new ItemStack((IItemProvider)Items.field_151049_t), 1, 1, 12, 1, 0.2f), new ItemsForEmeraldsTrade(new ItemStack((IItemProvider)Items.field_151051_r), 1, 1, 12, 1, 0.2f), new ItemsForEmeraldsTrade(new ItemStack((IItemProvider)Items.field_151050_s), 1, 1, 12, 1, 0.2f), new ItemsForEmeraldsTrade(new ItemStack((IItemProvider)Items.field_151018_J), 1, 1, 12, 1, 0.2f)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151042_j, 4, 12, 10), new ItemsForEmeraldsTrade(new ItemStack((IItemProvider)Items.field_222109_pP), 36, 1, 12, 5, 0.2f)}, (Object)3, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151145_ak, 30, 12, 20), new EnchantedItemForEmeraldsTrade(Items.field_151036_c, 1, 3, 10, 0.2f), new EnchantedItemForEmeraldsTrade(Items.field_151037_a, 2, 3, 10, 0.2f), new EnchantedItemForEmeraldsTrade(Items.field_151035_b, 3, 3, 10, 0.2f), new ItemsForEmeraldsTrade(new ItemStack((IItemProvider)Items.field_151012_L), 4, 1, 3, 10, 0.2f)}, (Object)4, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151045_i, 1, 12, 30), new EnchantedItemForEmeraldsTrade(Items.field_151056_x, 12, 3, 15, 0.2f), new EnchantedItemForEmeraldsTrade(Items.field_151047_v, 5, 3, 15, 0.2f)}, (Object)5, (Object)new VillagerTrades.ITrade[]{new EnchantedItemForEmeraldsTrade(Items.field_151046_w, 13, 3, 30, 0.2f)})));
        p_221237_0_.put(AlienJobs.JOB11, AlienTrade.gatAsIntMap((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151076_bf, 14, 16, 2), new EmeraldForItemsTrade((IItemProvider)Items.field_151147_al, 7, 16, 2), new EmeraldForItemsTrade((IItemProvider)Items.field_179558_bo, 4, 16, 2), new ItemsForEmeraldsTrade(Items.field_179560_bq, 1, 1, 1)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151044_h, 15, 16, 2), new ItemsForEmeraldsTrade(Items.field_151157_am, 1, 5, 16, 5), new ItemsForEmeraldsTrade(Items.field_151077_bg, 1, 8, 16, 5)}, (Object)3, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_179561_bm, 7, 16, 20), new EmeraldForItemsTrade((IItemProvider)Items.field_151082_bd, 10, 16, 20)}, (Object)4, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_222067_kP, 10, 12, 30)}, (Object)5, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_222112_pR, 10, 12, 30)})));
        p_221237_0_.put(AlienJobs.JOB12, AlienTrade.gatAsIntMap((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151116_aA, 6, 16, 2), new DyedArmorForEmeraldsTrade(Items.field_151026_S, 3), new DyedArmorForEmeraldsTrade(Items.field_151027_R, 7)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151145_ak, 26, 12, 10), new DyedArmorForEmeraldsTrade(Items.field_151024_Q, 5, 12, 5), new DyedArmorForEmeraldsTrade(Items.field_151021_T, 4, 12, 5)}, (Object)3, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_179555_bs, 9, 12, 20), new DyedArmorForEmeraldsTrade(Items.field_151027_R, 7)}, (Object)4, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_203183_eM, 4, 12, 30), new DyedArmorForEmeraldsTrade(Items.field_222110_op, 6, 12, 15)}, (Object)5, (Object)new VillagerTrades.ITrade[]{new ItemsForEmeraldsTrade(new ItemStack((IItemProvider)Items.field_151141_av), 6, 1, 12, 30, 0.2f), new DyedArmorForEmeraldsTrade(Items.field_151024_Q, 5, 12, 30)})));
        p_221237_0_.put(AlienJobs.JOB13, AlienTrade.gatAsIntMap((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151119_aD, 10, 16, 2), new ItemsForEmeraldsTrade(Items.field_151118_aC, 1, 10, 16, 1)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Blocks.field_150348_b, 20, 16, 10), new ItemsForEmeraldsTrade(Blocks.field_196702_dl, 1, 4, 16, 5)}, (Object)3, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Blocks.field_196650_c, 16, 16, 20), new EmeraldForItemsTrade((IItemProvider)Blocks.field_196656_g, 16, 16, 20), new EmeraldForItemsTrade((IItemProvider)Blocks.field_196654_e, 16, 16, 20), new ItemsForEmeraldsTrade(Blocks.field_196657_h, 1, 4, 16, 10), new ItemsForEmeraldsTrade(Blocks.field_196655_f, 1, 4, 16, 10), new ItemsForEmeraldsTrade(Blocks.field_196652_d, 1, 4, 16, 10)}, (Object)4, (Object)new VillagerTrades.ITrade[]{new EmeraldForItemsTrade((IItemProvider)Items.field_151128_bU, 12, 12, 30), new ItemsForEmeraldsTrade(Blocks.field_196778_fp, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_196777_fo, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_196797_fz, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_196782_fr, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_196789_fv, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_196791_fw, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_196722_fD, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_196721_fC, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_196787_fu, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_196780_fq, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_196785_ft, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_196720_fB, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_196793_fx, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_196795_fy, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_196783_fs, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_196719_fA, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_192428_dC, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_192427_dB, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_192438_dM, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_192430_dE, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_192434_dI, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_196876_iu, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_192442_dQ, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_192441_dP, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_192433_dH, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_192429_dD, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_192432_dG, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_192440_dO, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_192436_dK, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_192437_dL, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_192431_dF, 1, 1, 12, 15), new ItemsForEmeraldsTrade(Blocks.field_192439_dN, 1, 1, 12, 15)}, (Object)5, (Object)new VillagerTrades.ITrade[]{new ItemsForEmeraldsTrade(Blocks.field_196770_fj, 1, 1, 12, 30), new ItemsForEmeraldsTrade(Blocks.field_150371_ca, 1, 1, 12, 30)})));
    });

    private static Int2ObjectMap<VillagerTrades.ITrade[]> gatAsIntMap(ImmutableMap<Integer, VillagerTrades.ITrade[]> p_221238_0_) {
        return new Int2ObjectOpenHashMap(p_221238_0_);
    }

    static class ItemWithPotionForEmeraldsAndItemsTrade
    implements VillagerTrades.ITrade {
        private final ItemStack potionStack;
        private final int potionCount;
        private final int emeraldCount;
        private final int maxUses;
        private final int xpValue;
        private final Item buyingItem;
        private final int buyingItemCount;
        private final float priceMultiplier;

        public ItemWithPotionForEmeraldsAndItemsTrade(Item buyingItem, int buyingItemCount, Item p_i50526_3_, int p_i50526_4_, int emeralds, int maxUses, int xpValue) {
            this.potionStack = new ItemStack((IItemProvider)p_i50526_3_);
            this.emeraldCount = emeralds;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.buyingItem = buyingItem;
            this.buyingItemCount = buyingItemCount;
            this.potionCount = p_i50526_4_;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            ItemStack itemstack = new ItemStack((IItemProvider)Items.field_151166_bC, this.emeraldCount);
            List list = Registry.field_212621_j.func_201756_e().filter(potion -> !potion.func_185170_a().isEmpty() && PotionBrewing.func_222124_a((Potion)potion)).collect(Collectors.toList());
            Potion potion2 = (Potion)list.get(rand.nextInt(list.size()));
            ItemStack itemstack1 = PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)this.potionStack.func_77973_b(), this.potionCount), (Potion)potion2);
            return new MerchantOffer(itemstack, new ItemStack((IItemProvider)this.buyingItem, this.buyingItemCount), itemstack1, this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    static class EmeraldForMapTrade
    implements VillagerTrades.ITrade {
        private final int count;
        private final Structure<?> structureName;
        private final MapDecoration.Type mapDecorationType;
        private final int maxUses;
        private final int xpValue;

        public EmeraldForMapTrade(int count, Structure<?> structureName, MapDecoration.Type mapDecorationType, int maxUses, int xpValue) {
            this.count = count;
            this.structureName = structureName;
            this.mapDecorationType = mapDecorationType;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            if (!(trader.field_70170_p instanceof ServerWorld)) {
                return null;
            }
            ServerWorld serverworld = (ServerWorld)trader.field_70170_p;
            BlockPos blockpos = null;
            if (blockpos != null) {
                ItemStack itemstack = FilledMapItem.func_195952_a((World)serverworld, (int)blockpos.func_177958_n(), (int)blockpos.func_177952_p(), (byte)2, (boolean)true, (boolean)true);
                FilledMapItem.func_226642_a_((ServerWorld)serverworld, (ItemStack)itemstack);
                MapData.func_191094_a((ItemStack)itemstack, blockpos, (String)"+", (MapDecoration.Type)this.mapDecorationType);
                itemstack.func_200302_a((ITextComponent)new TranslationTextComponent("filled_map." + this.structureName.func_143025_a().toLowerCase(Locale.ROOT)));
                return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, this.count), new ItemStack((IItemProvider)Items.field_151111_aL), itemstack, this.maxUses, this.xpValue, 0.2f);
            }
            return null;
        }
    }

    static class EmeraldForVillageTypeItemTrade
    implements VillagerTrades.ITrade {
        private final Map<VillagerType, Item> villagerTypeItems;
        private final int count;
        private final int maxUses;
        private final int xpValue;

        public EmeraldForVillageTypeItemTrade(int count, int maxUsesIn, int xpValueIn, Map<VillagerType, Item> villagerTypeItemsIn) {
            Registry.field_218369_K.func_201756_e().filter(villagerType -> !villagerTypeItemsIn.containsKey(villagerType)).findAny().ifPresent(villagerType -> {
                throw new IllegalStateException("Missing trade for villager type: " + Registry.field_218369_K.func_177774_c(villagerType));
            });
            this.villagerTypeItems = villagerTypeItemsIn;
            this.count = count;
            this.maxUses = maxUsesIn;
            this.xpValue = xpValueIn;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            if (trader instanceof IVillagerDataHolder) {
                ItemStack itemstack = new ItemStack((IItemProvider)this.villagerTypeItems.get(((IVillagerDataHolder)trader).func_213700_eh().func_221129_a()), this.count);
                return new MerchantOffer(itemstack, new ItemStack((IItemProvider)Items.field_151166_bC), this.maxUses, this.xpValue, 0.05f);
            }
            return null;
        }
    }

    static class SuspiciousStewForEmeraldTrade
    implements VillagerTrades.ITrade {
        final Effect effect;
        final int duration;
        final int xpValue;
        private final float priceMultiplier;

        public SuspiciousStewForEmeraldTrade(Effect effectIn, int durationIn, int xpValue) {
            this.effect = effectIn;
            this.duration = durationIn;
            this.xpValue = xpValue;
            this.priceMultiplier = 0.05f;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            ItemStack itemstack = new ItemStack((IItemProvider)Items.field_222115_pz, 1);
            SuspiciousStewItem.func_220037_a((ItemStack)itemstack, (Effect)this.effect, (int)this.duration);
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 1), itemstack, 12, this.xpValue, this.priceMultiplier);
        }
    }

    static class EnchantedItemForEmeraldsTrade
    implements VillagerTrades.ITrade {
        private final ItemStack sellingStack;
        private final int emeraldCount;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public EnchantedItemForEmeraldsTrade(Item p_i50535_1_, int emeraldCount, int maxUses, int xpValue) {
            this(p_i50535_1_, emeraldCount, maxUses, xpValue, 0.05f);
        }

        public EnchantedItemForEmeraldsTrade(Item sellItem, int emeraldCount, int maxUses, int xpValue, float priceMultiplier) {
            this.sellingStack = new ItemStack((IItemProvider)sellItem);
            this.emeraldCount = emeraldCount;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            int i = 5 + rand.nextInt(15);
            ItemStack itemstack = EnchantmentHelper.func_77504_a((Random)rand, (ItemStack)new ItemStack((IItemProvider)this.sellingStack.func_77973_b()), (int)i, (boolean)false);
            int j = Math.min(this.emeraldCount + i, 64);
            ItemStack itemstack1 = new ItemStack((IItemProvider)Items.field_151166_bC, j);
            return new MerchantOffer(itemstack1, itemstack, this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    static class ItemsForEmeraldsAndItemsTrade
    implements VillagerTrades.ITrade {
        private final ItemStack buyingItem;
        private final int buyingItemCount;
        private final int emeraldCount;
        private final ItemStack sellingItem;
        private final int sellingItemCount;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public ItemsForEmeraldsAndItemsTrade(IItemProvider buyingItem, int buyingItemCount, Item sellingItem, int sellingItemCount, int maxUses, int xpValue) {
            this(buyingItem, buyingItemCount, 1, sellingItem, sellingItemCount, maxUses, xpValue);
        }

        public ItemsForEmeraldsAndItemsTrade(IItemProvider buyingItem, int buyingItemCount, int emeraldCount, Item sellingItem, int sellingItemCount, int maxUses, int xpValue) {
            this.buyingItem = new ItemStack(buyingItem);
            this.buyingItemCount = buyingItemCount;
            this.emeraldCount = emeraldCount;
            this.sellingItem = new ItemStack((IItemProvider)sellingItem);
            this.sellingItemCount = sellingItemCount;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.priceMultiplier = 0.05f;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, this.emeraldCount), new ItemStack((IItemProvider)this.buyingItem.func_77973_b(), this.buyingItemCount), new ItemStack((IItemProvider)this.sellingItem.func_77973_b(), this.sellingItemCount), this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    static class EnchantedBookForEmeraldsTrade
    implements VillagerTrades.ITrade {
        private final int xpValue;

        public EnchantedBookForEmeraldsTrade(int xpValueIn) {
            this.xpValue = xpValueIn;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            List list = Registry.field_212628_q.func_201756_e().filter(Enchantment::func_230309_h_).collect(Collectors.toList());
            Enchantment enchantment = (Enchantment)list.get(rand.nextInt(list.size()));
            int i = MathHelper.func_76136_a((Random)rand, (int)enchantment.func_77319_d(), (int)enchantment.func_77325_b());
            ItemStack itemstack = EnchantedBookItem.func_92111_a((EnchantmentData)new EnchantmentData(enchantment, i));
            int j = 2 + rand.nextInt(5 + i * 10) + 3 * i;
            if (enchantment.func_185261_e()) {
                j *= 2;
            }
            if (j > 64) {
                j = 64;
            }
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, j), new ItemStack((IItemProvider)Items.field_151122_aG), itemstack, 12, this.xpValue, 0.2f);
        }
    }

    static class DyedArmorForEmeraldsTrade
    implements VillagerTrades.ITrade {
        private final Item tradeItem;
        private final int price;
        private final int maxUses;
        private final int xpValue;

        public DyedArmorForEmeraldsTrade(Item itemIn, int priceIn) {
            this(itemIn, priceIn, 12, 1);
        }

        public DyedArmorForEmeraldsTrade(Item tradeItemIn, int priceIn, int maxUsesIn, int xpValueIn) {
            this.tradeItem = tradeItemIn;
            this.price = priceIn;
            this.maxUses = maxUsesIn;
            this.xpValue = xpValueIn;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            ItemStack itemstack = new ItemStack((IItemProvider)Items.field_151166_bC, this.price);
            ItemStack itemstack1 = new ItemStack((IItemProvider)this.tradeItem);
            if (this.tradeItem instanceof DyeableArmorItem) {
                ArrayList list = Lists.newArrayList();
                list.add(DyedArmorForEmeraldsTrade.getRandomDyeItem(rand));
                if (rand.nextFloat() > 0.7f) {
                    list.add(DyedArmorForEmeraldsTrade.getRandomDyeItem(rand));
                }
                if (rand.nextFloat() > 0.8f) {
                    list.add(DyedArmorForEmeraldsTrade.getRandomDyeItem(rand));
                }
                itemstack1 = IDyeableArmorItem.func_219975_a((ItemStack)itemstack1, (List)list);
            }
            return new MerchantOffer(itemstack, itemstack1, this.maxUses, this.xpValue, 0.2f);
        }

        private static DyeItem getRandomDyeItem(Random p_221232_0_) {
            return DyeItem.func_195961_a((DyeColor)DyeColor.func_196056_a((int)p_221232_0_.nextInt(16)));
        }
    }

    static class EmeraldForItemsTrade
    implements VillagerTrades.ITrade {
        private final Item tradeItem;
        private final int count;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public EmeraldForItemsTrade(IItemProvider tradeItemIn, int countIn, int maxUsesIn, int xpValueIn) {
            this.tradeItem = tradeItemIn.func_199767_j();
            this.count = countIn;
            this.maxUses = maxUsesIn;
            this.xpValue = xpValueIn;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            ItemStack itemstack = new ItemStack((IItemProvider)this.tradeItem, this.count);
            return new MerchantOffer(itemstack, new ItemStack((IItemProvider)Items.field_151166_bC), this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    static class ItemsForEmeraldsTrade
    implements VillagerTrades.ITrade {
        private final ItemStack sellingItem;
        private final int emeraldCount;
        private final int sellingItemCount;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public ItemsForEmeraldsTrade(Block sellingItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue) {
            this(new ItemStack((IItemProvider)sellingItem), emeraldCount, sellingItemCount, maxUses, xpValue);
        }

        public ItemsForEmeraldsTrade(Item sellingItem, int emeraldCount, int sellingItemCount, int xpValue) {
            this(new ItemStack((IItemProvider)sellingItem), emeraldCount, sellingItemCount, 12, xpValue);
        }

        public ItemsForEmeraldsTrade(Item sellingItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue) {
            this(new ItemStack((IItemProvider)sellingItem), emeraldCount, sellingItemCount, maxUses, xpValue);
        }

        public ItemsForEmeraldsTrade(ItemStack sellingItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue) {
            this(sellingItem, emeraldCount, sellingItemCount, maxUses, xpValue, 0.05f);
        }

        public ItemsForEmeraldsTrade(ItemStack sellingItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue, float priceMultiplier) {
            this.sellingItem = sellingItem;
            this.emeraldCount = emeraldCount;
            this.sellingItemCount = sellingItemCount;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.priceMultiplier = priceMultiplier;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            return null;
        }
    }
}

