/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.entity;

import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EntityArmorInvWrapper;
import net.minecraftforge.items.wrapper.EntityHandsInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import net.mrscauthd.boss_tools.BossToolsModElements;
import net.mrscauthd.boss_tools.entity.renderer.RocketRenderer;
import net.mrscauthd.boss_tools.gui.RocketTier1GUIFuelGui;
import net.mrscauthd.boss_tools.procedures.RocketEntityIsHurt1Procedure;
import net.mrscauthd.boss_tools.procedures.RocketOnEntityTickUpdateProcedure;

@BossToolsModElements.ModElement.Tag
public class RocketEntity
extends BossToolsModElements.ModElement {
    public static EntityType entity = null;

    public RocketEntity(BossToolsModElements instance) {
        super(instance, 91);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new RocketRenderer.ModelRegisterHandler());
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new EntityAttributesRegisterHandler());
        NetworkLoader.registerMessages();
    }

    @Override
    public void initElements() {
        entity = (EntityType)EntityType.Builder.func_220322_a(CustomEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(100).setUpdateInterval(3).setCustomClientFactory(CustomEntity::new).func_220320_c().func_220321_a(1.0f, 3.0f).func_206830_a("rocket").setRegistryName("rocket");
        this.elements.entities.add(() -> entity);
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
    }

    private static class RocketSpin2Packet {
        private double animationpitch;
        private int entityId;

        public RocketSpin2Packet(int entityId, double animationpitch) {
            this.animationpitch = animationpitch;
            this.entityId = entityId;
        }

        public static void encode(RocketSpin2Packet msg, PacketBuffer buf) {
            buf.writeInt(msg.entityId);
            buf.writeDouble(msg.animationpitch);
        }

        public static RocketSpin2Packet decode(PacketBuffer buf) {
            return new RocketSpin2Packet(buf.readInt(), buf.readDouble());
        }

        public static void handle(RocketSpin2Packet msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(msg.entityId);
                if (entity instanceof LivingEntity) {
                    ((LivingEntity)entity).getPersistentData().func_74780_a("AnimationPitch", msg.animationpitch);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    private static class RocketSpinPacket {
        private double animation;
        private int entityId;

        public RocketSpinPacket(int entityId, double animation) {
            this.animation = animation;
            this.entityId = entityId;
        }

        public static void encode(RocketSpinPacket msg, PacketBuffer buf) {
            buf.writeInt(msg.entityId);
            buf.writeDouble(msg.animation);
        }

        public static RocketSpinPacket decode(PacketBuffer buf) {
            return new RocketSpinPacket(buf.readInt(), buf.readDouble());
        }

        public static void handle(RocketSpinPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(msg.entityId);
                if (entity instanceof LivingEntity) {
                    ((LivingEntity)entity).getPersistentData().func_74780_a("Animation", msg.animation);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    private static class NetworkLoader {
        public static SimpleChannel INSTANCE;
        private static int id;

        private NetworkLoader() {
        }

        public static int nextID() {
            return id++;
        }

        public static void registerMessages() {
            INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("boss_tools", "rocket_link"), () -> "1.0", s -> true, s -> true);
            INSTANCE.registerMessage(NetworkLoader.nextID(), RocketSpinPacket.class, RocketSpinPacket::encode, RocketSpinPacket::decode, RocketSpinPacket::handle);
            INSTANCE.registerMessage(NetworkLoader.nextID(), RocketSpin2Packet.class, RocketSpin2Packet::encode, RocketSpin2Packet::decode, RocketSpin2Packet::handle);
        }

        static {
            id = 1;
        }
    }

    public static class CustomEntity
    extends CreatureEntity {
        private final ItemStackHandler inventory = new ItemStackHandler(9){

            public int getSlotLimit(int slot) {
                return 64;
            }
        };
        private final CombinedInvWrapper combined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, new EntityHandsInvWrapper((LivingEntity)this), new EntityArmorInvWrapper((LivingEntity)this)});

        public CustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            this((EntityType<CustomEntity>)entity, world);
        }

        public CustomEntity(EntityType<CustomEntity> type, World world) {
            super(type, world);
            this.field_70728_aV = 5;
            this.func_94061_f(false);
            this.func_110163_bv();
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        public boolean func_184652_a(PlayerEntity player) {
            return false;
        }

        public boolean func_70104_M() {
            return false;
        }

        protected void func_82167_n(Entity p_82167_1_) {
        }

        public void func_70108_f(Entity entityIn) {
        }

        protected void func_184651_r() {
            super.func_184651_r();
        }

        public CreatureAttribute func_70668_bt() {
            return CreatureAttribute.field_223222_a_;
        }

        public boolean func_213397_c(double distanceToClosestPlayer) {
            return false;
        }

        public double func_70042_X() {
            return super.func_70042_X() + -1.7000000000000002;
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(""));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(""));
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            CustomEntity entity = this;
            Entity sourceentity = source.func_76346_g();
            HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
            $_dependencies.put("entity", (Object)entity);
            $_dependencies.put("x", x);
            $_dependencies.put("y", y);
            $_dependencies.put("z", z);
            $_dependencies.put("world", this.field_70170_p);
            RocketEntityIsHurt1Procedure.executeProcedure($_dependencies);
            if (source.func_76364_f() instanceof ArrowEntity) {
                return false;
            }
            if (source.func_76364_f() instanceof PlayerEntity) {
                return false;
            }
            if (source.func_76364_f() instanceof PotionEntity) {
                return false;
            }
            if (source == DamageSource.field_76379_h) {
                return false;
            }
            if (source == DamageSource.field_76367_g) {
                return false;
            }
            if (source == DamageSource.field_76369_e) {
                return false;
            }
            if (source == DamageSource.field_180137_b) {
                return false;
            }
            if (source.func_94541_c()) {
                return false;
            }
            if (source.func_76355_l().equals("trident")) {
                return false;
            }
            if (source == DamageSource.field_82728_o) {
                return false;
            }
            if (source == DamageSource.field_188407_q) {
                return false;
            }
            if (source == DamageSource.field_82727_n) {
                return false;
            }
            if (source.func_76355_l().equals("witherSkull")) {
                return false;
            }
            return super.func_70097_a(source, amount);
        }

        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
            if (this.func_70089_S() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side == null) {
                return LazyOptional.of(() -> this.combined).cast();
            }
            return super.getCapability(capability, side);
        }

        public void func_213281_b(CompoundNBT compound) {
            super.func_213281_b(compound);
            compound.func_218657_a("InventoryCustom", (INBT)this.inventory.serializeNBT());
        }

        public void func_70037_a(CompoundNBT compound) {
            super.func_70037_a(compound);
            INBT inventoryCustom = compound.func_74781_a("InventoryCustom");
            if (inventoryCustom instanceof CompoundNBT) {
                this.inventory.deserializeNBT((CompoundNBT)inventoryCustom);
            }
        }

        public ActionResultType func_230254_b_(final PlayerEntity sourceentity, Hand hand) {
            ItemStack itemstack = sourceentity.func_184586_b(hand);
            ActionResultType retval = ActionResultType.func_233537_a_((boolean)this.field_70170_p.func_201670_d());
            if (sourceentity.func_226563_dT_()) {
                if (sourceentity instanceof ServerPlayerEntity) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)sourceentity), (INamedContainerProvider)new INamedContainerProvider(){

                        public ITextComponent func_145748_c_() {
                            return new StringTextComponent("Rocket");
                        }

                        public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
                            PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
                            packetBuffer.func_179255_a(new BlockPos((Vector3i)sourceentity.func_233580_cy_()));
                            packetBuffer.writeByte(0);
                            packetBuffer.func_150787_b(this.func_145782_y());
                            return new RocketTier1GUIFuelGui.GuiContainerMod(id, inventory, packetBuffer);
                        }
                    }, buf -> {
                        buf.func_179255_a(new BlockPos((Vector3i)sourceentity.func_233580_cy_()));
                        buf.writeByte(0);
                        buf.func_150787_b(this.func_145782_y());
                    });
                }
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.func_201670_d());
            }
            super.func_230254_b_(sourceentity, hand);
            sourceentity.func_184220_m((Entity)this);
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            CustomEntity entity = this;
            return retval;
        }

        public void func_70030_z() {
            super.func_70030_z();
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            CustomEntity entity = this;
            HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
            $_dependencies.put("entity", (Object)entity);
            $_dependencies.put("x", x);
            $_dependencies.put("y", y);
            $_dependencies.put("z", z);
            $_dependencies.put("world", this.field_70170_p);
            RocketOnEntityTickUpdateProcedure.executeProcedure($_dependencies);
            if (!this.field_70170_p.field_72995_K) {
                NetworkLoader.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this), (Object)new RocketSpinPacket(this.func_145782_y(), this.getPersistentData().func_74769_h("Animation")));
            }
            if (!this.field_70170_p.field_72995_K) {
                NetworkLoader.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this), (Object)new RocketSpin2Packet(this.func_145782_y(), this.getPersistentData().func_74769_h("AnimationPitch")));
            }
        }
    }

    private static class EntityAttributesRegisterHandler {
        private EntityAttributesRegisterHandler() {
        }

        @SubscribeEvent
        public void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
            AttributeModifierMap.MutableAttribute ammma = MobEntity.func_233666_p_();
            ammma = ammma.func_233815_a_(Attributes.field_233821_d_, 0.0);
            ammma = ammma.func_233815_a_(Attributes.field_233818_a_, 1000.0);
            ammma = ammma.func_233815_a_(Attributes.field_233826_i_, 0.0);
            ammma = ammma.func_233815_a_(Attributes.field_233823_f_, 0.0);
            event.put(entity, ammma.func_233813_a_());
        }
    }
}

