/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.entity;

import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EntityArmorInvWrapper;
import net.minecraftforge.items.wrapper.EntityHandsInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import net.mrscauthd.boss_tools.BossToolsModElements;
import net.mrscauthd.boss_tools.entity.renderer.RoverRenderer;
import net.mrscauthd.boss_tools.gui.Rover1GUIGui;
import net.mrscauthd.boss_tools.item.RoverItemItem;
import net.mrscauthd.boss_tools.procedures.RoverEntityIsHurtProcedure;
import net.mrscauthd.boss_tools.procedures.RoverOnEntityTickUpdateProcedure;

@BossToolsModElements.ModElement.Tag
public class RoverEntity
extends BossToolsModElements.ModElement {
    public static EntityType entity = (EntityType)EntityType.Builder.func_220322_a(CustomEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CustomEntity::new).func_220320_c().func_220321_a(2.5f, 1.0f).func_206830_a("rover").setRegistryName("rover");
    public static double speed = 0.0;
    public static boolean fw = false;
    public static float forward = 0.0f;

    public RoverEntity(BossToolsModElements instance) {
        super(instance, 394);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new RoverRenderer.ModelRegisterHandler());
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new EntityAttributesRegisterHandler());
        NetworkLoader.registerMessages();
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> entity);
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
    }

    public static class CustomEntity
    extends CreatureEntity {
        private final ItemStackHandler inventory = new ItemStackHandler(9){

            public int getSlotLimit(int slot) {
                return 64;
            }
        };
        private final CombinedInvWrapper combined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, new EntityHandsInvWrapper((LivingEntity)this), new EntityArmorInvWrapper((LivingEntity)this)});

        public CustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            this((EntityType<CustomEntity>)entity, world);
        }

        public CustomEntity(EntityType<CustomEntity> type, World world) {
            super(type, world);
            this.field_70728_aV = 0;
            this.func_94061_f(false);
            this.func_110163_bv();
        }

        protected void applyYawToEntity(Entity entityToUpdate) {
            entityToUpdate.func_181013_g(this.field_70177_z);
            float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
            float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
            entityToUpdate.field_70126_B += f1 - f;
            entityToUpdate.field_70177_z += f1 - f;
            entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_184190_l(Entity entityToUpdate) {
            this.applyYawToEntity(entityToUpdate);
        }

        public boolean func_184652_a(PlayerEntity player) {
            return false;
        }

        public boolean func_70104_M() {
            return false;
        }

        protected void func_82167_n(Entity p_82167_1_) {
        }

        public void func_70108_f(Entity entityIn) {
        }

        protected void func_184225_p(Entity passenger) {
            if (passenger.func_225608_bj_() && !passenger.field_70170_p.field_72995_K && passenger instanceof ServerPlayerEntity) {
                ServerPlayerEntity playerEntity = (ServerPlayerEntity)passenger;
                this.func_70659_e(0.0f);
            }
            super.func_184225_p(passenger);
        }

        public double func_70042_X() {
            return super.func_70042_X() + -0.4;
        }

        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
            if (this.func_70089_S() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side == null) {
                return LazyOptional.of(() -> this.combined).cast();
            }
            return super.getCapability(capability, side);
        }

        public void func_213281_b(CompoundNBT compound) {
            super.func_213281_b(compound);
            compound.func_218657_a("InventoryCustom", (INBT)this.inventory.serializeNBT());
        }

        public void func_70037_a(CompoundNBT compound) {
            super.func_70037_a(compound);
            INBT inventoryCustom = compound.func_74781_a("InventoryCustom");
            if (inventoryCustom instanceof CompoundNBT) {
                this.inventory.deserializeNBT((CompoundNBT)inventoryCustom);
            }
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        protected void func_184651_r() {
            super.func_184651_r();
        }

        public CreatureAttribute func_70668_bt() {
            return CreatureAttribute.field_223222_a_;
        }

        public boolean func_213397_c(double distanceToClosestPlayer) {
            return false;
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(""));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(""));
        }

        public void func_180429_a(BlockPos pos, BlockState blockIn) {
            this.func_184185_a((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("")), 0.0f, 0.0f);
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            ItemStack itemstack;
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            CustomEntity entity = this;
            Entity sourceentity = source.func_76346_g();
            if (sourceentity != null && sourceentity.func_225608_bj_()) {
                for (int i = 0; i < this.inventory.getSlots(); ++i) {
                    itemstack = this.inventory.getStackInSlot(i);
                    if (itemstack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)itemstack)) continue;
                    this.func_199701_a_(itemstack);
                }
                HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
                $_dependencies.put("entity", (Object)entity);
                $_dependencies.put("x", x);
                $_dependencies.put("y", y);
                $_dependencies.put("z", z);
                $_dependencies.put("world", this.field_70170_p);
                RoverEntityIsHurtProcedure.executeProcedure($_dependencies);
            }
            if (sourceentity == null && !entity.func_184207_aI()) {
                for (int i = 0; i < this.inventory.getSlots(); ++i) {
                    itemstack = this.inventory.getStackInSlot(i);
                    if (itemstack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)itemstack)) continue;
                    this.func_199701_a_(itemstack);
                }
                ItemStack itemfuel = ItemStack.field_190927_a;
                itemfuel = new ItemStack((IItemProvider)RoverItemItem.block, 1);
                itemfuel.func_196082_o().func_74780_a("Rocketfuel", entity.getPersistentData().func_74769_h("Rocketfuel"));
                itemfuel.func_196082_o().func_74780_a("fuel", entity.getPersistentData().func_74769_h("fuel"));
                itemfuel.func_196082_o().func_74780_a("fuelgui", entity.getPersistentData().func_74769_h("fuel") / 160.0);
                if (this.field_70170_p instanceof World && !this.field_70170_p.func_201670_d()) {
                    ItemEntity entityToSpawn = new ItemEntity(this.field_70170_p, x, y, z, itemfuel);
                    entityToSpawn.func_174867_a(10);
                    this.field_70170_p.func_217376_c((Entity)entityToSpawn);
                }
                this.func_70106_y();
            }
            if (source == DamageSource.field_82729_p) {
                return false;
            }
            if (source.func_76364_f() instanceof ArrowEntity) {
                return false;
            }
            if (source.func_76364_f() instanceof PlayerEntity) {
                return false;
            }
            if (source.func_76364_f() instanceof PotionEntity) {
                return false;
            }
            if (source == DamageSource.field_76379_h) {
                return false;
            }
            if (source == DamageSource.field_76367_g) {
                return false;
            }
            if (source == DamageSource.field_76369_e) {
                return false;
            }
            if (source == DamageSource.field_180137_b) {
                return false;
            }
            if (source.func_94541_c()) {
                return false;
            }
            if (source.func_76355_l().equals("trident")) {
                return false;
            }
            if (source == DamageSource.field_82728_o) {
                return false;
            }
            if (source == DamageSource.field_188407_q) {
                return false;
            }
            if (source == DamageSource.field_82727_n) {
                return false;
            }
            if (source.func_76355_l().equals("witherSkull")) {
                return false;
            }
            return super.func_70097_a(source, amount);
        }

        public ActionResultType func_230254_b_(final PlayerEntity sourceentity, Hand hand) {
            ItemStack itemstack = sourceentity.func_184586_b(hand);
            ActionResultType retval = ActionResultType.func_233537_a_((boolean)this.field_70170_p.func_201670_d());
            if (sourceentity.func_226563_dT_()) {
                if (sourceentity instanceof ServerPlayerEntity) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)sourceentity), (INamedContainerProvider)new INamedContainerProvider(){

                        public ITextComponent func_145748_c_() {
                            return new StringTextComponent("Rover");
                        }

                        public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
                            PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
                            packetBuffer.func_179255_a(new BlockPos((Vector3i)sourceentity.func_233580_cy_()));
                            packetBuffer.writeByte(0);
                            packetBuffer.func_150787_b(this.func_145782_y());
                            return new Rover1GUIGui.GuiContainerMod(id, inventory, packetBuffer);
                        }
                    }, buf -> {
                        buf.func_179255_a(new BlockPos((Vector3i)sourceentity.func_233580_cy_()));
                        buf.writeByte(0);
                        buf.func_150787_b(this.func_145782_y());
                    });
                }
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.func_201670_d());
            }
            super.func_230254_b_(sourceentity, hand);
            sourceentity.func_184220_m((Entity)this);
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            CustomEntity entity = this;
            return retval;
        }

        public void func_70030_z() {
            Entity entity2;
            super.func_70030_z();
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            CustomEntity entity = this;
            Entity entity3 = entity2 = this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
            if (entity2 instanceof LivingEntity) {
                forward = ((LivingEntity)entity2).field_191988_bg;
            }
            if ((double)forward >= 0.01) {
                this.getPersistentData().func_74780_a("Wheel", 1.0);
            }
            if ((double)forward <= -0.01) {
                this.getPersistentData().func_74780_a("Wheel", 0.0);
            }
            HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
            $_dependencies.put("entity", (Object)entity);
            RoverOnEntityTickUpdateProcedure.executeProcedure($_dependencies);
            this.field_70143_R = 0.0f;
            if (!this.field_70170_p.field_72995_K) {
                NetworkLoader.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this), (Object)new RotationSpinPacket(this.func_145782_y(), this.getPersistentData().func_74769_h("Rotation")));
            }
            if (!this.field_70170_p.field_72995_K) {
                NetworkLoader.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this), (Object)new WheelSpinPacket(this.func_145782_y(), this.getPersistentData().func_74769_h("Wheel")));
            }
            if (!this.field_70170_p.field_72995_K) {
                NetworkLoader.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this), (Object)new FuelSpinPacket(this.func_145782_y(), this.getPersistentData().func_74769_h("fuel")));
            }
        }

        public void func_213352_e(Vector3d dir) {
            Entity entity;
            Entity entity2 = entity = this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
            if (this.func_184207_aI()) {
                float f1;
                double d0;
                this.field_70126_B = this.field_70177_z = (this.field_70177_z = (float)this.getPersistentData().func_74769_h("Rotation"));
                this.field_70125_A = entity.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70747_aH = this.func_70689_ay() * 0.15f;
                this.field_70761_aq = this.field_70177_z;
                this.field_70759_as = this.field_70177_z;
                this.field_70138_W = 1.0f;
                if (entity instanceof LivingEntity) {
                    float strafe;
                    float forward = ((LivingEntity)entity).field_191988_bg;
                    if (forward >= 0.0f) {
                        strafe = 0.0f;
                        if (this.getPersistentData().func_74769_h("fuel") >= 1.0) {
                            if ((double)this.func_70689_ay() >= 0.01 && speed <= 0.32) {
                                speed += 0.02;
                            }
                            if ((double)this.func_70689_ay() <= 0.25) {
                                this.func_70659_e(this.func_70689_ay() + 0.02f);
                            }
                        }
                        if (forward == 0.0f || this.getPersistentData().func_74769_h("fuel") <= 1.0) {
                            this.func_70659_e(0.0f);
                            if (speed != 0.0 && speed >= 0.0) {
                                speed -= 0.02;
                            }
                        }
                        super.func_213352_e(new Vector3d((double)strafe, 0.0, (double)forward));
                    }
                    if ((double)forward <= -0.01) {
                        speed = 0.0;
                        strafe = 0.0f;
                        if (this.getPersistentData().func_74769_h("fuel") >= 1.0) {
                            if ((double)this.func_70689_ay() >= 0.01) {
                                // empty if block
                            }
                            if ((double)this.func_70689_ay() <= 0.04) {
                                this.func_70659_e(this.func_70689_ay() + 0.02f);
                            }
                        }
                        if ((double)this.func_70689_ay() >= 0.08) {
                            this.func_70659_e(0.0f);
                        }
                        if (forward == 0.0f || this.getPersistentData().func_74769_h("fuel") <= 1.0) {
                            this.func_70659_e(0.0f);
                        }
                        super.func_213352_e(new Vector3d((double)strafe, 0.0, (double)forward));
                    }
                    if (this.getPersistentData().func_74769_h("fuel") == 2.0 && entity instanceof PlayerEntity) {
                        ((PlayerEntity)entity).func_146105_b((ITextComponent)new StringTextComponent("\u00a7cNO FUEL!"), true);
                    }
                    if (this.getPersistentData().func_74769_h("fuel") >= 1.0) {
                        if ((double)forward <= -0.01) {
                            this.getPersistentData().func_74780_a("fuel", this.getPersistentData().func_74769_h("fuel") - 2.0);
                        }
                        if ((double)forward >= 0.01) {
                            this.getPersistentData().func_74780_a("fuel", this.getPersistentData().func_74769_h("fuel") - 2.0);
                        }
                    }
                }
                if (this.getPersistentData().func_74769_h("Wheel") == 1.0) {
                    this.field_184618_aE = this.field_70721_aZ;
                    double d1 = this.func_226277_ct_() - this.field_70169_q;
                    f1 = MathHelper.func_76133_a((double)(d1 * d1 + (d0 = this.func_226281_cx_() - this.field_70166_s) * d0)) * 4.0f;
                    if (f1 > 1.0f) {
                        f1 = 1.0f;
                    }
                    this.field_70721_aZ += (f1 - this.field_70721_aZ) * 0.4f;
                    this.field_184619_aG += this.field_70721_aZ;
                }
                if (this.getPersistentData().func_74769_h("Wheel") == 0.0) {
                    this.field_184618_aE = this.field_70721_aZ;
                    double d1 = this.func_226277_ct_() - this.field_70169_q;
                    f1 = -MathHelper.func_76133_a((double)(d1 * d1 + (d0 = this.func_226281_cx_() - this.field_70166_s) * d0)) * 8.0f;
                    if (f1 > 1.0f) {
                        f1 = 1.0f;
                    }
                    this.field_70721_aZ += (f1 - this.field_70721_aZ) * 0.8f;
                    this.field_184619_aG += this.field_70721_aZ;
                }
                return;
            }
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            super.func_213352_e(dir);
        }
    }

    private static class FuelSpinPacket {
        private double fuel;
        private int entityId;

        public FuelSpinPacket(int entityId, double fuel) {
            this.fuel = fuel;
            this.entityId = entityId;
        }

        public static void encode(FuelSpinPacket msg, PacketBuffer buf) {
            buf.writeInt(msg.entityId);
            buf.writeDouble(msg.fuel);
        }

        public static FuelSpinPacket decode(PacketBuffer buf) {
            return new FuelSpinPacket(buf.readInt(), buf.readDouble());
        }

        public static void handle(FuelSpinPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(msg.entityId);
                if (entity instanceof LivingEntity) {
                    ((LivingEntity)entity).getPersistentData().func_74780_a("fuel", msg.fuel);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    private static class WheelSpinPacket {
        private double wheel;
        private int entityId;

        public WheelSpinPacket(int entityId, double wheel) {
            this.wheel = wheel;
            this.entityId = entityId;
        }

        public static void encode(WheelSpinPacket msg, PacketBuffer buf) {
            buf.writeInt(msg.entityId);
            buf.writeDouble(msg.wheel);
        }

        public static WheelSpinPacket decode(PacketBuffer buf) {
            return new WheelSpinPacket(buf.readInt(), buf.readDouble());
        }

        public static void handle(WheelSpinPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(msg.entityId);
                if (entity instanceof LivingEntity) {
                    ((LivingEntity)entity).getPersistentData().func_74780_a("Wheel", msg.wheel);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    private static class RotationSpinPacket {
        private double rotation;
        private int entityId;

        public RotationSpinPacket(int entityId, double rotation) {
            this.rotation = rotation;
            this.entityId = entityId;
        }

        public static void encode(RotationSpinPacket msg, PacketBuffer buf) {
            buf.writeInt(msg.entityId);
            buf.writeDouble(msg.rotation);
        }

        public static RotationSpinPacket decode(PacketBuffer buf) {
            return new RotationSpinPacket(buf.readInt(), buf.readDouble());
        }

        public static void handle(RotationSpinPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(msg.entityId);
                if (entity instanceof LivingEntity) {
                    ((LivingEntity)entity).getPersistentData().func_74780_a("Rotation", msg.rotation);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    private static class NetworkLoader {
        public static SimpleChannel INSTANCE;
        private static int id;

        private NetworkLoader() {
        }

        public static int nextID() {
            return id++;
        }

        public static void registerMessages() {
            INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("boss_tools", "rover_link"), () -> "100.0", s -> true, s -> true);
            INSTANCE.registerMessage(NetworkLoader.nextID(), RotationSpinPacket.class, RotationSpinPacket::encode, RotationSpinPacket::decode, RotationSpinPacket::handle);
            INSTANCE.registerMessage(NetworkLoader.nextID(), WheelSpinPacket.class, WheelSpinPacket::encode, WheelSpinPacket::decode, WheelSpinPacket::handle);
            INSTANCE.registerMessage(NetworkLoader.nextID(), FuelSpinPacket.class, FuelSpinPacket::encode, FuelSpinPacket::decode, FuelSpinPacket::handle);
        }

        static {
            id = 1;
        }
    }

    private static class EntityAttributesRegisterHandler {
        private EntityAttributesRegisterHandler() {
        }

        @SubscribeEvent
        public void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
            AttributeModifierMap.MutableAttribute ammma = MobEntity.func_233666_p_();
            ammma = ammma.func_233815_a_(Attributes.field_233821_d_, 0.0);
            ammma = ammma.func_233815_a_(Attributes.field_233818_a_, 10.0);
            ammma = ammma.func_233815_a_(Attributes.field_233826_i_, 0.0);
            ammma = ammma.func_233815_a_(Attributes.field_233823_f_, 0.0);
            event.put(entity, ammma.func_233813_a_());
        }
    }
}

