/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.gui;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.mrscauthd.boss_tools.BossToolsMod;
import net.mrscauthd.boss_tools.BossToolsModElements;
import net.mrscauthd.boss_tools.block.FuelBlock;
import net.mrscauthd.boss_tools.gui.RocketTier1GUIFuelGuiWindow;

@BossToolsModElements.ModElement.Tag
public class RocketTier1GUIFuelGui
extends BossToolsModElements.ModElement {
    public static HashMap guistate = new HashMap();
    private static ContainerType<GuiContainerMod> containerType = null;

    public RocketTier1GUIFuelGui(BossToolsModElements instance) {
        super(instance, 142);
        this.elements.addNetworkMessage(ButtonPressedMessage.class, ButtonPressedMessage::buffer, ButtonPressedMessage::new, ButtonPressedMessage::handler);
        this.elements.addNetworkMessage(GUISlotChangedMessage.class, GUISlotChangedMessage::buffer, GUISlotChangedMessage::new, GUISlotChangedMessage::handler);
        containerType = new ContainerType((ContainerType.IFactory)new GuiContainerModFactory());
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new ContainerRegisterHandler());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initElements() {
        DeferredWorkQueue.runLater(() -> ScreenManager.func_216911_a(containerType, RocketTier1GUIFuelGuiWindow::new));
    }

    static void handleButtonAction(PlayerEntity entity, int buttonID, int x, int y, int z) {
        World world = entity.field_70170_p;
        if (!world.func_175667_e(new BlockPos(x, y, z))) {
            return;
        }
    }

    private static void handleSlotAction(PlayerEntity entity, int slotID, int changeType, int meta, int x, int y, int z) {
        World world = entity.field_70170_p;
        if (!world.func_175667_e(new BlockPos(x, y, z))) {
            return;
        }
    }

    public static class GUISlotChangedMessage {
        int slotID;
        int x;
        int y;
        int z;
        int changeType;
        int meta;

        public GUISlotChangedMessage(int slotID, int x, int y, int z, int changeType, int meta) {
            this.slotID = slotID;
            this.x = x;
            this.y = y;
            this.z = z;
            this.changeType = changeType;
            this.meta = meta;
        }

        public GUISlotChangedMessage(PacketBuffer buffer) {
            this.slotID = buffer.readInt();
            this.x = buffer.readInt();
            this.y = buffer.readInt();
            this.z = buffer.readInt();
            this.changeType = buffer.readInt();
            this.meta = buffer.readInt();
        }

        public static void buffer(GUISlotChangedMessage message, PacketBuffer buffer) {
            buffer.writeInt(message.slotID);
            buffer.writeInt(message.x);
            buffer.writeInt(message.y);
            buffer.writeInt(message.z);
            buffer.writeInt(message.changeType);
            buffer.writeInt(message.meta);
        }

        public static void handler(GUISlotChangedMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                ServerPlayerEntity entity = context.getSender();
                int slotID = message.slotID;
                int changeType = message.changeType;
                int meta = message.meta;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                RocketTier1GUIFuelGui.handleSlotAction((PlayerEntity)entity, slotID, changeType, meta, x, y, z);
            });
            context.setPacketHandled(true);
        }
    }

    public static class ButtonPressedMessage {
        int buttonID;
        int x;
        int y;
        int z;

        public ButtonPressedMessage(PacketBuffer buffer) {
            this.buttonID = buffer.readInt();
            this.x = buffer.readInt();
            this.y = buffer.readInt();
            this.z = buffer.readInt();
        }

        public ButtonPressedMessage(int buttonID, int x, int y, int z) {
            this.buttonID = buttonID;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public static void buffer(ButtonPressedMessage message, PacketBuffer buffer) {
            buffer.writeInt(message.buttonID);
            buffer.writeInt(message.x);
            buffer.writeInt(message.y);
            buffer.writeInt(message.z);
        }

        public static void handler(ButtonPressedMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                ServerPlayerEntity entity = context.getSender();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                RocketTier1GUIFuelGui.handleButtonAction((PlayerEntity)entity, buttonID, x, y, z);
            });
            context.setPacketHandled(true);
        }
    }

    public static class GuiContainerMod
    extends Container
    implements Supplier<Map<Integer, Slot>> {
        World world;
        PlayerEntity entity;
        int x;
        int y;
        int z;
        private IItemHandler internal;
        private Map<Integer, Slot> customSlots = new HashMap<Integer, Slot>();
        private boolean bound = false;

        public GuiContainerMod(int id, PlayerInventory inv, PacketBuffer extraData) {
            super(containerType, id);
            int si;
            this.entity = inv.field_70458_d;
            this.world = inv.field_70458_d.field_70170_p;
            this.internal = new ItemStackHandler(1);
            BlockPos pos = null;
            if (extraData != null) {
                pos = extraData.func_179259_c();
                this.x = pos.func_177958_n();
                this.y = pos.func_177956_o();
                this.z = pos.func_177952_p();
            }
            if (pos != null) {
                if (extraData.readableBytes() == 1) {
                    byte hand = extraData.readByte();
                    ItemStack itemstack = hand == 0 ? this.entity.func_184614_ca() : this.entity.func_184592_cb();
                    itemstack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(capability -> {
                        this.internal = capability;
                        this.bound = true;
                    });
                } else if (extraData.readableBytes() > 1) {
                    extraData.readByte();
                    Entity entity = this.world.func_73045_a(extraData.func_150792_a());
                    if (entity != null) {
                        entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(capability -> {
                            this.internal = capability;
                            this.bound = true;
                        });
                    }
                } else {
                    TileEntity ent;
                    TileEntity tileEntity = ent = inv.field_70458_d != null ? inv.field_70458_d.field_70170_p.func_175625_s(pos) : null;
                    if (ent != null) {
                        ent.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(capability -> {
                            this.internal = capability;
                            this.bound = true;
                        });
                    }
                }
            }
            this.customSlots.put(0, this.func_75146_a((Slot)new SlotItemHandler(this.internal, 0, 46, 22){

                public boolean func_75214_a(ItemStack stack) {
                    return new ItemStack((IItemProvider)FuelBlock.bucket, 1).func_77973_b() == stack.func_77973_b();
                }
            }));
            for (si = 0; si < 3; ++si) {
                for (int sj = 0; sj < 9; ++sj) {
                    this.func_75146_a(new Slot((IInventory)inv, sj + (si + 1) * 9, 8 + sj * 18, 84 + si * 18));
                }
            }
            for (si = 0; si < 9; ++si) {
                this.func_75146_a(new Slot((IInventory)inv, si, 8 + si * 18, 142));
            }
        }

        @Override
        public Map<Integer, Slot> get() {
            return this.customSlots;
        }

        public boolean func_75145_c(PlayerEntity player) {
            return true;
        }

        public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
            ItemStack itemstack = ItemStack.field_190927_a;
            Slot slot = (Slot)this.field_75151_b.get(index);
            if (slot != null && slot.func_75216_d()) {
                ItemStack itemstack1 = slot.func_75211_c();
                itemstack = itemstack1.func_77946_l();
                if (index < 1) {
                    if (!this.func_75135_a(itemstack1, 1, this.field_75151_b.size(), true)) {
                        return ItemStack.field_190927_a;
                    }
                    slot.func_75220_a(itemstack1, itemstack);
                } else if (!this.func_75135_a(itemstack1, 0, 1, false)) {
                    if (index < 28 ? !this.func_75135_a(itemstack1, 28, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 1, 28, false)) {
                        return ItemStack.field_190927_a;
                    }
                    return ItemStack.field_190927_a;
                }
                if (itemstack1.func_190916_E() == 0) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                } else {
                    slot.func_75218_e();
                }
                if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                    return ItemStack.field_190927_a;
                }
                slot.func_190901_a(playerIn, itemstack1);
            }
            return itemstack;
        }

        protected boolean func_75135_a(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
            boolean flag = false;
            int i = startIndex;
            if (reverseDirection) {
                i = endIndex - 1;
            }
            if (stack.func_77985_e()) {
                while (!stack.func_190926_b() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
                    ItemStack itemstack;
                    Slot slot = (Slot)this.field_75151_b.get(i);
                    if (slot.func_75214_a(itemstack = slot.func_75211_c()) && !itemstack.func_190926_b() && GuiContainerMod.func_195929_a((ItemStack)stack, (ItemStack)itemstack)) {
                        int maxSize;
                        int j = itemstack.func_190916_E() + stack.func_190916_E();
                        if (j <= (maxSize = Math.min(slot.func_75219_a(), stack.func_77976_d()))) {
                            stack.func_190920_e(0);
                            itemstack.func_190920_e(j);
                            slot.func_75215_d(itemstack);
                            flag = true;
                        } else if (itemstack.func_190916_E() < maxSize) {
                            stack.func_190918_g(maxSize - itemstack.func_190916_E());
                            itemstack.func_190920_e(maxSize);
                            slot.func_75215_d(itemstack);
                            flag = true;
                        }
                    }
                    if (reverseDirection) {
                        --i;
                        continue;
                    }
                    ++i;
                }
            }
            if (!stack.func_190926_b()) {
                i = reverseDirection ? endIndex - 1 : startIndex;
                while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                    Slot slot1 = (Slot)this.field_75151_b.get(i);
                    ItemStack itemstack1 = slot1.func_75211_c();
                    if (itemstack1.func_190926_b() && slot1.func_75214_a(stack)) {
                        if (stack.func_190916_E() > slot1.func_75219_a()) {
                            slot1.func_75215_d(stack.func_77979_a(slot1.func_75219_a()));
                        } else {
                            slot1.func_75215_d(stack.func_77979_a(stack.func_190916_E()));
                        }
                        slot1.func_75218_e();
                        flag = true;
                        break;
                    }
                    if (reverseDirection) {
                        --i;
                        continue;
                    }
                    ++i;
                }
            }
            return flag;
        }

        public void func_75134_a(PlayerEntity playerIn) {
            block4: {
                super.func_75134_a(playerIn);
                if (this.bound || !(playerIn instanceof ServerPlayerEntity)) break block4;
                if (!playerIn.func_70089_S() || playerIn instanceof ServerPlayerEntity && ((ServerPlayerEntity)playerIn).func_193105_t()) {
                    for (int j = 0; j < this.internal.getSlots(); ++j) {
                        playerIn.func_71019_a(this.internal.extractItem(j, this.internal.getStackInSlot(j).func_190916_E(), false), false);
                    }
                } else {
                    for (int i = 0; i < this.internal.getSlots(); ++i) {
                        playerIn.field_71071_by.func_191975_a(playerIn.field_70170_p, this.internal.extractItem(i, this.internal.getStackInSlot(i).func_190916_E(), false));
                    }
                }
            }
        }

        private void slotChanged(int slotid, int ctype, int meta) {
            if (this.world != null && this.world.func_201670_d()) {
                BossToolsMod.PACKET_HANDLER.sendToServer((Object)new GUISlotChangedMessage(slotid, this.x, this.y, this.z, ctype, meta));
                RocketTier1GUIFuelGui.handleSlotAction(this.entity, slotid, ctype, meta, this.x, this.y, this.z);
            }
        }
    }

    public static class GuiContainerModFactory
    implements IContainerFactory {
        public GuiContainerMod create(int id, PlayerInventory inv, PacketBuffer extraData) {
            return new GuiContainerMod(id, inv, extraData);
        }
    }

    private static class ContainerRegisterHandler {
        private ContainerRegisterHandler() {
        }

        @SubscribeEvent
        public void registerContainer(RegistryEvent.Register<ContainerType<?>> event) {
            event.getRegistry().register(containerType.setRegistryName("rocket_tier_1_gui_fuel"));
        }
    }
}

