/*
 * Decompiled with CFR 0.152.
 */
package starcrop;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import starcrop.PacketBuy;
import starcrop.ServerHandlerBuy;

public class Dispatcher {
    private static final SimpleNetworkWrapper DISPATCHER = NetworkRegistry.INSTANCE.newSimpleChannel("starcrop");
    private static byte PACKET_ID;

    public static SimpleNetworkWrapper get() {
        return DISPATCHER;
    }

    public static void updateTrackers(Entity entity, IMessage message) {
        EntityTracker et = ((WorldServer)entity.field_70170_p).func_73039_n();
        for (EntityPlayer player : et.getTrackingPlayers(entity)) {
            DISPATCHER.sendTo(message, (EntityPlayerMP)player);
        }
    }

    public static void sendTo(IMessage message, EntityPlayerMP player) {
        DISPATCHER.sendTo(message, player);
    }

    public static void sendToServer(IMessage message) {
        DISPATCHER.sendToServer(message);
    }

    public static void register() {
        Dispatcher.register(PacketBuy.class, ServerHandlerBuy.class, Side.SERVER);
    }

    private static <REQ extends IMessage, REPLY extends IMessage> void register(Class<REQ> message, Class<? extends IMessageHandler<REQ, REPLY>> handler, Side side) {
        byte by = PACKET_ID;
        PACKET_ID = (byte)(by + 1);
        DISPATCHER.registerMessage(handler, message, (int)by, side);
    }
}

