/*
 * Decompiled with CFR 0.152.
 */
package starcrop;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomePlains;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import starcrop.FruitGen;
import starcrop.Register;

public class WorldStarGenTrees
implements IWorldGenerator {
    private final WorldGenerator Cinnamon = new WorldGenTrees(true, 7, Register.woodcinnamon.func_176223_P(), Register.leavescinnamon.func_176223_P(), false);
    private final WorldGenerator Apricot = new FruitGen(5, Blocks.field_150364_r.func_176223_P(), Register.leavesapricot.func_176223_P(), false, Register.apricot.func_176223_P());
    private final WorldGenerator Orange = new FruitGen(5, Blocks.field_150364_r.func_176223_P(), Register.leavesorange.func_176223_P(), false, Register.orange.func_176223_P());
    private final WorldGenerator Cherry = new FruitGen(5, Blocks.field_150364_r.func_176223_P(), Register.leavescherry.func_176223_P(), false, Register.cherry.func_176223_P());
    private final WorldGenerator Peach = new FruitGen(5, Blocks.field_150364_r.func_176223_P(), Register.leavespeach.func_176223_P(), false, Register.peach.func_176223_P());
    private final WorldGenerator Banana = new FruitGen(5, Register.woodbanana.func_176223_P(), Register.leavesbanana.func_176223_P(), false, Register.banana.func_176223_P());
    private final WorldGenerator Coconut = new FruitGen(20, Register.woodcoconut.func_176223_P(), Register.leavescoconut.func_176223_P(), true, Register.coconut.func_176223_P());

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 1: {
                break;
            }
            case 0: {
                this.runGenerator(this.Cinnamon, world, random, chunkX, chunkZ, 3, (Block)Blocks.field_150349_c, BiomePlains.class);
                this.runGenerator(this.Apricot, world, random, chunkX, chunkZ, 5, (Block)Blocks.field_150349_c, BiomePlains.class);
                this.runGenerator(this.Orange, world, random, chunkX, chunkZ, 5, (Block)Blocks.field_150349_c, BiomePlains.class);
                this.runGenerator(this.Cherry, world, random, chunkX, chunkZ, 5, (Block)Blocks.field_150349_c, BiomePlains.class);
                this.runGenerator(this.Peach, world, random, chunkX, chunkZ, 5, (Block)Blocks.field_150349_c, BiomePlains.class);
                this.runGenerator(this.Banana, world, random, chunkX, chunkZ, 2, (Block)Blocks.field_150349_c, BiomePlains.class);
                this.runGenerator(this.Coconut, world, random, chunkX, chunkZ, 2, (Block)Blocks.field_150349_c, BiomePlains.class);
                break;
            }
        }
    }

    private void runGenerator(WorldGenerator generator, World world, Random random, int chunkX, int chunkZ, int chance, Block topBlock, Class<?> ... classes) {
        ArrayList classesList = new ArrayList(Arrays.asList(classes));
        int x = chunkX * 16 + random.nextInt(15);
        int z = chunkZ * 16 + random.nextInt(15);
        int y = WorldStarGenTrees.calculateGenerationHeight(world, x, z, topBlock);
        BlockPos pos = new BlockPos(x, y, z);
        Class<?> biome = world.field_73011_w.getBiomeForCoords(pos).getClass();
        if (world.func_175624_G() != WorldType.field_77138_c && classesList.contains(biome) && random.nextInt(chance) == 0) {
            generator.func_180709_b(world, random, pos);
        }
    }

    private static int calculateGenerationHeight(World world, int x, int z, Block topBlock) {
        int y = world.func_72800_K();
        boolean foundGround = false;
        while (!foundGround && y-- >= 0) {
            Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            foundGround = block == topBlock;
        }
        return y;
    }
}

