/*
 * Decompiled with CFR 0.152.
 */
package starcrop.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import starcrop.GenarateTree;
import starcrop.Register;

public class ApricotSpling
extends BushBlock
implements IGrowable {
    public static final IntegerProperty STAGE = BlockStateProperties.field_208137_al;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);

    public ApricotSpling(String unlocalizedName) {
        super(Block.Properties.func_200945_a((Material)Material.field_151585_k).func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c).func_200942_a().func_200944_c());
        this.setRegistryName(unlocalizedName);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        super.func_196267_b(state, worldIn, pos, random);
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (worldIn.func_201696_r(pos.func_177984_a()) >= 9 && random.nextInt(7) == 0) {
            this.grow((IWorld)worldIn, pos, state, random);
        }
    }

    public void grow(IWorld worldIn, BlockPos pos, BlockState state, Random rand) {
        if ((Integer)state.func_177229_b((IProperty)STAGE) == 0) {
            worldIn.func_180501_a(pos, (BlockState)state.func_177231_a((IProperty)STAGE), 4);
        } else {
            if (!ForgeEventFactory.saplingGrowTree((IWorld)worldIn, (Random)rand, (BlockPos)pos)) {
                return;
            }
            new GenarateTree(5, Blocks.field_196617_K.func_176223_P(), Register.leavesapricot.func_176223_P()).func_196935_a(worldIn, pos, state, rand);
        }
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return (double)worldIn.field_73012_v.nextFloat() < 0.45;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, BlockState state) {
        this.grow((IWorld)worldIn, pos, state, rand);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{STAGE});
    }
}

