/*
 * Decompiled with CFR 0.152.
 */
package starcrop.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IRecipeHelperPopulator;
import net.minecraft.inventory.IRecipeHolder;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import starcrop.GuiBeeHiveServer;
import starcrop.Register;

public class TileEntityBeeHive
extends LockableTileEntity
implements ISidedInventory,
IRecipeHolder,
IRecipeHelperPopulator,
ITickableTileEntity {
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    private int cookTime;
    private int cookTimeTotal;
    protected final IIntArray furnaceData = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return TileEntityBeeHive.this.cookTime;
                }
                case 1: {
                    return TileEntityBeeHive.this.cookTimeTotal;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityBeeHive.this.cookTime = value;
                    break;
                }
                case 1: {
                    TileEntityBeeHive.this.cookTimeTotal = value;
                }
            }
        }

        public int func_221478_a() {
            return 2;
        }
    };

    public TileEntityBeeHive() {
        super(Register.TileEntityBeehive);
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.items);
        this.cookTime = compound.func_74762_e("CookTime");
        this.cookTimeTotal = compound.func_74762_e("CookTimeTotal");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("CookTimeTotal", this.cookTimeTotal);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.items);
        return compound;
    }

    public boolean isFlower(int x, int y, int z) {
        return this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c() == Blocks.field_196605_bc || this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c() == Blocks.field_196606_bd || this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c() == Blocks.field_196607_be || this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c() == Blocks.field_196609_bf || this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c() == Blocks.field_196610_bg || this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c() == Blocks.field_196612_bh || this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c() == Blocks.field_196613_bi || this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c() == Blocks.field_196614_bj || this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c() == Blocks.field_196615_bk || this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c() == Blocks.field_196616_bl || this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c() == Blocks.field_222387_by || this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c() == Blocks.field_222388_bz || this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c() == Blocks.field_222383_bA;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void beeSteal(int x, int y, int z) {
        double start = 0.0;
        double end = 1.0;
        double random = new Random().nextDouble();
        double result = start + random * (end - start);
        Minecraft.func_71410_x().field_71441_e.func_195594_a((IParticleData)Register.entityBee, (double)x + result, (double)(y + 1) + result, (double)z + result, 0.0, 0.0, 0.0);
    }

    public int CheckFlower() {
        int number = 0;
        int posx = this.func_174877_v().func_177958_n();
        int posz = this.func_174877_v().func_177952_p();
        for (int x = posx - 2; x < posx + 3; ++x) {
            for (int z = posz - 2; z < posz + 3; ++z) {
                if (!this.isFlower(x, this.func_174877_v().func_177956_o(), z)) continue;
                ++number;
            }
        }
        return number;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void beeSteal() {
        int posx = this.func_174877_v().func_177958_n();
        int posz = this.func_174877_v().func_177952_p();
        for (int x = posx - 2; x < posx + 3; ++x) {
            for (int z = posz - 2; z < posz + 3; ++z) {
                if (!this.isFlower(x, this.func_174877_v().func_177956_o(), z)) continue;
                this.beeSteal(x, this.func_174877_v().func_177956_o(), z);
            }
        }
    }

    private void beeSounds(int x, int y, int z) {
        if (this.CheckFlower() >= 1) {
            this.field_145850_b.func_184133_a(null, new BlockPos(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()), Register.bee, SoundCategory.BLOCKS, 0.05f, 1.5f);
        }
    }

    public void func_73660_a() {
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            if (((ItemStack)this.items.get(0)).func_190916_E() < 64) {
                this.cookTime += this.CheckFlower();
            }
            if (this.cookTime >= this.cookTimeTotal) {
                this.cookTime = 0;
                this.cookTimeTotal = this.getCookTime();
                this.smeltItem();
                flag1 = true;
            }
            this.beeSounds(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
        } else {
            this.beeSteal();
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public void smeltItem() {
        ItemStack itemstack1 = new ItemStack((IItemProvider)Register.honey);
        ItemStack itemstack2 = (ItemStack)this.items.get(0);
        if (itemstack2.func_190926_b()) {
            this.items.set(0, (Object)itemstack1.func_77946_l());
        } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
            itemstack2.func_190917_f(itemstack1.func_190916_E());
        }
    }

    protected int getCookTime() {
        return 15000;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174888_l() {
        this.items.clear();
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("block.mcfurnace.basic_furnace", new Object[0]);
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new GuiBeeHiveServer(id, player, (IInventory)this, this.furnaceData);
    }

    public void func_193056_a(IRecipe<?> recipe) {
    }

    public int[] func_180463_a(Direction side) {
        return null;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public void func_70299_a(int index, ItemStack stack) {
    }

    public IRecipe<?> func_193055_i() {
        return null;
    }

    public void func_194018_a(RecipeItemHelper helper) {
    }
}

