/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.statues;

import com.google.common.collect.ImmutableList;
import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.init.StatueSounds;
import com.shynieke.statues.recipes.StatueLootList;
import com.shynieke.statues.tiles.StatueBlockEntity;
import com.shynieke.statues.util.ListHelper;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CampfireStatueBlock
extends AbstractStatueBase {
    private static final VoxelShape SOUTH_EAST_SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)7.0, (double)16.0);
    private static final VoxelShape NORTH_WEST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)7.0, (double)11.0);
    public static List<Supplier<SoundEvent>> campfire_sounds = ImmutableList.of(StatueSounds.CAMPFIRE_BYE_RANDOM, StatueSounds.CAMPFIRE_COLD_RANDOM, StatueSounds.CAMPFIRE_GREETINGS_RANDOM, StatueSounds.CAMPFIRE_HELLO_RANDOM, StatueSounds.CAMPFIRE_SNACKS_RANDOM);

    public CampfireStatueBlock(BlockBehaviour.Properties builder) {
        super(builder.m_60918_(SoundType.f_56742_).m_60953_(state -> 12));
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return direction.m_122434_() == Direction.Axis.X ? NORTH_WEST_SHAPE : SOUTH_EAST_SHAPE;
    }

    @Override
    public void executeStatueBehavior(StatueBlockEntity tile, BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult result) {
        tile.giveItem(StatueLootList.getLootInfo(this.getLootName()).getLoot(), playerIn);
        tile.summonMob((LivingEntity)this.getGeneral(worldIn));
    }

    @Override
    public SoundEvent getSound(BlockState state) {
        return CampfireStatueBlock.getRandomCampfire();
    }

    public Creeper getGeneral(Level worldIn) {
        Creeper general = new Creeper(EntityType.f_20558_, worldIn);
        general.m_6593_((Component)new TextComponent("General Spazz"));
        CompoundTag tag = new CompoundTag();
        tag.m_128344_("ExplosionRadius", (byte)0);
        general.m_7380_(tag);
        return general;
    }

    public static SoundEvent getRandomCampfire() {
        return ListHelper.getRandomFromList(campfire_sounds).get();
    }

    @Override
    public String getLootName() {
        return "etho";
    }

    @Override
    public boolean isHiddenStatue() {
        return true;
    }
}

