/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.statues;

import com.shynieke.statues.blocks.AbstractBaseBlock;
import com.shynieke.statues.config.StatuesConfig;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.ModList;

public class InfoStatueBlock
extends AbstractBaseBlock {
    private static final VoxelShape BOTTOM_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.5, (double)13.0);
    private static final VoxelShape TOP_SHAPE = Block.m_49796_((double)5.5, (double)4.5, (double)5.5, (double)10.5, (double)7.0, (double)10.5);
    private static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)BOTTOM_SHAPE, (VoxelShape)TOP_SHAPE);

    public InfoStatueBlock(BlockBehaviour.Properties builder) {
        super(builder.m_60918_(SoundType.f_56742_));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult result) {
        this.sendInfoMessage(playerIn, worldIn, pos);
        return InteractionResult.SUCCESS;
    }

    public void sendInfoMessage(Player player, Level worldIn, BlockPos pos) {
        if (!worldIn.f_46443_) {
            int random = worldIn.f_46441_.nextInt(100);
            ArrayList<String> messages = new ArrayList<String>((Collection)StatuesConfig.COMMON.info_messages.get());
            List luckyPlayers = (List)StatuesConfig.COMMON.lucky_players.get();
            if (ModList.get().isLoaded("veinminer")) {
                messages.add("Did you know we have veinminer");
            }
            if (ModList.get().isLoaded("curios")) {
                messages.add("Did you know we have curios support");
            }
            int idx = new Random().nextInt(messages.size());
            Object randomMessage = new TextComponent((String)messages.get(idx));
            if (!luckyPlayers.isEmpty() && random < 20) {
                for (String luckyPlayer : luckyPlayers) {
                    if (luckyPlayer.isEmpty()) continue;
                    String luckyUser = luckyPlayer.trim();
                    if (!player.m_5446_().m_6111_().equalsIgnoreCase(luckyUser)) continue;
                    randomMessage = new TextComponent("Luck is not on your side today");
                }
            } else {
                LocalDate localdate = LocalDate.now();
                int i = localdate.get(ChronoField.DAY_OF_MONTH);
                int j = localdate.get(ChronoField.MONTH_OF_YEAR);
                randomMessage = worldIn.f_46441_.nextDouble() <= 0.3 && j == 11 && i <= 20 ? new TextComponent("Please check out our friends over at ").m_130940_(ChatFormatting.YELLOW).m_7220_(ForgeHooks.newChatWithLinks((String)"https://lovetropics.com/")) : new TextComponent((String)messages.get(idx));
            }
            player.m_6352_((Component)randomMessage, Util.f_137441_);
            worldIn.m_5594_(null, pos, SoundEvents.f_11797_, SoundSource.NEUTRAL, 0.5f, 1.0f);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }
}

