/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.statues;

import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.init.StatueRegistry;
import com.shynieke.statues.recipes.StatueLootList;
import com.shynieke.statues.tiles.StatueBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;

public class PigStatueBlock
extends AbstractStatueBase {
    private static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.5, (double)11.0);

    public PigStatueBlock(BlockBehaviour.Properties builder) {
        super(builder.m_60918_(SoundType.f_56742_));
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (this.isDecorative(state) && placer != null && worldIn.m_8055_(pos.m_7495_()).m_60620_((Tag)Tags.Blocks.SAND)) {
            BlockPos downPos = pos.m_7495_();
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123813_, (double)downPos.m_123341_(), (double)downPos.m_123342_(), (double)downPos.m_123343_(), 1.0, 0.0, 0.0);
            worldIn.m_46597_(pos.m_7495_(), (BlockState)((Block)StatueRegistry.WASTELAND_STATUE.get()).m_49966_().m_61124_((Property)FACING, (Comparable)placer.m_6350_().m_122424_()));
            worldIn.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
        super.m_6402_(worldIn, pos, state, placer, stack);
    }

    public boolean isDecorative(BlockState state) {
        return (Boolean)state.m_61143_((Property)INTERACTIVE) == false;
    }

    @Override
    public void executeStatueBehavior(StatueBlockEntity tile, BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult result) {
        tile.giveItem(StatueLootList.getLootInfo(this.getLootName()).getLoot(), playerIn);
    }

    @Override
    public String getLootName() {
        return "pig";
    }

    @Override
    public EntityType<?> getEntity() {
        return EntityType.f_20510_;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Override
    public SoundEvent getSound(BlockState state) {
        return SoundEvents.f_12233_;
    }
}

