/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.statues;

import com.google.common.collect.Maps;
import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.recipes.StatueLootList;
import com.shynieke.statues.tiles.StatueBlockEntity;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SheepStatueBlock
extends AbstractStatueBase {
    private static final VoxelShape SOUTH_EAST_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)3.5, (double)12.0, (double)8.5, (double)12.5);
    private static final VoxelShape NORTH_WEST_SHAPE = Block.m_49796_((double)3.5, (double)0.0, (double)4.0, (double)12.5, (double)8.5, (double)12.0);
    private static final Map<DyeColor, SheepStatueBlock> COLOR_DYE_STATUE_MAP = Maps.newEnumMap(DyeColor.class);
    private final DyeColor COLOR;

    public SheepStatueBlock(BlockBehaviour.Properties builder, DyeColor color) {
        super(builder.m_60918_(SoundType.f_56742_));
        this.COLOR = color;
        COLOR_DYE_STATUE_MAP.put(color, this);
    }

    @Override
    public void executeStatueBehavior(StatueBlockEntity tile, BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult result) {
        tile.giveItem(StatueLootList.getLootInfo(this.getLootName()).getLoot(), playerIn);
    }

    @Override
    public String getLootName() {
        return "sheep_" + this.COLOR.m_7912_();
    }

    @Override
    public EntityType<?> getEntity() {
        return EntityType.f_20520_;
    }

    @Override
    public SoundEvent getSound(BlockState state) {
        return SoundEvents.f_12341_;
    }

    public DyeColor getColor() {
        return this.COLOR;
    }

    public static SheepStatueBlock getStatue(DyeColor color) {
        return COLOR_DYE_STATUE_MAP.get(color);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return direction.m_122434_() == Direction.Axis.X ? NORTH_WEST_SHAPE : SOUTH_EAST_SHAPE;
    }
}

