/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.statues.fish;

import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.recipes.StatueLootList;
import com.shynieke.statues.tiles.StatueBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PufferfishStatueBlock
extends AbstractStatueBase {
    private static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0);
    private static final VoxelShape SHAPE_MEDIUM = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0);
    private static final VoxelShape SHAPE_BIG = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);
    private final int size;

    public PufferfishStatueBlock(BlockBehaviour.Properties builder, int size) {
        super(builder.m_60918_(SoundType.f_56742_));
        this.size = size;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch (this.size) {
            default: {
                return SHAPE;
            }
            case 1: {
                return SHAPE_MEDIUM;
            }
            case 2: 
        }
        return SHAPE_BIG;
    }

    @Override
    public void executeStatueBehavior(StatueBlockEntity tile, BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult result) {
        tile.giveItem(StatueLootList.getLootInfo(this.getLootName()).getLoot(), playerIn);
        tile.giveEffect(pos, playerIn, MobEffects.f_19614_);
    }

    @Override
    public String getLootName() {
        return "pufferfish";
    }

    @Override
    public EntityType<?> getEntity() {
        return EntityType.f_20516_;
    }

    @Override
    public SoundEvent getSound(BlockState state) {
        return SoundEvents.f_12291_;
    }
}

