/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.client.render;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.shynieke.statues.client.ClientHandler;
import com.shynieke.statues.client.model.StatuePlayerTileModel;
import com.shynieke.statues.client.render.PlayerTileRenderer;
import com.shynieke.statues.tiles.PlayerBlockEntity;
import com.shynieke.statues.util.SkinUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;

public class PlayerTileInventoryRenderer
extends BlockEntityWithoutLevelRenderer {
    private StatuePlayerTileModel model;
    private StatuePlayerTileModel slimModel;
    private static final Map<String, GameProfile> GAMEPROFILE_CACHE = new HashMap<String, GameProfile>();

    public PlayerTileInventoryRenderer() {
        super(null, null);
        ResourceManager resourceManager;
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft != null && (resourceManager = Minecraft.m_91087_().m_91098_()) instanceof ReloadableResourceManager) {
            ((ReloadableResourceManager)resourceManager).m_7217_((PreparableReloadListener)this);
        }
    }

    public void m_6213_(ResourceManager manager) {
        EntityModelSet modelSet = Minecraft.m_91087_().m_167973_();
        modelSet.m_6213_(manager);
        if (modelSet != null) {
            this.model = new StatuePlayerTileModel(modelSet.m_171103_(ClientHandler.PLAYER_STATUE), false);
            this.slimModel = new StatuePlayerTileModel(modelSet.m_171103_(ClientHandler.PLAYER_STATUE_SLIM), false);
        }
    }

    public void m_108829_(ItemStack stack, ItemTransforms.TransformType transformType, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        this.renderPlayerItem(stack, poseStack, bufferSource, combinedLight);
    }

    public void renderPlayerItem(ItemStack stack, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight) {
        poseStack.m_85836_();
        if (stack != null) {
            GameProfile gameprofile = null;
            if (stack.m_41788_()) {
                boolean validFlag;
                String stackName = stack.m_41786_().m_6111_().toLowerCase();
                boolean bl = validFlag = !stackName.isEmpty() && !stackName.contains(" ");
                if (validFlag) {
                    if (GAMEPROFILE_CACHE.containsKey(stackName)) {
                        gameprofile = GAMEPROFILE_CACHE.get(stackName);
                    }
                    if (stack.m_41782_() && gameprofile == null) {
                        CompoundTag compoundtag = stack.m_41783_();
                        if (compoundtag.m_128425_("PlayerProfile", 10)) {
                            GameProfile foundProfile = NbtUtils.m_129228_((CompoundTag)compoundtag.m_128469_("PlayerProfile"));
                            if (foundProfile != null) {
                                GAMEPROFILE_CACHE.put(foundProfile.getName().toLowerCase(), foundProfile);
                            }
                            if (foundProfile.getName().equalsIgnoreCase(stackName)) {
                                gameprofile = foundProfile;
                            }
                        } else if (compoundtag.m_128425_("PlayerProfile", 8) && !StringUtils.isBlank((CharSequence)compoundtag.m_128461_("PlayerProfile"))) {
                            GameProfile gameprofile1 = new GameProfile((UUID)null, compoundtag.m_128461_("PlayerProfile"));
                            compoundtag.m_128473_("PlayerProfile");
                            PlayerBlockEntity.updateGameprofile(gameprofile1, profile -> {
                                compoundtag.m_128365_("PlayerProfile", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)profile));
                                if (profile != null) {
                                    GAMEPROFILE_CACHE.put(profile.getName().toLowerCase(), (GameProfile)profile);
                                }
                            });
                            gameprofile = GAMEPROFILE_CACHE.get(stackName);
                        }
                    }
                    if (gameprofile == null) {
                        GameProfile gameprofile1 = new GameProfile((UUID)null, stackName);
                        PlayerBlockEntity.updateGameprofile(gameprofile1, profile -> {
                            if (profile != null) {
                                GAMEPROFILE_CACHE.put(profile.getName().toLowerCase(), (GameProfile)profile);
                            }
                        });
                    }
                } else {
                    if (GAMEPROFILE_CACHE.containsKey("steve")) {
                        gameprofile = GAMEPROFILE_CACHE.get("steve");
                    }
                    if (gameprofile == null) {
                        GameProfile gameprofile1 = new GameProfile((UUID)null, "steve");
                        PlayerBlockEntity.updateGameprofile(gameprofile1, profile -> {
                            if (profile != null) {
                                GAMEPROFILE_CACHE.put(profile.getName(), (GameProfile)profile);
                            }
                        });
                    }
                }
            }
            poseStack.m_85837_(0.5, 1.4, 0.5);
            poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
            this.renderItem(gameprofile, poseStack, bufferSource, combinedLight);
        }
        poseStack.m_85849_();
    }

    public void renderItem(GameProfile gameprofile, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight) {
        boolean flag = gameprofile != null && gameprofile.isComplete() && SkinUtil.isSlimSkin(gameprofile.getId());
        VertexConsumer vertexConsumer = bufferSource.m_6299_(PlayerTileRenderer.getRenderType(gameprofile));
        if (flag) {
            if (this.slimModel != null) {
                this.slimModel.m_7695_(poseStack, vertexConsumer, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        } else if (this.model != null) {
            this.model.m_7695_(poseStack, vertexConsumer, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

