/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.shynieke.statues.client.screen.DecimalNumberFieldBox;
import com.shynieke.statues.client.screen.NumberFieldBox;
import com.shynieke.statues.client.screen.PlayerStatueData;
import com.shynieke.statues.client.screen.ToggleButton;
import com.shynieke.statues.entity.PlayerStatue;
import com.shynieke.statues.packets.PlayerStatueSyncMessage;
import com.shynieke.statues.packets.StatuesNetworking;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class PlayerPoseScreen
extends Screen {
    private final PlayerStatue playerStatueEntity;
    private final PlayerStatueData playerStatueData;
    private final String[] buttonLabels = new String[]{"small", "rotation", "y_offset", "locked", "name_visible", "gravity"};
    private final String[] sliderLabels = new String[]{"head", "body", "left_leg", "right_leg", "left_arm", "right_arm"};
    private NumberFieldBox rotationTextField;
    private DecimalNumberFieldBox YOffsetTextField;
    private ToggleButton smallButton;
    private ToggleButton lockButton;
    private ToggleButton nameVisibleButton;
    private ToggleButton noGravityButton;
    private final NumberFieldBox[] poseTextFields = new NumberFieldBox[18];
    private Button doneButton;
    private Button cancelButton;

    public PlayerPoseScreen(PlayerStatue playerStatue) {
        super(NarratorChatListener.f_93310_);
        int i;
        this.playerStatueEntity = playerStatue;
        this.playerStatueData = new PlayerStatueData();
        this.playerStatueData.readNBT(this.playerStatueEntity.m_20240_(new CompoundTag()));
        for (i = 0; i < this.buttonLabels.length; ++i) {
            this.buttonLabels[i] = I18n.m_118938_((String)String.format("%s.playerstatue.gui.label." + this.buttonLabels[i], "statues"), (Object[])new Object[0]);
        }
        for (i = 0; i < this.sliderLabels.length; ++i) {
            this.sliderLabels[i] = I18n.m_118938_((String)String.format("%s.playerstatue.gui.label." + this.sliderLabels[i], "statues"), (Object[])new Object[0]);
        }
    }

    public static void openScreen(PlayerStatue playerStatue) {
        Minecraft.m_91087_().m_91152_((Screen)new PlayerPoseScreen(playerStatue));
    }

    protected void m_7856_() {
        super.m_7856_();
        int offsetX = 110;
        int offsetY = 50;
        this.smallButton = (ToggleButton)this.m_142416_((GuiEventListener)new ToggleButton(offsetX, offsetY, 40, 20, this.playerStatueData.isSmall(), button -> {
            ToggleButton toggleButton;
            toggleButton.setValue(!(toggleButton = (ToggleButton)button).getValue());
            this.textFieldUpdated();
        }));
        this.lockButton = (ToggleButton)this.m_142416_((GuiEventListener)new ToggleButton(offsetX, offsetY + 66, 40, 20, this.playerStatueData.isLocked(), button -> {
            ToggleButton toggleButton;
            toggleButton.setValue(!(toggleButton = (ToggleButton)button).getValue());
            this.textFieldUpdated();
        }));
        this.nameVisibleButton = (ToggleButton)this.m_142416_((GuiEventListener)new ToggleButton(offsetX, offsetY + 89, 40, 20, this.playerStatueData.getNameVisible(), button -> {
            ToggleButton toggleButton;
            toggleButton.setValue(!(toggleButton = (ToggleButton)button).getValue());
            this.textFieldUpdated();
        }));
        this.noGravityButton = (ToggleButton)this.m_142416_((GuiEventListener)new ToggleButton(offsetX, offsetY + 112, 40, 20, this.playerStatueData.hasNoGravity(), button -> {
            ToggleButton toggleButton;
            toggleButton.setValue(!(toggleButton = (ToggleButton)button).getValue());
            this.textFieldUpdated();
        }));
        this.rotationTextField = new NumberFieldBox(this.f_96547_, 1 + offsetX, 1 + offsetY + 22, 38, 17, (Component)new TextComponent("field.rotation"));
        this.rotationTextField.m_94144_(String.valueOf((int)this.playerStatueData.rotation));
        this.rotationTextField.m_94199_(3);
        this.m_7787_((GuiEventListener)this.rotationTextField);
        this.YOffsetTextField = new DecimalNumberFieldBox(this.f_96547_, 1 + offsetX, 1 + offsetY + 44, 38, 17, (Component)new TextComponent("field.yOffset"));
        this.YOffsetTextField.m_94144_(String.valueOf(Mth.m_14036_((float)this.playerStatueData.yOffset, (float)-1.0f, (float)1.0f)));
        this.YOffsetTextField.m_94199_(5);
        this.m_7787_((GuiEventListener)this.YOffsetTextField);
        offsetX = this.f_96543_ - 20 - 100;
        for (int i = 0; i < this.poseTextFields.length; ++i) {
            int x = 1 + offsetX + i % 3 * 35;
            int y = 1 + offsetY + i / 3 * 22;
            int width = 28;
            int height = 17;
            String value = String.valueOf((int)this.playerStatueData.pose[i]);
            this.poseTextFields[i] = new NumberFieldBox(this.f_96547_, x, y, width, height, (Component)new TextComponent(String.format("field.%s", i)));
            this.poseTextFields[i].m_94144_(value);
            this.poseTextFields[i].m_94199_(3);
            this.m_7787_((GuiEventListener)this.poseTextFields[i]);
        }
        offsetY = this.f_96544_ / 4 + 120 + 12;
        offsetX = this.f_96543_ - 20;
        this.doneButton = (Button)this.m_142416_((GuiEventListener)new Button(offsetX - 194, offsetY, 96, 20, (Component)new TranslatableComponent("gui.done"), button -> {
            this.updateEntity(this.writeFieldsToNBT());
            this.f_96541_.m_91152_((Screen)null);
        }));
        this.cancelButton = (Button)this.m_142416_((GuiEventListener)new Button(offsetX - 96, offsetY, 96, 20, (Component)new TranslatableComponent("gui.cancel"), button -> {
            this.updateEntity(this.playerStatueData.writeNBT());
            this.f_96541_.m_91152_((Screen)null);
        }));
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int y;
        int i;
        this.m_7333_(matrixStack);
        PlayerPoseScreen.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)String.format("%s.playerstatue.gui.title", "statues"), (Object[])new Object[0]), (int)(this.f_96543_ / 2), (int)20, (int)0xFFFFFF);
        this.rotationTextField.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.YOffsetTextField.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        for (NumberFieldBox textField : this.poseTextFields) {
            textField.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        }
        int offsetY = 50;
        int offsetX = 20;
        for (i = 0; i < this.buttonLabels.length; ++i) {
            int x = offsetX;
            Objects.requireNonNull(this.f_96547_);
            y = offsetY + i * 22 + (10 - 9 / 2);
            PlayerPoseScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)this.buttonLabels[i], (int)x, (int)y, (int)0xA0A0A0);
        }
        offsetX = this.f_96543_ - 20 - 100;
        PlayerPoseScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)"X", (int)offsetX, (int)37, (int)0xA0A0A0);
        PlayerPoseScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)"Y", (int)(offsetX + 35), (int)37, (int)0xA0A0A0);
        PlayerPoseScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)"Z", (int)(offsetX + 70), (int)37, (int)0xA0A0A0);
        for (i = 0; i < this.sliderLabels.length; ++i) {
            int x = offsetX - this.f_96547_.m_92895_(this.sliderLabels[i]) - 10;
            Objects.requireNonNull(this.f_96547_);
            y = offsetY + i * 22 + (10 - 9 / 2);
            PlayerPoseScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)this.sliderLabels[i], (int)x, (int)y, (int)0xA0A0A0);
        }
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void m_96624_() {
        super.m_96624_();
        this.rotationTextField.m_94120_();
        this.YOffsetTextField.m_94120_();
        for (NumberFieldBox textField : this.poseTextFields) {
            textField.m_94120_();
        }
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        boolean typed = super.m_5534_(codePoint, modifiers);
        if (typed) {
            this.textFieldUpdated();
        }
        return typed;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 15) {
            for (int i = 0; i < this.poseTextFields.length; ++i) {
                if (!this.poseTextFields[i].m_93696_()) continue;
                this.textFieldUpdated();
                this.poseTextFields[i].m_94201_();
                this.poseTextFields[i].m_93692_(false);
                int j = !Screen.m_96638_() ? (i == this.poseTextFields.length - 1 ? 0 : i + 1) : (i == 0 ? this.poseTextFields.length - 1 : i - 1);
                this.poseTextFields[j].m_93692_(true);
                this.poseTextFields[j].m_94192_(0);
                this.poseTextFields[j].m_94208_(this.poseTextFields[j].m_94155_().length());
            }
        } else {
            if (this.rotationTextField.m_7933_(keyCode, scanCode, modifiers)) {
                this.textFieldUpdated();
                return true;
            }
            if (this.YOffsetTextField.m_7933_(keyCode, scanCode, modifiers)) {
                this.textFieldUpdated();
                return true;
            }
            for (NumberFieldBox textField : this.poseTextFields) {
                if (!textField.m_7933_(keyCode, scanCode, modifiers)) continue;
                this.textFieldUpdated();
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.rotationTextField.m_6375_(mouseX, mouseY, button);
        this.YOffsetTextField.m_6375_(mouseX, mouseY, button);
        for (NumberFieldBox textField : this.poseTextFields) {
            textField.m_6375_(mouseX, mouseY, button);
            this.textFieldUpdated();
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected void textFieldUpdated() {
        this.updateEntity(this.writeFieldsToNBT());
    }

    private CompoundTag writeFieldsToNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128379_("Small", this.smallButton.getValue());
        compound.m_128379_("Locked", this.lockButton.getValue());
        compound.m_128379_("CustomNameVisible", this.nameVisibleButton.getValue());
        compound.m_128379_("NoGravity", this.noGravityButton.getValue());
        compound.m_128347_("yOffset", (double)this.YOffsetTextField.getFloat());
        ListTag rotationTag = new ListTag();
        rotationTag.add((Object)FloatTag.m_128566_((float)this.rotationTextField.getFloat()));
        compound.m_128365_("Rotation", (Tag)rotationTag);
        CompoundTag poseTag = new CompoundTag();
        ListTag poseHeadTag = new ListTag();
        poseHeadTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[0].getFloat()));
        poseHeadTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[1].getFloat()));
        poseHeadTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[2].getFloat()));
        poseTag.m_128365_("Head", (Tag)poseHeadTag);
        ListTag poseBodyTag = new ListTag();
        poseBodyTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[3].getFloat()));
        poseBodyTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[4].getFloat()));
        poseBodyTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[5].getFloat()));
        poseTag.m_128365_("Body", (Tag)poseBodyTag);
        ListTag poseLeftLegTag = new ListTag();
        poseLeftLegTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[6].getFloat()));
        poseLeftLegTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[7].getFloat()));
        poseLeftLegTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[8].getFloat()));
        poseTag.m_128365_("LeftLeg", (Tag)poseLeftLegTag);
        ListTag poseRightLegTag = new ListTag();
        poseRightLegTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[9].getFloat()));
        poseRightLegTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[10].getFloat()));
        poseRightLegTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[11].getFloat()));
        poseTag.m_128365_("RightLeg", (Tag)poseRightLegTag);
        ListTag poseLeftArmTag = new ListTag();
        poseLeftArmTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[12].getFloat()));
        poseLeftArmTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[13].getFloat()));
        poseLeftArmTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[14].getFloat()));
        poseTag.m_128365_("LeftArm", (Tag)poseLeftArmTag);
        ListTag poseRightArmTag = new ListTag();
        poseRightArmTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[15].getFloat()));
        poseRightArmTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[16].getFloat()));
        poseRightArmTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[17].getFloat()));
        poseTag.m_128365_("RightArm", (Tag)poseRightArmTag);
        compound.m_128365_("Pose", (Tag)poseTag);
        return compound;
    }

    private void updateEntity(CompoundTag compound) {
        CompoundTag CompoundTag2 = this.playerStatueEntity.m_20240_(new CompoundTag()).m_6426_();
        CompoundTag2.m_128391_(compound);
        this.playerStatueEntity.m_20258_(CompoundTag2);
        StatuesNetworking.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new PlayerStatueSyncMessage(this.playerStatueEntity.m_142081_(), compound));
    }

    public boolean m_7043_() {
        return false;
    }
}

