/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.datagen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.init.StatueRegistry;
import com.shynieke.statues.init.StatueTags;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.EntityLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class StatuesDataGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.m_123914_((DataProvider)new StatueLoot(generator));
            StatueBlockTags blockTags = new StatueBlockTags(generator, event.getExistingFileHelper());
            generator.m_123914_((DataProvider)blockTags);
            generator.m_123914_((DataProvider)new StatueItemTags(generator, blockTags, event.getExistingFileHelper()));
        }
        if (event.includeClient()) {
            generator.m_123914_((DataProvider)new StatueItemModels(generator, helper));
        }
    }

    private static class StatueLoot
    extends LootTableProvider {
        public StatueLoot(DataGenerator gen) {
            super(gen);
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
            return ImmutableList.of((Object)Pair.of(() -> new StatueBlocks(), (Object)LootContextParamSets.f_81421_), (Object)Pair.of(() -> new StatueEntities(), (Object)LootContextParamSets.f_81415_));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
            map.forEach((name, table) -> LootTables.m_79202_((ValidationContext)validationtracker, (ResourceLocation)name, (LootTable)table));
        }

        private class StatueEntities
        extends EntityLoot {
            private StatueEntities() {
            }

            protected void addTables() {
                this.m_124371_((EntityType)StatueRegistry.PLAYER_STATUE_ENTITY.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)StatueRegistry.STATUE_CORE.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)1.0f)))).m_6509_(LootItemKilledByPlayerCondition.m_81901_())));
                this.m_124371_((EntityType)StatueRegistry.STATUE_BAT.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)StatueRegistry.STATUE_CORE.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)))).m_6509_(LootItemKilledByPlayerCondition.m_81901_())));
            }

            protected boolean isNonLiving(EntityType<?> entitytype) {
                return false;
            }

            protected Iterable<EntityType<?>> getKnownEntities() {
                return StatueRegistry.ENTITIES.getEntries().stream().map(RegistryObject::get)::iterator;
            }
        }

        private class StatueBlocks
        extends BlockLoot {
            private StatueBlocks() {
            }

            protected void addTables() {
                this.m_124175_((Block)StatueRegistry.PEBBLE.get(), block -> StatueBlocks.m_124168_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)StatueBlocks.m_124134_((ItemLike)block, (ConditionUserBuilder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42484_).m_6509_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.1f, 0.14285715f, 0.25f, 1.0f}))).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block))))));
                this.m_124288_((Block)StatueRegistry.DISPLAY_STAND.get());
                this.m_124288_((Block)StatueRegistry.SOMBRERO.get());
                this.m_124288_((Block)StatueRegistry.INFO_STATUE.get());
                this.m_124165_((Block)StatueRegistry.PLAYER_STATUE.get(), StatueBlocks.m_124292_((Block)((Block)StatueRegistry.PLAYER_STATUE.get())));
                for (RegistryObject blockObject : StatueRegistry.BLOCKS.getEntries()) {
                    if (!(blockObject.get() instanceof AbstractStatueBase)) continue;
                    AbstractStatueBase base = (AbstractStatueBase)blockObject.get();
                    if (base.canBeUpgraded()) {
                        this.m_124165_((Block)blockObject.get(), StatueBlocks.m_124292_((Block)((Block)blockObject.get())));
                        continue;
                    }
                    this.m_124288_((Block)blockObject.get());
                }
            }

            protected Iterable<Block> getKnownBlocks() {
                return StatueRegistry.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
            }
        }
    }

    private static class StatueBlockTags
    extends BlockTagsProvider {
        public StatueBlockTags(DataGenerator generator, @Nullable ExistingFileHelper existingFileHelper) {
            super(generator, "statues", existingFileHelper);
        }

        protected void m_6577_() {
            this.m_126548_(StatueTags.STATUE_BLOCKS).m_126584_((Object[])new Block[]{(Block)StatueRegistry.ANGRY_BEE_STATUE.get(), (Block)StatueRegistry.BABY_ZOMBIE_STATUE.get(), (Block)StatueRegistry.BEE_STATUE.get(), (Block)StatueRegistry.TRANS_BEE.get(), (Block)StatueRegistry.BLAZE_STATUE.get(), (Block)StatueRegistry.BROWN_MOOSHROOM_STATUE.get(), (Block)StatueRegistry.CAMPFIRE_STATUE.get(), (Block)StatueRegistry.CAT_BLACK_STATUE.get(), (Block)StatueRegistry.CAT_BRITISH_SHORTHAIR_STATUE.get(), (Block)StatueRegistry.CAT_CALICO_STATUE.get(), (Block)StatueRegistry.CAT_JELLIE_STATUE.get(), (Block)StatueRegistry.CAT_PERSIAN_STATUE.get(), (Block)StatueRegistry.CAT_RAGDOLL_STATUE.get(), (Block)StatueRegistry.CAT_RED_STATUE.get(), (Block)StatueRegistry.CAT_SIAMESE_STATUE.get(), (Block)StatueRegistry.CAT_TABBY_STATUE.get(), (Block)StatueRegistry.CAT_TUXEDO_STATUE.get(), (Block)StatueRegistry.CAT_WHITE_STATUE.get(), (Block)StatueRegistry.CHICKEN_JOCKEY_STATUE.get(), (Block)StatueRegistry.CHICKEN_STATUE.get(), (Block)StatueRegistry.COD_STATUE.get(), (Block)StatueRegistry.COW_STATUE.get(), (Block)StatueRegistry.CREEPER_STATUE.get(), (Block)StatueRegistry.DETECTIVE_PLATYPUS.get(), (Block)StatueRegistry.DOLPHIN_STATUE.get(), (Block)StatueRegistry.DROWNED_STATUE.get(), (Block)StatueRegistry.ELDER_GUARDIAN_STATUE.get(), (Block)StatueRegistry.ENDERMAN_STATUE.get(), (Block)StatueRegistry.ENDERMITE_STATUE.get(), (Block)StatueRegistry.EVOKER_STATUE.get(), (Block)StatueRegistry.FLOOD_STATUE.get(), (Block)StatueRegistry.FOX_SNOW_STATUE.get(), (Block)StatueRegistry.FOX_STATUE.get(), (Block)StatueRegistry.GHAST_STATUE.get(), (Block)StatueRegistry.GUARDIAN_STATUE.get(), (Block)StatueRegistry.HUSK_STATUE.get(), (Block)StatueRegistry.INFO_STATUE.get(), (Block)StatueRegistry.KING_CLUCK_STATUE.get(), (Block)StatueRegistry.MAGMA_STATUE.get(), (Block)StatueRegistry.MOOSHROOM_STATUE.get(), (Block)StatueRegistry.PANDA_ANGRY_STATUE.get(), (Block)StatueRegistry.PANDA_BROWN_STATUE.get(), (Block)StatueRegistry.PANDA_LAZY_STATUE.get(), (Block)StatueRegistry.PANDA_NORMAL_STATUE.get(), (Block)StatueRegistry.PANDA_PLAYFUL_STATUE.get(), (Block)StatueRegistry.PANDA_WEAK_STATUE.get(), (Block)StatueRegistry.PANDA_WORRIED_STATUE.get(), (Block)StatueRegistry.PIG_STATUE.get(), (Block)StatueRegistry.PILLAGER_STATUE.get(), (Block)StatueRegistry.PLAYER_STATUE.get(), (Block)StatueRegistry.PUFFERFISH_MEDIUM_STATUE.get(), (Block)StatueRegistry.PUFFERFISH_SMALL_STATUE.get(), (Block)StatueRegistry.PUFFERFISH_STATUE.get(), (Block)StatueRegistry.RABBIT_BR_STATUE.get(), (Block)StatueRegistry.RABBIT_BS_STATUE.get(), (Block)StatueRegistry.RABBIT_BW_STATUE.get(), (Block)StatueRegistry.RABBIT_GO_STATUE.get(), (Block)StatueRegistry.RABBIT_WH_STATUE.get(), (Block)StatueRegistry.RABBIT_WS_STATUE.get(), (Block)StatueRegistry.RAVAGER_STATUE.get(), (Block)StatueRegistry.SALMON_STATUE.get(), (Block)StatueRegistry.SHEEP_SHAVEN_STATUE.get(), (Block)StatueRegistry.SHEEP_STATUE_BLACK.get(), (Block)StatueRegistry.SHEEP_STATUE_BLUE.get(), (Block)StatueRegistry.SHEEP_STATUE_BROWN.get(), (Block)StatueRegistry.SHEEP_STATUE_CYAN.get(), (Block)StatueRegistry.SHEEP_STATUE_GRAY.get(), (Block)StatueRegistry.SHEEP_STATUE_GREEN.get(), (Block)StatueRegistry.SHEEP_STATUE_LIGHT_BLUE.get(), (Block)StatueRegistry.SHEEP_STATUE_LIGHT_GRAY.get(), (Block)StatueRegistry.SHEEP_STATUE_LIME.get(), (Block)StatueRegistry.SHEEP_STATUE_MAGENTA.get(), (Block)StatueRegistry.SHEEP_STATUE_ORANGE.get(), (Block)StatueRegistry.SHEEP_STATUE_PINK.get(), (Block)StatueRegistry.SHEEP_STATUE_PURPLE.get(), (Block)StatueRegistry.SHEEP_STATUE_RED.get(), (Block)StatueRegistry.SHEEP_STATUE_WHITE.get(), (Block)StatueRegistry.SHEEP_STATUE_YELLOW.get(), (Block)StatueRegistry.SHULKER_STATUE.get(), (Block)StatueRegistry.SLIME_STATUE.get(), (Block)StatueRegistry.SNOW_GOLEM_STATUE.get(), (Block)StatueRegistry.SPIDER_STATUE.get(), (Block)StatueRegistry.SQUID_STATUE.get(), (Block)StatueRegistry.TOTEM_OF_UNDYING_STATUE.get(), (Block)StatueRegistry.TROPICAL_FISH_B.get(), (Block)StatueRegistry.TROPICAL_FISH_BB.get(), (Block)StatueRegistry.TROPICAL_FISH_BE.get(), (Block)StatueRegistry.TROPICAL_FISH_BM.get(), (Block)StatueRegistry.TROPICAL_FISH_BMB.get(), (Block)StatueRegistry.TROPICAL_FISH_BMS.get(), (Block)StatueRegistry.TROPICAL_FISH_E.get(), (Block)StatueRegistry.TROPICAL_FISH_ES.get(), (Block)StatueRegistry.TROPICAL_FISH_HB.get(), (Block)StatueRegistry.TROPICAL_FISH_SB.get(), (Block)StatueRegistry.TROPICAL_FISH_SD.get(), (Block)StatueRegistry.TROPICAL_FISH_SS.get(), (Block)StatueRegistry.TURTLE_STATUE.get(), (Block)StatueRegistry.VILLAGER_BR_STATUE.get(), (Block)StatueRegistry.VILLAGER_GR_STATUE.get(), (Block)StatueRegistry.VILLAGER_PU_STATUE.get(), (Block)StatueRegistry.VILLAGER_WH_STATUE.get(), (Block)StatueRegistry.VINDICATOR_STATUE.get(), (Block)StatueRegistry.WASTELAND_STATUE.get(), (Block)StatueRegistry.WITCH_STATUE.get(), (Block)StatueRegistry.ZOMBIE_STATUE.get(), (Block)StatueRegistry.BUMBO_STATUE.get(), (Block)StatueRegistry.DISPLAY_STAND.get(), (Block)StatueRegistry.TROPIBEE.get(), (Block)StatueRegistry.EAGLE_RAY.get(), (Block)StatueRegistry.SLABFISH.get()});
        }
    }

    private static class StatueItemTags
    extends ItemTagsProvider {
        public StatueItemTags(DataGenerator generator, BlockTagsProvider tagsProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(generator, tagsProvider, "statues", existingFileHelper);
        }

        protected void m_6577_() {
            this.m_126533_(StatueTags.STATUE_BLOCKS, StatueTags.STATUES_ITEMS);
        }
    }

    private static class StatueItemModels
    extends ItemModelProvider {
        public StatueItemModels(DataGenerator gen, ExistingFileHelper helper) {
            super(gen, "statues", helper);
        }

        protected void registerModels() {
        }

        public String m_6055_() {
            return "Item Models";
        }
    }
}

