/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.handlers;

import com.shynieke.statues.Statues;
import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.blocks.statues.SheepStatueBlock;
import com.shynieke.statues.config.StatuesConfig;
import com.shynieke.statues.init.StatueRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class DropHandler {
    private static final Random rand = new Random();

    @SubscribeEvent
    public void onLivingDrop(LivingDropsEvent event) {
        Entity block;
        Sheep sheep;
        Entity entity = event.getEntity();
        Entity source = event.getSource().m_7639_();
        if (entity instanceof Villager) {
            switch (entity.f_19853_.f_46441_.nextInt(4)) {
                default: {
                    this.dropLootStatues(entity, new ItemStack((ItemLike)StatueRegistry.VILLAGER_BR_STATUE.get()), source, event);
                    break;
                }
                case 1: {
                    this.dropLootStatues(entity, new ItemStack((ItemLike)StatueRegistry.VILLAGER_WH_STATUE.get()), source, event);
                    break;
                }
                case 2: {
                    this.dropLootStatues(entity, new ItemStack((ItemLike)StatueRegistry.VILLAGER_PU_STATUE.get()), source, event);
                    break;
                }
                case 3: {
                    this.dropLootStatues(entity, new ItemStack((ItemLike)StatueRegistry.VILLAGER_GR_STATUE.get()), source, event);
                    break;
                }
            }
        } else if (entity instanceof Evoker) {
            itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.EVOKER_STATUE.get());
            this.dropLootStatues(entity, (ItemStack)itemStackToDrop, source, event);
        } else if (entity instanceof Vindicator) {
            itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.VINDICATOR_STATUE.get());
            this.dropLootStatues(entity, (ItemStack)itemStackToDrop, source, event);
        } else {
            itemStackToDrop = entity;
            if (itemStackToDrop instanceof Sheep) {
                sheep = (Sheep)itemStackToDrop;
                itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.SHEEP_SHAVEN_STATUE.get());
                if (!sheep.m_29875_()) {
                    itemStackToDrop = new ItemStack((ItemLike)SheepStatueBlock.getStatue(sheep.m_29874_()));
                }
                this.dropLootStatues(entity, (ItemStack)itemStackToDrop, source, event);
            } else {
                itemStackToDrop = entity;
                if (itemStackToDrop instanceof Bee) {
                    Bee bee = (Bee)itemStackToDrop;
                    itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.BEE_STATUE.get());
                    if (entity.f_19853_.f_46441_.nextBoolean()) {
                        itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.ANGRY_BEE_STATUE.get());
                    }
                    String trans = "Trans Bee";
                    if (bee.m_5446_().m_6111_().equalsIgnoreCase(trans)) {
                        itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.BEE_STATUE.get());
                        itemStackToDrop.m_41714_((Component)new TextComponent(trans));
                    }
                    String tropi = "Tropibee";
                    if (bee.m_5446_().m_6111_().equalsIgnoreCase(trans)) {
                        itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.BEE_STATUE.get());
                        itemStackToDrop.m_41714_((Component)new TextComponent(tropi));
                    }
                    this.dropLootStatues(entity, (ItemStack)itemStackToDrop, source, event);
                } else {
                    itemStackToDrop = entity;
                    if (itemStackToDrop instanceof Rabbit) {
                        Rabbit rabbit = (Rabbit)itemStackToDrop;
                        new ItemStack((ItemLike)StatueRegistry.RABBIT_BR_STATUE.get());
                        itemStackToDrop = switch (rabbit.m_29719_()) {
                            case 1 -> new ItemStack((ItemLike)StatueRegistry.RABBIT_WH_STATUE.get());
                            case 2 -> new ItemStack((ItemLike)StatueRegistry.RABBIT_WS_STATUE.get());
                            case 3 -> new ItemStack((ItemLike)StatueRegistry.RABBIT_BS_STATUE.get());
                            case 4 -> new ItemStack((ItemLike)StatueRegistry.RABBIT_GO_STATUE.get());
                            case 5 -> new ItemStack((ItemLike)StatueRegistry.RABBIT_BW_STATUE.get());
                            default -> new ItemStack((ItemLike)StatueRegistry.RABBIT_BR_STATUE.get());
                        };
                        this.dropLootStatues(entity, (ItemStack)itemStackToDrop, source, event);
                    } else {
                        itemStackToDrop = entity;
                        if (itemStackToDrop instanceof Panda) {
                            Panda panda = (Panda)itemStackToDrop;
                            new ItemStack((ItemLike)StatueRegistry.PANDA_NORMAL_STATUE.get());
                            itemStackToDrop = switch (panda.m_29154_()) {
                                case Panda.Gene.AGGRESSIVE -> new ItemStack((ItemLike)StatueRegistry.PANDA_ANGRY_STATUE.get());
                                case Panda.Gene.BROWN -> new ItemStack((ItemLike)StatueRegistry.PANDA_BROWN_STATUE.get());
                                case Panda.Gene.LAZY -> new ItemStack((ItemLike)StatueRegistry.PANDA_LAZY_STATUE.get());
                                case Panda.Gene.PLAYFUL -> new ItemStack((ItemLike)StatueRegistry.PANDA_PLAYFUL_STATUE.get());
                                case Panda.Gene.WEAK -> new ItemStack((ItemLike)StatueRegistry.PANDA_WEAK_STATUE.get());
                                case Panda.Gene.WORRIED -> new ItemStack((ItemLike)StatueRegistry.PANDA_WORRIED_STATUE.get());
                                default -> new ItemStack((ItemLike)StatueRegistry.PANDA_NORMAL_STATUE.get());
                            };
                            this.dropLootStatues(entity, (ItemStack)itemStackToDrop, source, event);
                        } else {
                            itemStackToDrop = entity;
                            if (itemStackToDrop instanceof Cat) {
                                Cat cat = (Cat)itemStackToDrop;
                                new ItemStack((ItemLike)StatueRegistry.CAT_TABBY_STATUE.get());
                                itemStackToDrop = switch (cat.m_28163_()) {
                                    case 1 -> new ItemStack((ItemLike)StatueRegistry.CAT_TUXEDO_STATUE.get());
                                    case 2 -> new ItemStack((ItemLike)StatueRegistry.CAT_RED_STATUE.get());
                                    case 3 -> new ItemStack((ItemLike)StatueRegistry.CAT_SIAMESE_STATUE.get());
                                    case 4 -> new ItemStack((ItemLike)StatueRegistry.CAT_BRITISH_SHORTHAIR_STATUE.get());
                                    case 5 -> new ItemStack((ItemLike)StatueRegistry.CAT_CALICO_STATUE.get());
                                    case 6 -> new ItemStack((ItemLike)StatueRegistry.CAT_PERSIAN_STATUE.get());
                                    case 7 -> new ItemStack((ItemLike)StatueRegistry.CAT_RAGDOLL_STATUE.get());
                                    case 8 -> new ItemStack((ItemLike)StatueRegistry.CAT_WHITE_STATUE.get());
                                    case 9 -> new ItemStack((ItemLike)StatueRegistry.CAT_JELLIE_STATUE.get());
                                    case 10 -> new ItemStack((ItemLike)StatueRegistry.CAT_BLACK_STATUE.get());
                                    default -> new ItemStack((ItemLike)StatueRegistry.CAT_TABBY_STATUE.get());
                                };
                                this.dropLootStatues(entity, (ItemStack)itemStackToDrop, source, event);
                            } else if (entity instanceof ElderGuardian) {
                                itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.ELDER_GUARDIAN_STATUE.get());
                                this.dropBossStatue(entity, (ItemStack)itemStackToDrop, source, event);
                            } else if (entity instanceof Ravager) {
                                itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.RAVAGER_STATUE.get());
                                if (rand.nextFloat() <= 0.25f) {
                                    this.dropBossStatue(entity, (ItemStack)itemStackToDrop, source, event);
                                }
                            } else {
                                itemStackToDrop = entity;
                                if (itemStackToDrop instanceof MushroomCow) {
                                    MushroomCow mooshroom = (MushroomCow)itemStackToDrop;
                                    itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.MOOSHROOM_STATUE.get());
                                    if (mooshroom.m_28955_() == MushroomCow.MushroomType.BROWN) {
                                        itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.BROWN_MOOSHROOM_STATUE.get());
                                    }
                                    this.dropLootStatues(entity, (ItemStack)itemStackToDrop, source, event);
                                } else {
                                    itemStackToDrop = entity;
                                    if (itemStackToDrop instanceof Fox) {
                                        Fox fox = (Fox)itemStackToDrop;
                                        itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.FOX_STATUE.get());
                                        if (fox.m_28554_() == Fox.Type.SNOW) {
                                            itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.FOX_SNOW_STATUE.get());
                                        }
                                        this.dropLootStatues(entity, (ItemStack)itemStackToDrop, source, event);
                                    } else {
                                        ArrayList<RegistryObject> matchingStatues = new ArrayList<RegistryObject>();
                                        for (RegistryObject block2 : StatueRegistry.BLOCKS.getEntries()) {
                                            AbstractStatueBase statue;
                                            IForgeRegistryEntry iForgeRegistryEntry = block2.get();
                                            if (!(iForgeRegistryEntry instanceof AbstractStatueBase) || !(statue = (AbstractStatueBase)iForgeRegistryEntry).getEntity().equals((Object)entity.m_6095_()) || statue.isHiddenStatue()) continue;
                                            matchingStatues.add(block2);
                                        }
                                        if (!matchingStatues.isEmpty()) {
                                            block = (RegistryObject)matchingStatues.get(rand.nextInt(matchingStatues.size()));
                                            AbstractStatueBase statue = (AbstractStatueBase)block.get();
                                            ItemStack itemStackToDrop = new ItemStack((ItemLike)statue);
                                            if (entity instanceof Mob) {
                                                if (((Mob)entity).m_6162_() == statue.isBaby()) {
                                                    this.dropLootStatues(entity, itemStackToDrop, source, event);
                                                }
                                            } else {
                                                this.dropLootStatues(entity, itemStackToDrop, source, event);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (((Boolean)StatuesConfig.COMMON.playerDropsStatue.get()).booleanValue() && (sheep = entity) instanceof Player) {
            Player player = (Player)sheep;
            ItemStack playerStatueStack = new ItemStack((ItemLike)StatueRegistry.PLAYER_STATUE.get()).m_41714_(player.m_7755_());
            double random_drop = Math.random();
            double playerDropChance = (Double)StatuesConfig.COMMON.playerStatueDropChance.get();
            BlockPos entityPos = entity.m_142538_();
            switch ((StatuesConfig.EnumDeathSource)((Object)StatuesConfig.COMMON.playerStatueKillSource.get())) {
                default: {
                    block = source;
                    if (!(block instanceof ServerPlayer)) break;
                    ServerPlayer sourcePlayer = (ServerPlayer)block;
                    if (source instanceof FakePlayer) break;
                    List luckyPlayers = (List)StatuesConfig.COMMON.lucky_players.get();
                    if (!luckyPlayers.isEmpty()) {
                        for (String luckyName : luckyPlayers) {
                            String user = sourcePlayer.m_7755_().m_6111_();
                            if (luckyName.isEmpty() || !user.equals(luckyName)) continue;
                            playerDropChance = (Double)StatuesConfig.COMMON.playerStatueDropChance.get() / 4.0;
                        }
                    }
                    if (!(random_drop <= playerDropChance)) break;
                    event.getDrops().add(new ItemEntity(entity.f_19853_, (double)entityPos.m_123341_(), (double)entityPos.m_123342_(), (double)entityPos.m_123343_(), playerStatueStack));
                    break;
                }
                case PLAYER_FAKEPLAYER: {
                    if (!(source instanceof ServerPlayer) || !(random_drop <= playerDropChance)) break;
                    event.getDrops().add(new ItemEntity(entity.f_19853_, (double)entityPos.m_123341_(), (double)entityPos.m_123342_(), (double)entityPos.m_123343_(), playerStatueStack));
                    break;
                }
                case ALL: {
                    if (!(random_drop <= playerDropChance)) break;
                    event.getDrops().add(new ItemEntity(entity.f_19853_, (double)entityPos.m_123341_(), (double)entityPos.m_123342_(), (double)entityPos.m_123343_(), playerStatueStack));
                }
            }
        }
    }

    public void dropBossStatue(Entity entity, ItemStack itemStackToDrop, Entity source, LivingDropsEvent event) {
        BlockPos entityPos = entity.m_142538_();
        switch ((StatuesConfig.EnumDeathSource)((Object)StatuesConfig.COMMON.statueKillSource.get())) {
            default: {
                if (!(source instanceof ServerPlayer) || source instanceof FakePlayer) break;
                event.getDrops().add(new ItemEntity(entity.f_19853_, (double)entityPos.m_123341_(), (double)entityPos.m_123342_(), (double)entityPos.m_123343_(), itemStackToDrop));
                break;
            }
            case PLAYER_FAKEPLAYER: {
                if (!(source instanceof ServerPlayer)) break;
                event.getDrops().add(new ItemEntity(entity.f_19853_, (double)entityPos.m_123341_(), (double)entityPos.m_123342_(), (double)entityPos.m_123343_(), itemStackToDrop));
                break;
            }
            case ALL: {
                event.getDrops().add(new ItemEntity(entity.f_19853_, (double)entityPos.m_123341_(), (double)entityPos.m_123342_(), (double)entityPos.m_123343_(), itemStackToDrop));
            }
        }
    }

    public void dropLootStatues(Entity entity, ItemStack itemStackToDrop, Entity source, LivingDropsEvent event) {
        double random_drop = Math.random();
        double default_drop_chance = (Double)StatuesConfig.COMMON.statueDropChance.get();
        Statues.LOGGER.info((Object)itemStackToDrop);
        BlockPos entityPos = entity.m_142538_();
        switch ((StatuesConfig.EnumDeathSource)((Object)StatuesConfig.COMMON.statueKillSource.get())) {
            default: {
                Entity entity2 = source;
                if (!(entity2 instanceof ServerPlayer)) break;
                ServerPlayer player = (ServerPlayer)entity2;
                if (source instanceof FakePlayer) break;
                List luckyPlayers = (List)StatuesConfig.COMMON.lucky_players.get();
                if (!luckyPlayers.isEmpty()) {
                    for (String luckyName : luckyPlayers) {
                        String user = player.m_7755_().m_6111_();
                        if (luckyName.isEmpty() || !user.equals(luckyName)) continue;
                        default_drop_chance = (Double)StatuesConfig.COMMON.statueDropChance.get() / 4.0;
                    }
                }
                if (!(random_drop <= default_drop_chance)) break;
                event.getDrops().add(new ItemEntity(entity.f_19853_, (double)entityPos.m_123341_(), (double)entityPos.m_123342_(), (double)entityPos.m_123343_(), itemStackToDrop));
                break;
            }
            case PLAYER_FAKEPLAYER: {
                if (!(source instanceof ServerPlayer) || !(random_drop <= default_drop_chance)) break;
                event.getDrops().add(new ItemEntity(entity.f_19853_, (double)entityPos.m_123341_(), (double)entityPos.m_123342_(), (double)entityPos.m_123343_(), itemStackToDrop));
                break;
            }
            case ALL: {
                if (!(random_drop <= default_drop_chance)) break;
                event.getDrops().add(new ItemEntity(entity.f_19853_, (double)entityPos.m_123341_(), (double)entityPos.m_123342_(), (double)entityPos.m_123343_(), itemStackToDrop));
            }
        }
    }
}

