/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.packets;

import com.shynieke.statues.client.screen.PlayerPoseScreen;
import com.shynieke.statues.entity.PlayerStatue;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class PlayerStatueScreenMessage {
    private int entityID;

    private PlayerStatueScreenMessage(FriendlyByteBuf buf) {
        this.entityID = buf.readInt();
    }

    public PlayerStatueScreenMessage(int playerUUID) {
        this.entityID = playerUUID;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
    }

    public static PlayerStatueScreenMessage decode(FriendlyByteBuf packetBuffer) {
        return new PlayerStatueScreenMessage(packetBuffer.readInt());
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            if (ctx.getDirection().getReceptionSide().isClient()) {
                Minecraft mc = Minecraft.m_91087_();
                Entity entity = mc.f_91073_.m_6815_(this.entityID);
                if (entity instanceof PlayerStatue) {
                    PlayerStatue playerStatue = (PlayerStatue)entity;
                    PlayerPoseScreen.openScreen(playerStatue);
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

